/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.libs.drivers.mysql.cj.protocol.a.authentication;

import com.itsschatten.libs.drivers.mysql.cj.callback.MysqlCallbackHandler;
import com.itsschatten.libs.drivers.mysql.cj.callback.UsernameCallback;
import com.itsschatten.libs.drivers.mysql.cj.protocol.AuthenticationPlugin;
import com.itsschatten.libs.drivers.mysql.cj.protocol.Protocol;
import com.itsschatten.libs.drivers.mysql.cj.protocol.a.NativeConstants;
import com.itsschatten.libs.drivers.mysql.cj.protocol.a.NativePacketPayload;
import com.itsschatten.libs.drivers.mysql.cj.util.StringUtils;
import java.util.List;

public class MysqlClearPasswordPlugin
implements AuthenticationPlugin<NativePacketPayload> {
    public static String PLUGIN_NAME = "mysql_clear_password";
    private Protocol<NativePacketPayload> protocol = null;
    private MysqlCallbackHandler usernameCallbackHandler = null;
    private String password = null;

    @Override
    public void init(Protocol<NativePacketPayload> prot, MysqlCallbackHandler cbh) {
        this.protocol = prot;
        this.usernameCallbackHandler = cbh;
    }

    @Override
    public void destroy() {
        this.reset();
        this.protocol = null;
        this.usernameCallbackHandler = null;
        this.password = null;
    }

    @Override
    public String getProtocolPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public boolean requiresConfidentiality() {
        return true;
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    @Override
    public void setAuthenticationParameters(String user, String password) {
        this.password = password;
        if (user == null && this.usernameCallbackHandler != null) {
            this.usernameCallbackHandler.handle(new UsernameCallback(System.getProperty("user.name")));
        }
    }

    @Override
    public boolean nextAuthenticationStep(NativePacketPayload fromServer, List<NativePacketPayload> toServer) {
        toServer.clear();
        String encoding = this.protocol.getServerSession().getCharsetSettings().getPasswordCharacterEncoding();
        NativePacketPayload packet = new NativePacketPayload(StringUtils.getBytes(this.password != null ? this.password : "", encoding));
        packet.setPosition(packet.getPayloadLength());
        packet.writeInteger(NativeConstants.IntegerDataType.INT1, 0L);
        packet.setPosition(0);
        toServer.add(packet);
        return true;
    }
}

