/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.libs.drivers.mysql.cj.xdevapi;

import com.itsschatten.libs.drivers.mysql.cj.MysqlxSession;
import com.itsschatten.libs.drivers.mysql.cj.conf.PropertySet;
import com.itsschatten.libs.drivers.mysql.cj.exceptions.CJCommunicationsException;
import com.itsschatten.libs.drivers.mysql.cj.protocol.ColumnDefinition;
import com.itsschatten.libs.drivers.mysql.cj.protocol.ProtocolEntity;
import com.itsschatten.libs.drivers.mysql.cj.protocol.ResultBuilder;
import com.itsschatten.libs.drivers.mysql.cj.protocol.x.Notice;
import com.itsschatten.libs.drivers.mysql.cj.protocol.x.StatementExecuteOk;
import com.itsschatten.libs.drivers.mysql.cj.protocol.x.StatementExecuteOkBuilder;
import com.itsschatten.libs.drivers.mysql.cj.protocol.x.XProtocol;
import com.itsschatten.libs.drivers.mysql.cj.protocol.x.XProtocolRowInputStream;
import com.itsschatten.libs.drivers.mysql.cj.result.Field;
import com.itsschatten.libs.drivers.mysql.cj.xdevapi.SqlMultiResult;
import com.itsschatten.libs.drivers.mysql.cj.xdevapi.SqlResult;
import com.itsschatten.libs.drivers.mysql.cj.xdevapi.SqlResultBuilder;
import com.itsschatten.libs.drivers.mysql.cj.xdevapi.SqlSingleResult;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class StreamingSqlResultBuilder
implements ResultBuilder<SqlResult> {
    TimeZone defaultTimeZone;
    PropertySet pset;
    XProtocol protocol;
    StatementExecuteOkBuilder statementExecuteOkBuilder = new StatementExecuteOkBuilder();
    boolean isRowResult = false;
    ProtocolEntity lastEntity = null;
    List<SqlSingleResult> resultSets = new ArrayList<SqlSingleResult>();
    private SqlResult result;

    public StreamingSqlResultBuilder(MysqlxSession sess) {
        this.defaultTimeZone = sess.getServerSession().getDefaultTimeZone();
        this.pset = sess.getPropertySet();
        this.protocol = sess.getProtocol();
    }

    @Override
    public boolean addProtocolEntity(ProtocolEntity entity) {
        if (entity instanceof Notice) {
            this.statementExecuteOkBuilder.addProtocolEntity(entity);
        } else {
            this.lastEntity = entity;
        }
        AtomicBoolean readLastResult = new AtomicBoolean(false);
        Supplier<ProtocolEntity> okReader = () -> {
            if (readLastResult.get()) {
                throw new CJCommunicationsException("Invalid state attempting to read ok packet");
            }
            if (this.protocol.hasMoreResults()) {
                StatementExecuteOk res = this.statementExecuteOkBuilder.build();
                this.statementExecuteOkBuilder = new StatementExecuteOkBuilder();
                return res;
            }
            readLastResult.set(true);
            return this.protocol.readQueryResult(this.statementExecuteOkBuilder);
        };
        Supplier<SqlResult> resultStream = () -> {
            if (readLastResult.get()) {
                return null;
            }
            if (this.lastEntity != null && this.lastEntity instanceof Field || this.protocol.isSqlResultPending()) {
                ColumnDefinition cd;
                if (this.lastEntity != null && this.lastEntity instanceof Field) {
                    cd = this.protocol.readMetadata((Field)this.lastEntity, n -> this.statementExecuteOkBuilder.addProtocolEntity((ProtocolEntity)n));
                    this.lastEntity = null;
                } else {
                    cd = this.protocol.readMetadata(this.statementExecuteOkBuilder::addProtocolEntity);
                }
                return new SqlSingleResult(cd, this.protocol.getServerSession().getDefaultTimeZone(), new XProtocolRowInputStream(cd, this.protocol, n -> this.statementExecuteOkBuilder.addProtocolEntity((ProtocolEntity)n)), okReader, this.pset);
            }
            readLastResult.set(true);
            SqlResultBuilder rb = new SqlResultBuilder(this.defaultTimeZone, this.pset);
            rb.addProtocolEntity(entity);
            return this.protocol.readQueryResult(rb);
        };
        this.result = new SqlMultiResult(resultStream);
        return true;
    }

    @Override
    public SqlResult build() {
        return this.result;
    }
}

