/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.libs.inventories;

import com.itsschatten.libs.Utils;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class InventoryUtils {
    public static void createItem(@NotNull Inventory inv, int where, Material mat, int amount, String name, List<String> lore) {
        ItemStack item = new ItemStack(mat, amount);
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        itemMeta.setDisplayName(Utils.colorize(name));
        itemMeta.setLore(lore);
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(itemMeta);
        inv.setItem(where - 1, item);
    }

    public static void createItem(@NotNull Inventory inv, int where, Material mat, int amount, String name) {
        ItemStack item = new ItemStack(mat, amount);
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        itemMeta.setDisplayName(Utils.colorize(name));
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(itemMeta);
        inv.setItem(where - 1, item);
    }

    public static void createItem(@NotNull Inventory inv, int where, Material mat, int amount, boolean glow, String name, List<String> lore) {
        ItemStack item = new ItemStack(mat, amount);
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        itemMeta.setDisplayName(Utils.colorize(name));
        if (glow) {
            itemMeta.addEnchant(Enchantment.POWER, 1, true);
        }
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS});
        itemMeta.setLore(lore);
        item.setItemMeta(itemMeta);
        inv.setItem(where - 1, item);
    }

    public static void createItem(@NotNull Inventory inv, int where, Material mat, int amount, boolean glow, String name) {
        ItemStack item = new ItemStack(mat, amount);
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        itemMeta.setDisplayName(Utils.colorize(name));
        if (glow) {
            itemMeta.addEnchant(Enchantment.POWER, 1, true);
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS});
        }
        item.setItemMeta(itemMeta);
        inv.setItem(where - 1, item);
    }

    public static void setSparePanels(@NotNull Inventory inv, Material fillerItem) {
        ItemStack glass = new ItemStack(fillerItem, 1);
        ItemMeta glassMeta = glass.getItemMeta();
        if (glassMeta == null) {
            return;
        }
        glassMeta.setHideTooltip(true);
        glass.setItemMeta(glassMeta);
        for (int i = 0; i < inv.getSize(); ++i) {
            inv.setItem(i, glass);
        }
    }
}

