/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting;

import com.itsschatten.libs.Utils;
import com.itsschatten.portablecrafting.BaseFakeContainers;
import com.itsschatten.portablecrafting.events.AnvilOpenEvent;
import com.itsschatten.portablecrafting.events.CartographyOpenEvent;
import com.itsschatten.portablecrafting.events.EnchantingOpenEvent;
import com.itsschatten.portablecrafting.events.GrindStoneOpenEvent;
import com.itsschatten.portablecrafting.events.LoomOpenEvent;
import com.itsschatten.portablecrafting.events.SmithingOpenEvent;
import com.itsschatten.portablecrafting.events.StoneCutterOpenEvent;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.IInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerEnchantTable;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.WeightedRandomEnchant;
import net.minecraft.world.level.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R3.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R3.util.RandomSourceWrapper;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentOffer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.view.EnchantmentView;
import org.jetbrains.annotations.NotNull;

public class FakeContainersPaper
extends BaseFakeContainers {
    private static final String SUPPORTED = "1.21.4";

    @Override
    public boolean openAnvil(@NotNull Player player) {
        AnvilOpenEvent event = new AnvilOpenEvent(player);
        if (event.isCanceled()) {
            return false;
        }
        player.openAnvil(player.getLocation(), true);
        return true;
    }

    @Override
    public boolean openCartography(Player player) {
        CartographyOpenEvent event = new CartographyOpenEvent(player);
        if (event.isCanceled()) {
            return false;
        }
        player.openCartographyTable(player.getLocation(), true);
        return true;
    }

    @Override
    public boolean openEnchant(@NotNull Player player) {
        EnchantingOpenEvent event = new EnchantingOpenEvent(player);
        if (event.isCanceled()) {
            return false;
        }
        player.openEnchanting(player.getLocation(), true);
        return true;
    }

    @Override
    public boolean openEnchant(Player player, int maxLvl) {
        if (!Bukkit.getMinecraftVersion().equals(SUPPORTED)) {
            Utils.logWarning("[WARNING] Opening an enchantment menu with a max level provided may not function and may throw an error.", new String[0]);
            Utils.logWarning("[WARNING] Paper support is built to run exclusively on the latest version.", new String[0]);
            Utils.logWarning("[WARNING] Bug reports regarding inaccurate enchantments on versions less than 1.21.4 will be closed.", new String[0]);
        }
        Utils.debugLog(player.getName() + " called the openEnchant with the maxLvl parameters. This may break in-between versions.", new String[0]);
        try {
            EntityPlayer ePlayer = ((CraftPlayer)player).getHandle();
            int containerID = ePlayer.nextContainerCounter();
            FakeEnchant fakeEnchant = new FakeEnchant(containerID, player, maxLvl);
            EnchantingOpenEvent event = new EnchantingOpenEvent(player);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCanceled()) {
                ePlayer.cd = ePlayer.cc;
                ePlayer.f.b((Packet)new PacketPlayOutOpenWindow(containerID, Containers.n, fakeEnchant.getTitle()));
                ePlayer.cd = fakeEnchant;
                ePlayer.a((Container)fakeEnchant);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            Utils.logError(e);
            player.sendMessage("Something went wrong while opening the enchantment menu.");
            return false;
        }
    }

    @Override
    public boolean openGrindStone(Player player) {
        GrindStoneOpenEvent event = new GrindStoneOpenEvent(player);
        if (event.isCanceled()) {
            return false;
        }
        player.openGrindstone(player.getLocation(), true);
        return true;
    }

    @Override
    public boolean openLoom(Player player) {
        LoomOpenEvent event = new LoomOpenEvent(player);
        if (event.isCanceled()) {
            return false;
        }
        player.openLoom(player.getLocation(), true);
        return true;
    }

    @Override
    public boolean openStoneCutter(Player player) {
        StoneCutterOpenEvent event = new StoneCutterOpenEvent(player);
        if (event.isCanceled()) {
            return false;
        }
        player.openStonecutter(player.getLocation(), true);
        return true;
    }

    @Override
    public boolean openSmithing(Player player) {
        SmithingOpenEvent event = new SmithingOpenEvent(player);
        if (event.isCanceled()) {
            return false;
        }
        player.openSmithingTable(player.getLocation(), true);
        return true;
    }

    private static class FakeEnchant
    extends ContainerEnchantTable {
        private final ContainerAccess myAccess;
        private final RandomSource random;
        private final EntityPlayer player;
        public int maxLevel;

        public FakeEnchant(int i, @NotNull Player player, int maxLevel) {
            super(i, ((CraftPlayer)player).getHandle().gi(), ContainerAccess.a((World)((CraftWorld)player.getWorld()).getHandle(), (BlockPosition)new BlockPosition(player.getLocation().getBlockX(), player.getLocation().getBlockY(), player.getLocation().getBlockZ())));
            this.checkReachable = false;
            this.myAccess = ContainerAccess.a((World)((CraftWorld)player.getWorld()).getHandle(), (BlockPosition)new BlockPosition(player.getLocation().getBlockX(), player.getLocation().getBlockY(), player.getLocation().getBlockZ()));
            this.maxLevel = maxLevel;
            this.random = new RandomSourceWrapper(new Random());
            this.player = ((CraftPlayer)player).getHandle();
            this.setTitle((IChatBaseComponent)IChatBaseComponent.b((String)"Enchant"));
        }

        public FakeEnchant(int i, @NotNull Player player) {
            super(i, ((CraftPlayer)player).getHandle().gi(), ContainerAccess.a((World)((CraftPlayer)player).getHandle().dV(), (BlockPosition)new BlockPosition(player.getLocation().getBlockX(), player.getLocation().getBlockY(), player.getLocation().getBlockZ())));
            this.checkReachable = false;
            this.random = null;
            this.myAccess = null;
            this.player = ((CraftPlayer)player).getHandle();
            this.setTitle((IChatBaseComponent)IChatBaseComponent.b((String)"Enchant"));
        }

        public void a(IInventory inventory) {
            if (this.maxLevel > 0) {
                net.minecraft.world.item.ItemStack itemstack = inventory.a(0);
                if (!itemstack.f()) {
                    this.myAccess.a((world, blockPos) -> {
                        int j;
                        Registry registry = world.K_().e(Registries.aO).t();
                        int i = this.maxLevel;
                        this.random.b((long)this.m());
                        for (j = 0; j < 3; ++j) {
                            this.m[j] = EnchantmentManager.a((RandomSource)this.random, (int)j, (int)i, (net.minecraft.world.item.ItemStack)itemstack);
                            this.n[j] = -1;
                            this.o[j] = -1;
                            if (this.m[j] >= j + 1) continue;
                            this.m[j] = 0;
                        }
                        for (j = 0; j < 3; ++j) {
                            List<WeightedRandomEnchant> list;
                            if (this.m[j] <= 0 || (list = this.getEnchantmentList(world.K_(), itemstack, j, this.m[j])).isEmpty()) continue;
                            WeightedRandomEnchant weightedRandomEnchantment = list.get(this.random.a(list.size()));
                            this.o[j] = weightedRandomEnchantment.b;
                        }
                        CraftItemStack item = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)itemstack);
                        EnchantmentOffer[] offers = new EnchantmentOffer[3];
                        for (j = 0; j < 3; ++j) {
                            Enchantment enchantment = this.n[j] >= 0 ? CraftEnchantment.minecraftHolderToBukkit((Holder)Objects.requireNonNull((Holder)registry.a(this.n[j]))) : null;
                            offers[j] = enchantment != null ? new EnchantmentOffer(enchantment, this.o[j], this.m[j]) : null;
                        }
                        PrepareItemEnchantEvent event = new PrepareItemEnchantEvent((Player)this.player.getBukkitEntity(), (EnchantmentView)this.getBukkitView(), this.myAccess.getLocation().getBlock(), (ItemStack)item, offers, i);
                        event.setCancelled(!itemstack.E());
                        world.getCraftServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            for (j = 0; j < 3; ++j) {
                                this.m[j] = 0;
                                this.n[j] = -1;
                                this.o[j] = -1;
                            }
                            return;
                        }
                        for (j = 0; j < 3; ++j) {
                            EnchantmentOffer offer = event.getOffers()[j];
                            if (offer != null) {
                                this.m[j] = offer.getCost();
                                this.n[j] = registry.a((Object)CraftEnchantment.bukkitToMinecraftHolder((Enchantment)offer.getEnchantment()));
                                this.o[j] = offer.getEnchantmentLevel();
                                continue;
                            }
                            this.m[j] = 0;
                            this.n[j] = -1;
                            this.o[j] = -1;
                        }
                        this.d();
                    });
                } else {
                    for (int i = 0; i < 3; ++i) {
                        this.m[i] = 0;
                        this.n[i] = -1;
                        this.o[i] = -1;
                    }
                }
                return;
            }
            super.a(inventory);
        }

        @NotNull
        private List<WeightedRandomEnchant> getEnchantmentList(@NotNull IRegistryCustom registryManager, net.minecraft.world.item.ItemStack itemstack, int i, int j) {
            this.random.b((long)(super.m() + i));
            Optional optional = registryManager.e(Registries.aO).a(EnchantmentTags.k);
            if (optional.isEmpty()) {
                return List.of();
            }
            List list = EnchantmentManager.b((RandomSource)this.random, (net.minecraft.world.item.ItemStack)itemstack, (int)j, (Stream)((HolderSet.Named)optional.get()).a());
            if (itemstack.a(Items.rw) && list.size() > 1) {
                list.remove(this.random.a(list.size()));
            }
            return list;
        }
    }
}

