/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting;

import com.itsschatten.libs.Utils;
import com.itsschatten.portablecrafting.BaseFakeContainers;
import com.itsschatten.portablecrafting.events.AnvilOpenEvent;
import com.itsschatten.portablecrafting.events.CartographyOpenEvent;
import com.itsschatten.portablecrafting.events.EnchantingOpenEvent;
import com.itsschatten.portablecrafting.events.GrindStoneOpenEvent;
import com.itsschatten.portablecrafting.events.LoomOpenEvent;
import com.itsschatten.portablecrafting.events.SmithingOpenEvent;
import com.itsschatten.portablecrafting.events.StoneCutterOpenEvent;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.ContainerCartography;
import net.minecraft.world.inventory.ContainerEnchantTable;
import net.minecraft.world.inventory.ContainerGrindstone;
import net.minecraft.world.inventory.ContainerLoom;
import net.minecraft.world.inventory.ContainerProperty;
import net.minecraft.world.inventory.ContainerSmithing;
import net.minecraft.world.inventory.ContainerStonecutter;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.WeightedRandomEnchant;
import net.minecraft.world.level.World;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_20_R3.util.RandomSourceWrapper;
import org.bukkit.enchantments.EnchantmentOffer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class FakeContainers_v1_20_R3
extends BaseFakeContainers {
    @Override
    public boolean openLoom(Player player) {
        try {
            EntityPlayer ePlayer = ((CraftPlayer)player).getHandle();
            int containerID = ePlayer.nextContainerCounter();
            FakeLoom fakeLoom = new FakeLoom(containerID, player);
            LoomOpenEvent event = new LoomOpenEvent(player);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCanceled()) {
                ePlayer.bS = ePlayer.bR;
                ePlayer.c.b((Packet)new PacketPlayOutOpenWindow(containerID, Containers.s, fakeLoom.getTitle()));
                ePlayer.bS = fakeLoom;
                return true;
            }
            return false;
        }
        catch (UnsupportedOperationException ex) {
            Utils.log("An error occurred while running the anvil command, make sure you have debug enabled to see this message.", new String[0]);
            Utils.debugLog(ex.getMessage(), new String[0]);
            player.sendMessage("An error occurred, please contact an administrator.");
            return false;
        }
    }

    @Override
    public boolean openAnvil(Player player) {
        try {
            CraftEventFactory.handleInventoryCloseEvent((EntityHuman)((CraftPlayer)player).getHandle());
            EntityPlayer ePlayer = ((CraftPlayer)player).getHandle();
            int containerID = ePlayer.nextContainerCounter();
            FakeAnvil fakeAnvil = new FakeAnvil(containerID, player);
            AnvilOpenEvent event = new AnvilOpenEvent(player);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCanceled()) {
                player.openInventory((InventoryView)fakeAnvil.getBukkitView());
                return true;
            }
            return false;
        }
        catch (UnsupportedOperationException ex) {
            Utils.log("An error occurred while running the anvil command, make sure you have debug enabled to see this message.", new String[0]);
            Utils.debugLog(ex.getMessage(), new String[0]);
            player.sendMessage("An error occurred, please contact an administrator.");
            return false;
        }
    }

    @Override
    public boolean openCartography(Player player) {
        try {
            EntityPlayer ePlayer = ((CraftPlayer)player).getHandle();
            int containerID = ePlayer.nextContainerCounter();
            FakeCartography fakeCartography = new FakeCartography(containerID, player);
            CartographyOpenEvent event = new CartographyOpenEvent(player);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCanceled()) {
                player.openInventory((InventoryView)fakeCartography.getBukkitView());
                return true;
            }
            return false;
        }
        catch (UnsupportedOperationException ex) {
            Utils.log("An error occurred while running the anvil command, make sure you have debug enabled to see this message.", new String[0]);
            Utils.debugLog(ex.getMessage(), new String[0]);
            player.sendMessage("An error occurred, please contact an administrator.");
            return false;
        }
    }

    @Override
    public boolean openGrindStone(Player player) {
        try {
            EntityPlayer ePlayer = ((CraftPlayer)player).getHandle();
            int containerId = ePlayer.nextContainerCounter();
            FakeGrindstone fakeGrindstone = new FakeGrindstone(containerId, player);
            GrindStoneOpenEvent event = new GrindStoneOpenEvent(player);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCanceled()) {
                ePlayer.bS = ePlayer.bR;
                ePlayer.c.b((Packet)new PacketPlayOutOpenWindow(containerId, Containers.p, fakeGrindstone.getTitle()));
                ePlayer.bS = fakeGrindstone;
                return true;
            }
            return false;
        }
        catch (UnsupportedOperationException ex) {
            Utils.debugLog(ex.getMessage(), new String[0]);
            Utils.log("An error occurred while running the grindstone command, make sure you have debug enabled to see this message.", new String[0]);
            player.sendMessage("An error occurred, please contact an administrator.");
            return false;
        }
    }

    @Override
    public boolean openStoneCutter(Player player) {
        try {
            EntityPlayer ePlayer = ((CraftPlayer)player).getHandle();
            int containerID = ePlayer.nextContainerCounter();
            FakeStoneCutter fakeStoneCutter = new FakeStoneCutter(containerID, player);
            StoneCutterOpenEvent event = new StoneCutterOpenEvent(player);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCanceled()) {
                ePlayer.bS = ePlayer.bR;
                ePlayer.c.b((Packet)new PacketPlayOutOpenWindow(containerID, Containers.y, fakeStoneCutter.getTitle()));
                ePlayer.bS = fakeStoneCutter;
                return true;
            }
            return false;
        }
        catch (UnsupportedOperationException ex) {
            Utils.log("An error occurred while running the anvil command, make sure you have debug enabled to see this message.", new String[0]);
            Utils.debugLog(ex.getMessage(), new String[0]);
            player.sendMessage("An error occurred, please contact an administrator.");
            return true;
        }
    }

    @Override
    public boolean openEnchant(Player player) {
        EntityPlayer ePlayer = ((CraftPlayer)player).getHandle();
        int containerID = ePlayer.nextContainerCounter();
        FakeEnchant fakeEnchant = new FakeEnchant(containerID, player);
        return this.callEnchant(player, ePlayer, containerID, fakeEnchant);
    }

    private boolean callEnchant(Player player, EntityPlayer ePlayer, int containerID, FakeEnchant fakeEnchant) {
        EnchantingOpenEvent event = new EnchantingOpenEvent(player);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCanceled()) {
            ePlayer.bS = ePlayer.bR;
            ePlayer.c.b((Packet)new PacketPlayOutOpenWindow(containerID, Containers.n, fakeEnchant.getTitle()));
            ePlayer.bS = fakeEnchant;
            ePlayer.a((Container)fakeEnchant);
            return true;
        }
        return false;
    }

    @Override
    public boolean openEnchant(Player player, int maxLvl) {
        EntityPlayer ePlayer = ((CraftPlayer)player).getHandle();
        int containerID = ePlayer.nextContainerCounter();
        FakeEnchant fakeEnchant = new FakeEnchant(containerID, player, maxLvl);
        return this.callEnchant(player, ePlayer, containerID, fakeEnchant);
    }

    @Override
    public boolean openSmithing(Player player) {
        try {
            EntityPlayer ePlayer = ((CraftPlayer)player).getHandle();
            int containerID = ePlayer.nextContainerCounter();
            FakeSmithing fakeSmithing = new FakeSmithing(containerID, player);
            SmithingOpenEvent event = new SmithingOpenEvent(player);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCanceled()) {
                ePlayer.bS = ePlayer.bR;
                ePlayer.c.b((Packet)new PacketPlayOutOpenWindow(containerID, Containers.v, fakeSmithing.getTitle()));
                ePlayer.bS = fakeSmithing;
                return true;
            }
            return false;
        }
        catch (UnsupportedOperationException ex) {
            Utils.log("An error occurred while running the anvil command, make sure you have debug enabled to see this message.", new String[0]);
            Utils.debugLog(ex.getMessage(), new String[0]);
            player.sendMessage("An error occurred, please contact an administrator.");
            return false;
        }
    }

    private static class FakeLoom
    extends ContainerLoom {
        public FakeLoom(int containerId, Player player) {
            super(containerId, ((CraftPlayer)player).getHandle().fS(), ContainerAccess.a((World)((CraftWorld)player.getWorld()).getHandle(), (BlockPosition)new BlockPosition(player.getLocation().getBlockX(), player.getLocation().getBlockY(), player.getLocation().getBlockZ())));
            this.checkReachable = false;
            this.setTitle((IChatBaseComponent)IChatBaseComponent.b((String)"Loom"));
        }
    }

    private static class FakeAnvil
    extends ContainerAnvil {
        public FakeAnvil(int containerID, Player player) {
            super(containerID, ((CraftPlayer)player).getHandle().fS(), ContainerAccess.a((World)((CraftWorld)player.getWorld()).getHandle(), (BlockPosition)new BlockPosition(player.getLocation().getBlockX(), player.getLocation().getBlockY(), player.getLocation().getBlockZ())));
            this.checkReachable = false;
            this.setTitle((IChatBaseComponent)IChatBaseComponent.b((String)"Repair & Name"));
        }
    }

    private static class FakeCartography
    extends ContainerCartography {
        public FakeCartography(int containerId, Player player) {
            super(containerId, ((CraftPlayer)player).getHandle().fS(), ContainerAccess.a((World)((CraftWorld)player.getWorld()).getHandle(), (BlockPosition)new BlockPosition(player.getLocation().getBlockX(), player.getLocation().getBlockY(), player.getLocation().getBlockZ())));
            this.checkReachable = false;
            this.setTitle((IChatBaseComponent)IChatBaseComponent.b((String)"Cartography Table"));
        }
    }

    private static class FakeGrindstone
    extends ContainerGrindstone {
        public FakeGrindstone(int containerId, Player player) {
            super(containerId, ((CraftPlayer)player).getHandle().fS(), ContainerAccess.a((World)((CraftWorld)player.getWorld()).getHandle(), (BlockPosition)new BlockPosition(player.getLocation().getBlockX(), player.getLocation().getBlockY(), player.getLocation().getBlockZ())));
            this.checkReachable = false;
            this.setTitle((IChatBaseComponent)IChatBaseComponent.b((String)"Repair & Disenchant"));
        }
    }

    private static class FakeStoneCutter
    extends ContainerStonecutter {
        public FakeStoneCutter(int containerId, Player player) {
            super(containerId, ((CraftPlayer)player).getHandle().fS(), ContainerAccess.a((World)((CraftWorld)player.getWorld()).getHandle(), (BlockPosition)new BlockPosition(player.getLocation().getBlockX(), player.getLocation().getBlockY(), player.getLocation().getBlockZ())));
            this.checkReachable = false;
            this.setTitle((IChatBaseComponent)IChatBaseComponent.b((String)"Stonecutter"));
        }
    }

    private static class FakeEnchant
    extends ContainerEnchantTable {
        private final ContainerAccess myAccess;
        private final RandomSource random;
        private final ContainerProperty enchantSeed;
        private final EntityPlayer player;
        public int maxLevel;

        public FakeEnchant(int i, Player player, int maxLevel) {
            super(i, ((CraftPlayer)player).getHandle().fS(), ContainerAccess.a((World)((CraftWorld)player.getWorld()).getHandle(), (BlockPosition)new BlockPosition(player.getLocation().getBlockX(), player.getLocation().getBlockY(), player.getLocation().getBlockZ())));
            this.checkReachable = false;
            this.myAccess = ContainerAccess.a((World)((CraftWorld)player.getWorld()).getHandle(), (BlockPosition)new BlockPosition(player.getLocation().getBlockX(), player.getLocation().getBlockY(), player.getLocation().getBlockZ()));
            this.maxLevel = maxLevel;
            this.random = new RandomSourceWrapper(new Random());
            this.enchantSeed = ContainerProperty.a();
            this.enchantSeed.a(((CraftPlayer)player).getHandle().ga());
            this.player = ((CraftPlayer)player).getHandle();
            this.setTitle((IChatBaseComponent)IChatBaseComponent.b((String)"Enchant"));
        }

        public FakeEnchant(int i, @NotNull Player player) {
            super(i, ((CraftPlayer)player).getHandle().fS(), ContainerAccess.a((World)((CraftPlayer)player).getHandle().dM(), (BlockPosition)new BlockPosition(player.getLocation().getBlockX(), player.getLocation().getBlockY(), player.getLocation().getBlockZ())));
            this.checkReachable = false;
            this.random = null;
            this.myAccess = null;
            this.enchantSeed = null;
            this.player = ((CraftPlayer)player).getHandle();
            this.setTitle((IChatBaseComponent)IChatBaseComponent.b((String)"Enchant"));
        }

        public void a(IInventory inventory) {
            if (this.maxLevel > 0) {
                net.minecraft.world.item.ItemStack itemstack = inventory.a(0);
                if (inventory.ai_()) {
                    for (int i = 0; i < 3; ++i) {
                        this.k[i] = 0;
                        this.l[i] = -1;
                        this.m[i] = -1;
                    }
                    this.enchantSeed.a(this.player.ga());
                    return;
                }
                this.myAccess.a((world, blockPos) -> {
                    int j;
                    int i = this.maxLevel;
                    this.random.b((long)this.enchantSeed.b());
                    for (j = 0; j < 3; ++j) {
                        this.k[j] = EnchantmentManager.a((RandomSource)this.random, (int)j, (int)i, (net.minecraft.world.item.ItemStack)itemstack);
                        this.l[j] = -1;
                        this.m[j] = -1;
                        if (this.k[j] >= j + 1) continue;
                        this.k[j] = 0;
                    }
                    for (j = 0; j < 3; ++j) {
                        List<WeightedRandomEnchant> list;
                        if (this.k[j] <= 0 || (list = this.getEnchantmentList(itemstack, j, this.k[j])) == null || list.isEmpty()) continue;
                        WeightedRandomEnchant weightedRandomEnchant = list.get(this.random.a(list.size()));
                        this.l[j] = BuiltInRegistries.f.a((Object)weightedRandomEnchant.a);
                        this.m[j] = weightedRandomEnchant.b;
                    }
                    CraftItemStack item = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)itemstack);
                    EnchantmentOffer[] offers = new EnchantmentOffer[3];
                    for (j = 0; j < 3; ++j) {
                        org.bukkit.enchantments.Enchantment enchantment = this.l[j] >= 0 ? org.bukkit.enchantments.Enchantment.getByKey((NamespacedKey)CraftNamespacedKey.fromMinecraft((MinecraftKey)Objects.requireNonNull(BuiltInRegistries.f.b((Object)((Enchantment)BuiltInRegistries.f.a(this.l[j])))))) : null;
                        offers[j] = enchantment != null ? new EnchantmentOffer(enchantment, this.m[j], this.k[j]) : null;
                    }
                    PrepareItemEnchantEvent event = new PrepareItemEnchantEvent((Player)this.player.getBukkitEntity(), (InventoryView)this.getBukkitView(), this.myAccess.getLocation().getBlock(), (ItemStack)item, offers, i);
                    event.setCancelled(!itemstack.D());
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                    if (!event.isCancelled()) {
                        for (j = 0; j < 3; ++j) {
                            EnchantmentOffer offer = event.getOffers()[j];
                            if (offer != null) {
                                this.k[j] = offer.getCost();
                                this.l[j] = BuiltInRegistries.f.a((Object)((Enchantment)BuiltInRegistries.f.a(CraftNamespacedKey.toMinecraft((NamespacedKey)offer.getEnchantment().getKey()))));
                                this.m[j] = offer.getEnchantmentLevel();
                                continue;
                            }
                            this.k[j] = 0;
                            this.l[j] = -1;
                            this.m[j] = -1;
                        }
                        this.d();
                    } else {
                        for (j = 0; j < 3; ++j) {
                            this.k[j] = 0;
                            this.l[j] = -1;
                            this.m[j] = -1;
                        }
                    }
                });
                return;
            }
            super.a(inventory);
        }

        private List<WeightedRandomEnchant> getEnchantmentList(net.minecraft.world.item.ItemStack itemstack, int i, int j) {
            this.random.b((long)(this.enchantSeed.b() + i));
            List list = EnchantmentManager.b((RandomSource)this.random, (net.minecraft.world.item.ItemStack)itemstack, (int)j, (boolean)false);
            if (itemstack.a(Items.qM) && list.size() > 1) {
                list.remove(this.random.a(list.size()));
            }
            return list;
        }
    }

    private static class FakeSmithing
    extends ContainerSmithing {
        public FakeSmithing(int containerID, @NotNull Player player) {
            super(containerID, ((CraftPlayer)player).getHandle().fS(), ContainerAccess.a((World)((CraftWorld)player.getWorld()).getHandle(), (BlockPosition)new BlockPosition(player.getLocation().getBlockX(), player.getLocation().getBlockY(), player.getLocation().getBlockZ())));
            this.checkReachable = false;
            this.setTitle((IChatBaseComponent)IChatBaseComponent.b((String)"Upgrade Gear"));
        }
    }
}

