/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting;

import com.itsschatten.libs.Utils;
import com.itsschatten.libs.configutils.PlayerConfigManager;
import com.itsschatten.portablecrafting.configs.Settings;
import com.itsschatten.portablecrafting.storage.HikariConnection;
import com.itsschatten.portablecrafting.storage.StorageCredentials;
import com.itsschatten.portablecrafting.storage.StorageMedium;
import com.itsschatten.portablecrafting.storage.implementations.YamlStorage;
import com.itsschatten.portablecrafting.storage.implementations.sql.MariaDbStorage;
import com.itsschatten.portablecrafting.virtual.Storage;
import com.itsschatten.portablecrafting.virtual.VirtualManager;
import com.itsschatten.portablecrafting.virtual.machine.BrewingStand;
import com.itsschatten.portablecrafting.virtual.machine.Furnace;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;

public class MigrationTask
implements Runnable {
    final StorageMedium toMedium;

    public MigrationTask(StorageMedium toMedium) {
        this.toMedium = toMedium;
    }

    @Override
    public void run() {
        long start = System.currentTimeMillis();
        Utils.log("Starting migration...", new String[0]);
        switch (this.toMedium) {
            case MYSQL: {
                if (Settings.CURRENT_MEDIUM == StorageMedium.MYSQL || Settings.CURRENT_MEDIUM == StorageMedium.MARIADB) {
                    Bukkit.getOnlinePlayers().stream().filter(player -> player.hasPermission("pci.migrate")).forEach(player -> Utils.tell((CommandSender)player, "&cFailed to migrate data! You cannot migrate between MySQL and MariaDB! Please manually transfer your data."));
                    throw new UnsupportedOperationException("PCI doesn't support migrating between MySQL and MariaDB, please manually transfer your data.");
                }
                MariaDbStorage storage = new MariaDbStorage(new StorageCredentials());
                storage.init();
                File dataFolder = new File(Utils.getInstance().getDataFolder(), "data");
                if (!dataFolder.exists() || !dataFolder.isDirectory() || dataFolder.listFiles() == null) break;
                Arrays.stream(Objects.requireNonNullElse(dataFolder.listFiles(), new File[0])).filter(playerFile -> playerFile.getName().endsWith(".yml")).forEach(playerFile -> {
                    UUID uuid = UUID.fromString(playerFile.getName().replace(".yml", ""));
                    PlayerConfigManager pcm = PlayerConfigManager.getConfig(uuid);
                    FileConfiguration configuration = pcm.getConfig();
                    if (configuration.contains("furnaces")) {
                        for (String key : Objects.requireNonNull(configuration.getConfigurationSection("furnaces")).getKeys(false)) {
                            try {
                                storage.saveFurnace(uuid, (Furnace)configuration.get("furnaces." + key));
                            }
                            catch (ClassCastException classCastException) {}
                        }
                    }
                    if (configuration.contains("brewing-stands")) {
                        for (String key : Objects.requireNonNull(configuration.getConfigurationSection("brewing-stands")).getKeys(false)) {
                            try {
                                storage.saveBrewingStand(uuid, (BrewingStand)configuration.get("brewing-stands." + key));
                            }
                            catch (ClassCastException classCastException) {}
                        }
                    }
                });
                break;
            }
            case MARIADB: {
                if (Settings.CURRENT_MEDIUM == StorageMedium.MYSQL || Settings.CURRENT_MEDIUM == StorageMedium.MARIADB) {
                    Bukkit.getOnlinePlayers().stream().filter(player -> player.hasPermission("pci.migrate")).forEach(player -> Utils.tell((CommandSender)player, "&cFailed to migrate data! You cannot migrate between MariaDB and MySQL! Please manually transfer your data."));
                    throw new UnsupportedOperationException("PCI doesn't support migrating between MariaDB and MySQL, please manually transfer your data.");
                }
                MariaDbStorage storage = new MariaDbStorage(new StorageCredentials());
                storage.init();
                File dataFolder = new File(Utils.getInstance().getDataFolder(), "data");
                if (!dataFolder.exists() || !dataFolder.isDirectory() || dataFolder.listFiles() == null) break;
                Arrays.stream(Objects.requireNonNullElse(dataFolder.listFiles(), new File[0])).filter(playerFile -> playerFile.getName().endsWith(".yml")).forEach(playerFile -> {
                    UUID uuid = UUID.fromString(playerFile.getName().replace(".yml", ""));
                    PlayerConfigManager pcm = PlayerConfigManager.getConfig(uuid);
                    FileConfiguration configuration = pcm.getConfig();
                    if (configuration.contains("furnaces")) {
                        for (String key : Objects.requireNonNull(configuration.getConfigurationSection("furnaces")).getKeys(false)) {
                            try {
                                storage.saveFurnace(uuid, (Furnace)configuration.get("furnaces." + key));
                            }
                            catch (ClassCastException classCastException) {}
                        }
                    }
                    if (configuration.contains("brewing-stands")) {
                        for (String key : Objects.requireNonNull(configuration.getConfigurationSection("brewing-stands")).getKeys(false)) {
                            try {
                                storage.saveBrewingStand(uuid, (BrewingStand)configuration.get("brewing-stands." + key));
                            }
                            catch (ClassCastException classCastException) {}
                        }
                    }
                });
                break;
            }
            case YAML: {
                if (Settings.CURRENT_MEDIUM == StorageMedium.YAML) {
                    Bukkit.getOnlinePlayers().stream().filter(player -> player.hasPermission("pci.migrate")).forEach(player -> Utils.tell((CommandSender)player, "&cFailed to migrate data! You cannot migrate between YAML and YAML!"));
                    throw new UnsupportedOperationException("You cannot migrate from YAML to YAML!");
                }
                YamlStorage storage = new YamlStorage();
                Storage storage2 = VirtualManager.getInstance().getStorage();
                if (!(storage2 instanceof HikariConnection)) break;
                HikariConnection hikariConnection = (HikariConnection)storage2;
                try (Connection connection = hikariConnection.getConnection();){
                    UUID owner;
                    ResultSet set;
                    try (PreparedStatement statement = connection.prepareStatement("SELECT `uuid`,`owner` FROM `{prefix}brewing_stand_storage`".replace("{prefix}", Settings.DATABASE_PREFIX));){
                        set = statement.executeQuery();
                        try {
                            while (set.next()) {
                                owner = UUID.fromString(set.getString("owner"));
                                storage.saveBrewingStand(owner, VirtualManager.getInstance().getBrewingStand(owner, UUID.fromString("uuid")));
                            }
                        }
                        finally {
                            if (set != null) {
                                set.close();
                            }
                        }
                    }
                    statement = connection.prepareStatement("SELECT `uuid`,`owner` FROM `{prefix}furnace_storage`".replace("{prefix}", Settings.DATABASE_PREFIX));
                    try {
                        set = statement.executeQuery();
                        try {
                            owner = UUID.fromString(set.getString("owner"));
                            storage.saveFurnace(owner, VirtualManager.getInstance().getFurnace(owner, UUID.fromString("uuid")));
                            break;
                        }
                        finally {
                            if (set != null) {
                                set.close();
                            }
                        }
                    }
                    finally {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                }
                catch (SQLException e) {
                    Utils.logError(e);
                    Bukkit.getOnlinePlayers().stream().filter(player -> player.hasPermission("pci.migrate")).forEach(player -> Utils.tell((CommandSender)player, "&cFailed to migrate data! An issue occurred during SQL. Check console for details."));
                }
            }
        }
        Utils.log("Finished migration in " + (System.currentTimeMillis() - start) + "ms.", new String[0]);
    }
}

