/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting;

import com.itsschatten.libs.UpdateNotifications;
import com.itsschatten.libs.Utils;
import com.itsschatten.libs.bstats.bukkit.Metrics;
import com.itsschatten.libs.configutils.PlayerConfigManager;
import com.itsschatten.libs.hikari.HikariConfig;
import com.itsschatten.libs.hikari.HikariDataSource;
import com.itsschatten.portablecrafting.FakeContainersPaper;
import com.itsschatten.portablecrafting.FakeContainers_v1_20_R1;
import com.itsschatten.portablecrafting.FakeContainers_v1_20_R2;
import com.itsschatten.portablecrafting.FakeContainers_v1_20_R3;
import com.itsschatten.portablecrafting.FakeContainers_v1_20_R4;
import com.itsschatten.portablecrafting.FakeContainers_v1_21_R1;
import com.itsschatten.portablecrafting.FakeContainers_v1_21_R2;
import com.itsschatten.portablecrafting.FakeContainers_v1_21_R3;
import com.itsschatten.portablecrafting.PCIAPI;
import com.itsschatten.portablecrafting.Permissions;
import com.itsschatten.portablecrafting.commands.AnvilCommand;
import com.itsschatten.portablecrafting.commands.BlastFurnaceCommand;
import com.itsschatten.portablecrafting.commands.BrewingStandCommand;
import com.itsschatten.portablecrafting.commands.CartographyCommand;
import com.itsschatten.portablecrafting.commands.CraftCommand;
import com.itsschatten.portablecrafting.commands.EnchantmentTableCommand;
import com.itsschatten.portablecrafting.commands.EnderChestCommand;
import com.itsschatten.portablecrafting.commands.FurnaceCommand;
import com.itsschatten.portablecrafting.commands.GrindStoneCommand;
import com.itsschatten.portablecrafting.commands.LoomCommand;
import com.itsschatten.portablecrafting.commands.PortableCraftingInvsCommand;
import com.itsschatten.portablecrafting.commands.SmokerCommand;
import com.itsschatten.portablecrafting.commands.StoneCutterCommand;
import com.itsschatten.portablecrafting.configs.Messages;
import com.itsschatten.portablecrafting.configs.Settings;
import com.itsschatten.portablecrafting.configs.SignsConfig;
import com.itsschatten.portablecrafting.listeners.EnderchestListener;
import com.itsschatten.portablecrafting.listeners.PlayerJoinListener;
import com.itsschatten.portablecrafting.listeners.SignListener;
import com.itsschatten.portablecrafting.storage.HikariConnection;
import com.itsschatten.portablecrafting.storage.StorageCredentials;
import com.itsschatten.portablecrafting.storage.StorageMedium;
import com.itsschatten.portablecrafting.storage.implementations.YamlStorage;
import com.itsschatten.portablecrafting.storage.implementations.sql.MariaDbStorage;
import com.itsschatten.portablecrafting.storage.implementations.sql.MySQLStorage;
import com.itsschatten.portablecrafting.virtual.Storage;
import com.itsschatten.portablecrafting.virtual.VirtualManager;
import com.itsschatten.portablecrafting.virtual.machine.BrewingStand;
import com.itsschatten.portablecrafting.virtual.machine.Furnace;
import com.itsschatten.portablecrafting.virtual.machine.properties.BrewingProperties;
import com.itsschatten.portablecrafting.virtual.utils.FurnaceType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.FileUtil;

public class PortableCraftingInvsPlugin
extends JavaPlugin {
    private static PCIAPI fakeContainers;
    private static PortableCraftingInvsPlugin instance;
    private static String serverVersion;
    private VirtualManager manager;

    public static boolean isPaperServer() {
        return serverVersion.equals("PAPER");
    }

    public void onEnable() {
        PluginDescriptionFile pdf;
        block89: {
            Utils.setInstance(this);
            PortableCraftingInvsPlugin.setInstance(this);
            try {
                Class.forName("io.papermc.paper.plugin.provider.classloader.ConfiguredPluginClassLoader");
                serverVersion = "PAPER";
            }
            catch (Throwable ignored) {
                serverVersion = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
            }
            Settings.init();
            Messages.init();
            pdf = this.getDescription();
            if (!Settings.SILENT_START_UP) {
                Utils.log("+---------------------------------------------------+ ", " ", " _____   _____ _____ ", "|  __ \\ / ____|_   _|", "| |__) | |      | |  ", "|  ___/| |      | |  ", "| |    | |____ _| |_ ", "|_|     \\_____|_____|", " ", "Developed by " + String.join((CharSequence)",", pdf.getAuthors()), "Version " + pdf.getVersion(), "Using Minecraft version " + serverVersion);
            }
            Bukkit.getScheduler().runTaskLater((Plugin)this, this::registerFakeContainers, 1L);
            if (Settings.ATTEMPT_MIGRATION_AT_START) {
                Utils.log("Attempting to migrate data from an older version of PCI...", new String[0]);
                try {
                    Properties properties = new Properties();
                    File file = new File(this.getDataFolder(), "PCI.properties");
                    if (!file.exists()) {
                        Utils.debugLog("Unable to find the properties file in the data folder! Creating a new one.", new String[0]);
                        properties.load(this.getResource("PCI.properties"));
                    } else {
                        Utils.debugLog("Found properties file in the data folder!", new String[0]);
                        try (FileInputStream in = new FileInputStream(file);){
                            properties.load(in);
                        }
                    }
                    int iteration = Integer.parseInt(properties.getProperty("iteration", "0"));
                    long start = System.currentTimeMillis();
                    if (iteration != 1) {
                        String date = LocalDateTime.now().toString().replace("T", "_").replaceAll("\\..*", "").replace(":", ".");
                        try {
                            File brew = new File(this.getDataFolder().getPath() + File.separator + "backups", "brewing-stands-backup-" + date + ".yml");
                            File furn = new File(this.getDataFolder().getPath() + File.separator + "backups", "furnace-backup-" + date + ".yml");
                            if (!brew.exists()) {
                                new File(brew.getParent()).mkdirs();
                                brew.createNewFile();
                            }
                            if (!furn.exists()) {
                                new File(furn.getParent()).mkdirs();
                                furn.createNewFile();
                            }
                            FileUtil.copy((File)new File(this.getDataFolder(), "brewing-stands.yml"), (File)brew);
                            FileUtil.copy((File)new File(this.getDataFolder(), "furnaces.yml"), (File)furn);
                            HashMap<UUID, UUID> virtualToPlayer = new HashMap<UUID, UUID>();
                            Path furnacePath = Paths.get(String.valueOf(this.getDataFolder()) + File.separator + "furnaces.yml", new String[0]);
                            String content = Files.readString(furnacePath, StandardCharsets.UTF_8);
                            content = content.replaceAll("==: com.itsschatten.*", "");
                            Files.writeString(furnacePath, (CharSequence)content, new OpenOption[0]);
                            Path brewingPath = Paths.get(String.valueOf(this.getDataFolder()) + File.separator + "brewing-stands.yml", new String[0]);
                            String brewingContent = Files.readString(brewingPath, StandardCharsets.UTF_8);
                            brewingContent = brewingContent.replaceAll("==: com.itsschatten.*", "");
                            Files.writeString(brewingPath, (CharSequence)brewingContent, new OpenOption[0]);
                            File furnacesFile = new File(this.getDataFolder(), "furnaces.yml");
                            YamlConfiguration furnaces = YamlConfiguration.loadConfiguration((File)furnacesFile);
                            File brewingFile = new File(this.getDataFolder(), "brewing-stands.yml");
                            YamlConfiguration brewingStands = YamlConfiguration.loadConfiguration((File)brewingFile);
                            Settings settings = Settings.getInstance();
                            if (settings.getBoolean("use-sql")) {
                                HikariConfig config;
                                String user = settings.getString("sql-user");
                                String pass = settings.getString("sql-pass");
                                String host = settings.getString("sql-host");
                                String db = settings.getString("sql-database");
                                String port = String.valueOf(settings.getInt("sql-port"));
                                Utils.log("Attempting to connect to your old configured SQL database...", new String[0]);
                                try {
                                    config = new HikariConfig();
                                }
                                catch (LinkageError er) {
                                    Utils.logError(er);
                                    Utils.logError("Failed to create a hikari config on startup!", "https://github.com/ItsSchatten/PortableCraftingInvs/issues/new?template=bug_report.yml&labels=labels=type%3A+bug%2Cpriority%3A+normal%2Cstatus%3A+awaiting+confirmation");
                                    return;
                                }
                                config.setPoolName("portable-crafting-invs-hikari-migrate-startup");
                                config.setJdbcUrl(String.format("jdbc:%s://%s:%s/%s?autoReconnect=true&useSSL=false", "mysql", host, port, db));
                                config.setUsername(user);
                                config.setPassword(pass);
                                Utils.log("Starting sql extraction...", new String[0]);
                                long sqlStart = System.currentTimeMillis();
                                try (HikariDataSource source = new HikariDataSource(config);
                                     Connection connection = source.getConnection();){
                                    ResultSet set;
                                    try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM `pci_furnaces`");){
                                        set = statement.executeQuery();
                                        try {
                                            while (set.next()) {
                                                virtualToPlayer.put(UUID.fromString(Objects.requireNonNull(set.getString("furnace_uuid"))), UUID.fromString(set.getString("owner_uuid")));
                                            }
                                        }
                                        finally {
                                            if (set != null) {
                                                set.close();
                                            }
                                        }
                                    }
                                    statement = connection.prepareStatement("SELECT * FROM `pci_brewing_stands`");
                                    try {
                                        set = statement.executeQuery();
                                        try {
                                            while (set.next()) {
                                                virtualToPlayer.put(UUID.fromString(Objects.requireNonNull(set.getString("stand_uuid"))), UUID.fromString(set.getString("owner_uuid")));
                                            }
                                        }
                                        finally {
                                            if (set != null) {
                                                set.close();
                                            }
                                        }
                                    }
                                    finally {
                                        if (statement != null) {
                                            statement.close();
                                        }
                                    }
                                }
                                catch (SQLException e) {
                                    Utils.logError(e);
                                }
                                Utils.log("SQL extraction finished in " + (System.currentTimeMillis() - sqlStart) + "ms", new String[0]);
                            } else {
                                File dataFolder = new File(Utils.getInstance().getDataFolder(), "data");
                                if (dataFolder.exists() && dataFolder.isDirectory() && dataFolder.listFiles() != null) {
                                    Arrays.stream(Objects.requireNonNullElse(dataFolder.listFiles(), new File[0])).filter(playerFile -> playerFile.getName().endsWith(".yml")).forEach(playerFile -> {
                                        UUID uuid = UUID.fromString(playerFile.getName().replace(".yml", ""));
                                        PlayerConfigManager pcm = PlayerConfigManager.getConfig(uuid);
                                        FileConfiguration configuration = pcm.getConfig();
                                        if (configuration.contains("furnaces")) {
                                            for (String key : Objects.requireNonNull(configuration.getConfigurationSection("furnaces")).getKeys(false)) {
                                                virtualToPlayer.put(UUID.fromString(Objects.requireNonNull(configuration.getString("furnaces." + key))), uuid);
                                            }
                                        }
                                        if (configuration.contains("brewing")) {
                                            virtualToPlayer.put(UUID.fromString(Objects.requireNonNull(configuration.getString("brewing"))), uuid);
                                        }
                                    });
                                }
                            }
                            virtualToPlayer.forEach((arg_0, arg_1) -> PortableCraftingInvsPlugin.lambda$onEnable$2((FileConfiguration)furnaces, (FileConfiguration)brewingStands, arg_0, arg_1));
                            PlayerConfigManager.getConfigs().clear();
                            properties.setProperty("iteration", "1");
                            try (FileOutputStream out = new FileOutputStream(file);){
                                properties.store(out, "Updated in version " + pdf.getVersion() + " of PCI.");
                                break block89;
                            }
                        }
                        catch (NoSuchFileException ex) {
                            Utils.logWarning("Couldn't find a storage file to migrate.", new String[0]);
                            Utils.logWarning("If you do have just a 'furnace.yml' or a 'brewing-stands.yml' please create the other file and the migration should complete.", new String[0]);
                        }
                        catch (Exception e) {
                            Utils.logError(e);
                            Utils.logError("Failed to migrate data!", new String[0]);
                        }
                        break block89;
                    }
                    Utils.log("You're up to date! You can safely disable `attempt-migration-at-start` if you wish!", new String[0]);
                    Utils.debugLog("Completed migration check (already up to date) in " + (System.currentTimeMillis() - start) + "ms.", new String[0]);
                }
                catch (IOException e) {
                    Utils.logError(e);
                }
            }
        }
        if (Settings.USE_METRICS) {
            Utils.log("Metrics are enabled! You can see the information collect at the following link: https://bstats.org/plugin/bukkit/PortableCraftingInvs", "If you don't wish for this information to be collected you can disable it in the 'settings.yml'.");
            new Metrics(this, 5752);
        }
        UpdateNotifications notifications = null;
        if (Settings.USE_UPDATER) {
            notifications = new UpdateNotifications(this, 61045){
                boolean available;
                {
                    super(projectId);
                    this.available = false;
                }

                @Override
                public void onUpdateAvailable() {
                    Utils.log("There is an update available for the plugin! Current Version " + pdf.getVersion() + " New Version " + 1.getLatestVersion() + " (https://spigotmc.org/resources/" + 1.getProjectId() + ")", new String[0]);
                    if (!this.available) {
                        Bukkit.getOnlinePlayers().stream().filter(player -> player.hasPermission(Permissions.UPDATE_NOTIFICATIONS.getPermission())).forEach(admin -> Utils.tell((CommandSender)admin, this.getUpdateMessage().replace("{currentVer}", PortableCraftingInvsPlugin.getInstance().getDescription().getVersion()).replace("{newVer}", UpdateNotifications.getLatestVersion()).replace("{link}", "https://spigotmc.org/resources/" + UpdateNotifications.getProjectId())));
                        this.available = true;
                    }
                }
            };
            notifications.runTaskTimerAsynchronously((Plugin)this, 0L, Settings.UPDATE_CHECK_INTERVAL * 1200);
            Utils.debugLog("Checked for update, and set timer running, checking for an update again in " + Settings.UPDATE_CHECK_INTERVAL + " minutes.", new String[0]);
        }
        if (Settings.USE_ENDERCHEST_RESTRICTION) {
            this.getServer().getPluginManager().registerEvents((Listener)new EnderchestListener(), (Plugin)this);
            Utils.debugLog("USE_ENDERCHEST_RESTRICTIONS is true; EnderchestListener has been initialized.", new String[0]);
        }
        if (Settings.USE_SIGNS) {
            SignsConfig.init();
            this.getServer().getPluginManager().registerEvents((Listener)new SignListener(), (Plugin)this);
            Utils.debugLog("Signs have been enabled.", new String[0]);
        }
        this.registerCommands(new PortableCraftingInvsCommand());
        if (Settings.USE_ANVIL) {
            this.registerCommands(new AnvilCommand());
        }
        if (Settings.USE_CARTOGRAPHY) {
            this.registerCommands(new CartographyCommand());
        }
        if (Settings.USE_CRAFTING) {
            this.registerCommands(new CraftCommand());
        }
        if (Settings.USE_ENCHANT_TABLE) {
            this.registerCommands(new EnchantmentTableCommand());
        }
        if (Settings.USE_ENDERCHEST) {
            this.registerCommands(new EnderChestCommand());
        }
        if (Settings.USE_GRINDSTONE) {
            this.registerCommands(new GrindStoneCommand());
        }
        if (Settings.USE_SMITHING_TABLE) {
            this.registerCommands(new LoomCommand());
        }
        if (Settings.USE_STONE_CUTTER) {
            this.registerCommands(new StoneCutterCommand());
        }
        if (Settings.USE_VIRTUAL_TILES) {
            if (Settings.USE_FURNACE) {
                this.registerCommands(new FurnaceCommand());
            }
            if (Settings.USE_BLAST_FURNACE) {
                this.registerCommands(new BlastFurnaceCommand());
            }
            if (Settings.USE_SMOKER) {
                this.registerCommands(new SmokerCommand());
            }
            if (Settings.USE_BREWING) {
                this.registerCommands(new BrewingStandCommand());
            }
        }
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(notifications), (Plugin)this);
        Utils.debugLog("Loaded event listeners.", new String[0]);
        if (!Settings.SILENT_START_UP) {
            Utils.log("+---------------------------------------------------+ ", "");
        }
    }

    private boolean registerFakeContainers() {
        long then = System.currentTimeMillis();
        Utils.debugLog("Begin loading fake containers.", new String[0]);
        switch (serverVersion) {
            case "v1_21_R3": {
                fakeContainers = new FakeContainers_v1_21_R3();
                break;
            }
            case "v1_21_R2": {
                fakeContainers = new FakeContainers_v1_21_R2();
                break;
            }
            case "v1_21_R1": {
                fakeContainers = new FakeContainers_v1_21_R1();
                break;
            }
            case "v1_20_R4": {
                fakeContainers = new FakeContainers_v1_20_R4();
                break;
            }
            case "v1_20_R3": {
                fakeContainers = new FakeContainers_v1_20_R3();
                break;
            }
            case "v1_20_R2": {
                fakeContainers = new FakeContainers_v1_20_R2();
                break;
            }
            case "v1_20_R1": {
                fakeContainers = new FakeContainers_v1_20_R1();
                break;
            }
            case "v1_19_R3": 
            case "v1_19_R2": 
            case "v1_19_R1": {
                Utils.logWarning("With the rewrite in 2.0.0 PCI has decided to \"prematurely\" drop support for 1.19.x versions.", new String[0]);
                Utils.logWarning("I'm sorry if this causes any inconveniences. The plugin will now disable to avoid issues.", new String[0]);
                Utils.logError("Version " + serverVersion + " is not supported by this plugin, to avoid issues the plugin will now disable.", new String[0]);
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
                Utils.debugLog("Failed to register fake containers in " + (System.currentTimeMillis() - then) + "ms.", new String[0]);
                break;
            }
            case "PAPER": {
                fakeContainers = new FakeContainersPaper();
                break;
            }
            default: {
                Utils.logError("Version " + serverVersion + " of Spigot is not supported by this plugin, to avoid issues the plugin will now disable.", new String[0]);
                Utils.debugLog("Failed to register fake containers in " + (System.currentTimeMillis() - then) + "ms.", new String[0]);
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
                return true;
            }
        }
        if (Settings.USE_VIRTUAL_TILES) {
            if (!(Settings.USE_FURNACE || Settings.USE_BLAST_FURNACE || Settings.USE_SMOKER || Settings.USE_BREWING)) {
                Utils.logWarning("[ATTENTION] Hey! You seem to have to disabled all virtual tile features, because of this we will not be registering it's API so we don't take up any additional resources.", new String[0]);
            } else {
                Storage medium = switch (StorageMedium.valueOf(Settings.STORAGE_MEDIUM.toUpperCase())) {
                    default -> throw new MatchException(null, null);
                    case StorageMedium.MYSQL -> new MySQLStorage(new StorageCredentials());
                    case StorageMedium.MARIADB -> new MariaDbStorage(new StorageCredentials());
                    case StorageMedium.YAML -> new YamlStorage();
                };
                Utils.debugLog("Using " + medium.implementationName() + " storage medium!", new String[0]);
                if (medium instanceof HikariConnection) {
                    HikariConnection connection = (HikariConnection)medium;
                    Utils.debugLog("Calling HikariConnection#init()!", new String[0]);
                    connection.init();
                }
                this.manager = new VirtualManager(medium, Settings.getInstance());
                Utils.log("Loaded the virtual tile API.", new String[0]);
            }
        } else {
            Utils.debugLog("Not loading virtual tile API.", new String[0]);
        }
        Bukkit.getServicesManager().register(PCIAPI.class, (Object)fakeContainers, (Plugin)this, ServicePriority.Normal);
        Utils.debugLog("Registered fake containers in " + (System.currentTimeMillis() - then) + "ms.", new String[0]);
        return false;
    }

    public void onDisable() {
        if (VirtualManager.getInstance().isLoaded()) {
            VirtualManager.getInstance().shutdown();
        }
        CraftCommand.setInstance(null);
        EnderChestCommand.setInstance(null);
        PortableCraftingInvsPlugin.setInstance(null);
        Utils.setInstance(null);
    }

    private void registerCommands(Command ... commands) {
        try {
            Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            CommandMap commandMap = (CommandMap)commandMapField.get(Bukkit.getServer());
            for (Command command : commands) {
                command.register(commandMap);
                commandMap.register(this.getName(), command);
                Utils.debugLog("Command " + command.getName() + " has been registered.", new String[0]);
            }
        }
        catch (Exception ex) {
            Utils.logError(ex);
            Utils.logError("Some error occurred, please report this immediately to ItsSchatten on Spigot or Github.", "(https://github.com/ItsSchatten/PortableCraftingInvs/issues/new/choose)");
        }
    }

    public final void unregisterCommand(Command ... commands) {
        if (commands == null) {
            return;
        }
        try {
            Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            CommandMap commandMap = (CommandMap)commandMapField.get(Bukkit.getServer());
            for (Command command : commands) {
                if (command == null) continue;
                command.unregister(commandMap);
                Utils.debugLog("Command " + command.getName() + " has been unregistered.", new String[0]);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Utils.logError(e);
            Utils.logError("Some error occurred, please report this immediately to ItsSchatten on Spigot or Github.", "(https://github.com/ItsSchatten/PortableCraftingInvs/issues/new/choose)");
        }
    }

    public static PCIAPI getFakeContainers() {
        return fakeContainers;
    }

    public static PortableCraftingInvsPlugin getInstance() {
        return instance;
    }

    private static void setInstance(PortableCraftingInvsPlugin instance) {
        PortableCraftingInvsPlugin.instance = instance;
    }

    public static String getServerVersion() {
        return serverVersion;
    }

    public VirtualManager getManager() {
        return this.manager;
    }

    private static /* synthetic */ void lambda$onEnable$2(FileConfiguration furnaces, FileConfiguration brewingStands, UUID machine, UUID player) {
        PlayerConfigManager pcm = PlayerConfigManager.getConfig(player);
        FileConfiguration configuration = pcm.getConfig();
        if (furnaces.contains("furnaces." + String.valueOf(machine))) {
            Map vals = furnaces.getConfigurationSection("furnaces." + String.valueOf(machine)).getValues(true);
            String propertiesKey = furnaces.getString("furnaces." + String.valueOf(machine) + ".properties.key", "furnace");
            FurnaceType type = propertiesKey.contains("blast") ? FurnaceType.BLASTING : (propertiesKey.contains("smoker") ? FurnaceType.SMOKER : FurnaceType.FURNACE);
            Furnace furnace = new Furnace((String)vals.get("name"), machine, type.getProperties(), type, (ItemStack)vals.get("fuel"), (ItemStack)vals.get("input"), (ItemStack)vals.get("output"), (Integer)vals.get("cookTime"), (Integer)vals.get("fuelTime"), (Integer)vals.get("fuelTime"), ((Double)vals.get("xp")).floatValue(), LocalDateTime.now());
            configuration.set("furnaces." + String.valueOf(machine), (Object)furnace);
            Utils.debugLog("Migrated the machine " + String.valueOf(machine) + " as a furnace!", new String[0]);
        } else if (brewingStands.contains("brewing." + String.valueOf(machine))) {
            Map vals = brewingStands.getConfigurationSection("brewing." + String.valueOf(machine)).getValues(true);
            ItemStack[] bottles = new ItemStack[]{(ItemStack)vals.get("bottle-1"), (ItemStack)vals.get("bottle-2"), (ItemStack)vals.get("bottle-3")};
            BrewingStand stand = new BrewingStand((String)vals.get("name"), machine, bottles, BrewingProperties.NORMAL, (ItemStack)vals.get("fuel"), (ItemStack)vals.get("ingredient"), (Integer)vals.get("fuelTime"), (Integer)vals.get("maxBrews"), (Integer)vals.get("brewTime"), 0, LocalDateTime.now());
            configuration.set("brewing-stands." + String.valueOf(machine), (Object)stand);
            Utils.debugLog("Migrated the machine " + String.valueOf(machine) + " as a brewing stand!", new String[0]);
        } else {
            Utils.logWarning("Failed to migrate " + String.valueOf(machine) + " to a player...", new String[0]);
        }
        pcm.saveConfig();
    }
}

