/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.commands;

import com.itsschatten.libs.Utils;
import com.itsschatten.libs.commandutils.UniversalCommand;
import com.itsschatten.portablecrafting.Permissions;
import com.itsschatten.portablecrafting.PortableCraftingInvsPlugin;
import com.itsschatten.portablecrafting.configs.Messages;
import com.itsschatten.portablecrafting.configs.Settings;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class AnvilCommand
extends UniversalCommand {
    public AnvilCommand() {
        super("anvil");
        this.setAliases(Arrays.asList("openanvil", "anv"));
        this.setPermission(Settings.USE_PERMISSIONS ? Permissions.ANVIL.getPermission() : "");
        this.setPermissionMessage(Utils.getNoPermsMessage().replace("{prefix}", Messages.PREFIX).replace("{permission}", Permissions.ANVIL.getPermission()));
    }

    @Override
    protected void run(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            this.checkArgs(1, Messages.NOT_ENOUGH_ARGS);
            this.openAnvil(args);
            return;
        }
        Player player = (Player)sender;
        if (Settings.USE_PERMISSIONS) {
            this.checkPerms((CommandSender)player, Permissions.ANVIL);
        }
        if (args.length == 0 && PortableCraftingInvsPlugin.getFakeContainers().openAnvil(player)) {
            this.sendSoundAndAddToSet(player);
            this.returnTell(Messages.OPENED_ANVIL);
        }
        if (args.length == 1) {
            if (Settings.USE_PERMISSIONS) {
                this.checkPerms((CommandSender)player, Permissions.ANVIL_OTHER);
            }
            this.openAnvil(args);
        }
        if (args.length > 1 && Settings.USE_TOO_MANY_ARGS) {
            this.returnTell(Messages.TOO_MANY_ARGS);
        }
    }

    private void openAnvil(String @NotNull [] args) {
        Player target = Bukkit.getPlayer((String)args[0]);
        this.checkNotNull(target, Messages.PLAYER_DOES_NOT_EXIST.replace("{player}", args[0]));
        assert (target != null);
        if (PortableCraftingInvsPlugin.getFakeContainers().openAnvil(target)) {
            this.sendSoundAndAddToSet(target);
            this.tellTarget(target, Messages.OPENED_ANVIL);
            this.returnTell(Messages.OPENED_ANVIL_OTHER.replace("{player}", target.getName()));
        }
    }

    private void sendSoundAndAddToSet(Player target) {
        String anvilOpenSound = Settings.ANVIL_OPEN_SOUND;
        if (Settings.USE_ANVIL_SOUNDS) {
            target.playSound(target.getLocation(), Sound.valueOf((String)anvilOpenSound), 1.0f, Settings.USE_RANDOM_SOUND_PITCH ? (float)Math.random() : 1.0f);
            Utils.debugLog("Playing sound " + anvilOpenSound + " to " + target.getName(), new String[0]);
        }
        Utils.debugLog("Opened the anvil for " + target.getName(), new String[0]);
    }
}

