/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.commands;

import com.itsschatten.libs.Utils;
import com.itsschatten.libs.commandutils.UniversalCommand;
import com.itsschatten.portablecrafting.Permissions;
import com.itsschatten.portablecrafting.PortableCraftingInvsPlugin;
import com.itsschatten.portablecrafting.configs.Messages;
import com.itsschatten.portablecrafting.configs.Settings;
import java.util.Collections;
import org.apache.commons.lang3.math.NumberUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class BlastFurnaceCommand
extends UniversalCommand {
    public BlastFurnaceCommand() {
        super("blastfurnace");
        this.setPermission(Settings.USE_PERMISSIONS ? Permissions.BLAST_FURNACE.getPermission() : "");
        this.setPermissionMessage(Utils.getNoPermsMessage().replace("{prefix}", Messages.PREFIX).replace("{permission}", Permissions.BLAST_FURNACE.getPermission()));
        this.setDescription("Open a virtual blast furnace for you or another player!");
        this.setAliases(Collections.singletonList("blastfurn"));
    }

    @Override
    protected void run(CommandSender commandSender, String[] args) {
        if (!(commandSender instanceof Player)) {
            this.checkArgs(1, Messages.NOT_ENOUGH_ARGS);
            this.openBlastFurnaceForTarget(args);
            return;
        }
        Player player = (Player)commandSender;
        if (Settings.USE_PERMISSIONS) {
            this.checkPerms((CommandSender)player, Permissions.BLAST_FURNACE);
        }
        if (args.length == 0) {
            switch (PortableCraftingInvsPlugin.getFakeContainers().openBlastFurnace(player)) {
                case OPENED: {
                    Utils.debugLog("Opened a virtual furnace for " + player.getName(), new String[0]);
                    this.returnTell(Messages.OPENED_BLAST_FURNACE);
                    break;
                }
                case REACHED_MAXIMUM: {
                    Utils.debugLog(player.getName() + " (may have) reached the furnace maximum!", new String[0]);
                    this.returnTell(Messages.REACHED_MAXIMUM_FEATURE.replace("{player}", Messages.YOU).replace("{feature}", Messages.BLAST_FURNACE).replace("{maximum}", "" + Settings.getInstance().maximumFurnaces()));
                    break;
                }
                case EVENT_CANCELED: {
                    Utils.debugLog("An event listener canceled opening a furnace for " + player.getName(), new String[0]);
                }
            }
            return;
        }
        if (args.length == 1) {
            if (NumberUtils.isDigits(args[0])) {
                switch (PortableCraftingInvsPlugin.getFakeContainers().openBlastFurnace(player, Math.max(0, this.getNumber(0, "") - 1))) {
                    case OPENED: {
                        Utils.debugLog("Opened a virtual furnace for " + player.getName(), new String[0]);
                        this.returnTell(Messages.OPENED_BLAST_FURNACE);
                        break;
                    }
                    case REACHED_MAXIMUM: {
                        Utils.debugLog(player.getName() + " (may have) reached the furnace maximum!", new String[0]);
                        this.returnTell(Messages.REACHED_MAXIMUM_FEATURE.replace("{player}", Messages.YOU).replace("{feature}", Messages.BLAST_FURNACE).replace("{maximum}", "" + Settings.getInstance().maximumFurnaces()));
                        break;
                    }
                    case EVENT_CANCELED: {
                        Utils.debugLog("An event listener canceled opening a furnace for " + player.getName(), new String[0]);
                    }
                }
                return;
            }
            if (Settings.USE_PERMISSIONS) {
                this.checkPerms((CommandSender)player, Permissions.BLAST_FURNACE_OTHER);
            }
            this.openBlastFurnaceForTarget(args);
        }
        if (args.length > 1 && Settings.USE_TOO_MANY_ARGS) {
            this.returnTell(Messages.TOO_MANY_ARGS);
        }
    }

    private void openBlastFurnaceForTarget(String @NotNull [] args) {
        Player target = Bukkit.getPlayer((String)args[0]);
        this.checkNotNull(target, Messages.PLAYER_DOES_NOT_EXIST.replace("{player}", args[0]));
        assert (target != null);
        if (args.length > 1 && NumberUtils.isDigits(args[1])) {
            switch (PortableCraftingInvsPlugin.getFakeContainers().openBlastFurnace(target, Math.max(0, this.getNumber(1, "") - 1))) {
                case OPENED: {
                    Utils.debugLog("Opened a virtual furnace for " + target.getName(), new String[0]);
                    this.tellTarget(target, Messages.OPENED_BLAST_FURNACE);
                    this.returnTell(Messages.OPENED_BLAST_FURNACE_OTHER.replace("{player}", target.getName()));
                    break;
                }
                case REACHED_MAXIMUM: {
                    Utils.debugLog(target.getName() + " (may have) reached the furnace maximum!", new String[0]);
                    this.returnTell(Messages.REACHED_MAXIMUM_FEATURE.replace("{player}", target.getName()).replace("{feature}", Messages.BLAST_FURNACE).replace("{maximum}", "" + Settings.getInstance().maximumFurnaces()));
                    break;
                }
                case EVENT_CANCELED: {
                    Utils.debugLog("An event listener canceled opening a furnace for " + target.getName(), new String[0]);
                }
            }
            return;
        }
        switch (PortableCraftingInvsPlugin.getFakeContainers().openBlastFurnace(target)) {
            case OPENED: {
                Utils.debugLog("Opened a virtual furnace for " + target.getName(), new String[0]);
                this.tellTarget(target, Messages.OPENED_BLAST_FURNACE);
                this.returnTell(Messages.OPENED_BLAST_FURNACE_OTHER.replace("{player}", target.getName()));
                break;
            }
            case REACHED_MAXIMUM: {
                Utils.debugLog(target.getName() + " (may have) reached the furnace maximum!", new String[0]);
                this.returnTell(Messages.REACHED_MAXIMUM_FEATURE.replace("{player}", target.getName()).replace("{feature}", Messages.BLAST_FURNACE).replace("{maximum}", "" + Settings.getInstance().maximumFurnaces()));
                break;
            }
            case EVENT_CANCELED: {
                Utils.debugLog("An event listener canceled opening a furnace for " + target.getName(), new String[0]);
            }
        }
    }
}

