/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.commands;

import com.itsschatten.libs.Utils;
import com.itsschatten.libs.commandutils.UniversalCommand;
import com.itsschatten.portablecrafting.Permissions;
import com.itsschatten.portablecrafting.PortableCraftingInvsPlugin;
import com.itsschatten.portablecrafting.configs.Messages;
import com.itsschatten.portablecrafting.configs.Settings;
import java.util.Collections;
import org.apache.commons.lang3.math.NumberUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class BrewingStandCommand
extends UniversalCommand {
    public BrewingStandCommand() {
        super("brewing");
        this.setAliases(Collections.singletonList("brew"));
        this.setPermission(Settings.USE_PERMISSIONS ? Permissions.BREWING.getPermission() : "");
        this.setPermissionMessage(Utils.getNoPermsMessage().replace("{prefix}", Messages.PREFIX).replace("{permission}", Permissions.BREWING.getPermission()));
    }

    @Override
    protected void run(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            this.checkArgs(1, Messages.NOT_ENOUGH_ARGS);
            this.openBrewingForTarget(args);
            return;
        }
        Player player = (Player)sender;
        if (Settings.USE_PERMISSIONS) {
            this.checkPerms((CommandSender)player, Permissions.BREWING);
        }
        if (args.length == 0) {
            switch (PortableCraftingInvsPlugin.getFakeContainers().openBrewingStand(player)) {
                case OPENED: {
                    Utils.debugLog("Opened a virtual brewing stand for " + player.getName(), new String[0]);
                    this.returnTell(Messages.OPENED_BREWING);
                    break;
                }
                case REACHED_MAXIMUM: {
                    Utils.debugLog(player.getName() + " (may have) reached the brewing stand maximum!", new String[0]);
                    this.returnTell(Messages.REACHED_MAXIMUM_FEATURE.replace("{player}", Messages.YOU).replace("{feature}", Messages.BREWING_STAND).replace("{maximum}", "" + Settings.getInstance().maximumFurnaces()));
                    break;
                }
                case EVENT_CANCELED: {
                    Utils.debugLog("An event listener canceled opening a brewing stand for " + player.getName(), new String[0]);
                }
            }
            return;
        }
        if (args.length == 1) {
            if (NumberUtils.isDigits(args[0])) {
                switch (PortableCraftingInvsPlugin.getFakeContainers().openBrewingStand(player, Math.max(0, this.getNumber(0, "") - 1))) {
                    case OPENED: {
                        Utils.debugLog("Opened a virtual brewing stand for " + player.getName(), new String[0]);
                        this.returnTell(Messages.OPENED_BREWING);
                        break;
                    }
                    case REACHED_MAXIMUM: {
                        Utils.debugLog(player.getName() + " (may have) reached the brewing stand maximum!", new String[0]);
                        this.returnTell(Messages.REACHED_MAXIMUM_FEATURE.replace("{player}", Messages.YOU).replace("{feature}", Messages.BREWING_STAND).replace("{maximum}", "" + Settings.getInstance().maximumFurnaces()));
                        break;
                    }
                    case EVENT_CANCELED: {
                        Utils.debugLog("An event listener canceled opening a brewing stand for " + player.getName(), new String[0]);
                    }
                }
                return;
            }
            if (Settings.USE_PERMISSIONS) {
                this.checkPerms((CommandSender)player, Permissions.BREWING_OTHER);
            }
            this.openBrewingForTarget(args);
        }
        if (args.length > 1 && Settings.USE_TOO_MANY_ARGS) {
            this.returnTell(Messages.TOO_MANY_ARGS);
        }
    }

    private void openBrewingForTarget(String @NotNull [] args) {
        Player target = Bukkit.getPlayer((String)args[0]);
        this.checkNotNull(target, Messages.PLAYER_DOES_NOT_EXIST.replace("{player}", args[0]));
        assert (target != null);
        if (args.length > 1 && NumberUtils.isDigits(args[1])) {
            switch (PortableCraftingInvsPlugin.getFakeContainers().openBrewingStand(target, Math.max(0, this.getNumber(1, "") - 1))) {
                case OPENED: {
                    Utils.debugLog("Opened a virtual brewing stand for " + target.getName(), new String[0]);
                    this.tellTarget(target, Messages.OPENED_BREWING);
                    this.returnTell(Messages.OPENED_BREWING_OTHER.replace("{player}", target.getName()));
                    break;
                }
                case REACHED_MAXIMUM: {
                    Utils.debugLog(target.getName() + " (may have) reached the brewing stand maximum!", new String[0]);
                    this.returnTell(Messages.REACHED_MAXIMUM_FEATURE.replace("{player}", target.getName()).replace("{feature}", Messages.BREWING_STAND).replace("{maximum}", "" + Settings.getInstance().maximumFurnaces()));
                    break;
                }
                case EVENT_CANCELED: {
                    Utils.debugLog("An event listener canceled opening a brewing stand for " + target.getName(), new String[0]);
                }
            }
            return;
        }
        switch (PortableCraftingInvsPlugin.getFakeContainers().openBrewingStand(target)) {
            case OPENED: {
                Utils.debugLog("Opened a virtual brewing stand for " + target.getName(), new String[0]);
                this.tellTarget(target, Messages.OPENED_BREWING);
                this.returnTell(Messages.OPENED_BREWING_OTHER.replace("{player}", target.getName()));
                break;
            }
            case REACHED_MAXIMUM: {
                Utils.debugLog(target.getName() + " (may have) reached the brewing stand maximum!", new String[0]);
                this.returnTell(Messages.REACHED_MAXIMUM_FEATURE.replace("{player}", target.getName()).replace("{feature}", Messages.BREWING_STAND).replace("{maximum}", "" + Settings.getInstance().maximumFurnaces()));
                break;
            }
            case EVENT_CANCELED: {
                Utils.debugLog("An event listener canceled opening a brewing stand for " + target.getName(), new String[0]);
            }
        }
    }
}

