/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.commands;

import com.itsschatten.libs.Utils;
import com.itsschatten.libs.commandutils.UniversalCommand;
import com.itsschatten.portablecrafting.Permissions;
import com.itsschatten.portablecrafting.configs.Messages;
import com.itsschatten.portablecrafting.configs.Settings;
import com.itsschatten.portablecrafting.events.CraftingOpenEvent;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class CraftCommand
extends UniversalCommand {
    static CraftCommand instance;

    public CraftCommand() {
        super("craft");
        CraftCommand.setInstance(this);
        this.setAliases(Arrays.asList("crafting", "craftingtable", "workbench"));
        this.setPermission(Settings.USE_PERMISSIONS ? Permissions.CRAFTING.getPermission() : "");
        this.setPermissionMessage(Utils.getNoPermsMessage().replace("{prefix}", Messages.PREFIX).replace("{permission}", Permissions.CRAFTING.getPermission()));
    }

    @Override
    protected void run(CommandSender sender, String[] args) {
        String craftOpenSound = Settings.CRAFTING_OPEN_SOUND.toUpperCase();
        if (!(sender instanceof Player)) {
            this.checkArgs(1, Messages.NOT_ENOUGH_ARGS);
            Player target = Bukkit.getPlayer((String)args[0]);
            this.checkNotNull(target, Messages.PLAYER_DOES_NOT_EXIST.replace("{player}", args[0]));
            CraftingOpenEvent event = new CraftingOpenEvent(target);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCanceled()) {
                if (Settings.USE_CRAFTING_SOUNDS) {
                    target.playSound(target.getLocation(), Sound.valueOf((String)craftOpenSound), 1.0f, Settings.USE_RANDOM_SOUND_PITCH ? (float)Math.random() : 1.0f);
                    Utils.debugLog("Played the sound " + craftOpenSound + " to player " + target.getName(), new String[0]);
                }
                target.openWorkbench(target.getLocation(), true);
                Utils.debugLog("Opened the crafting inventory for" + target.getName() + ".", new String[0]);
            }
            if (args.length > 1 && Settings.USE_TOO_MANY_ARGS) {
                this.returnTell(Messages.TOO_MANY_ARGS);
            }
            return;
        }
        Player player = (Player)sender;
        if (Settings.USE_PERMISSIONS) {
            this.checkPerms((CommandSender)player, Permissions.CRAFTING);
        }
        if (args.length == 0) {
            if (Settings.USE_CRAFTING_SOUNDS) {
                player.playSound(player.getLocation(), Sound.valueOf((String)craftOpenSound), 1.0f, Settings.USE_RANDOM_SOUND_PITCH ? (float)Math.random() : 1.0f);
                Utils.debugLog("Played the sound " + craftOpenSound + " to player " + player.getName(), new String[0]);
            }
            player.openWorkbench(player.getLocation(), true);
            Utils.debugLog("Opened the crafting inventory.", new String[0]);
            this.returnTell(Messages.OPENED_CRAFTING);
        }
        if (args.length == 1) {
            if (Settings.USE_PERMISSIONS) {
                this.checkPerms((CommandSender)player, Permissions.CRAFTING_OTHER);
            }
            Player target = Bukkit.getPlayer((String)args[0]);
            this.checkNotNull(target, Messages.PLAYER_DOES_NOT_EXIST.replace("{player}", args[0]));
            CraftingOpenEvent event = new CraftingOpenEvent(target);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCanceled()) {
                if (Settings.USE_CRAFTING_SOUNDS) {
                    target.playSound(target.getLocation(), Sound.valueOf((String)craftOpenSound), 1.0f, Settings.USE_RANDOM_SOUND_PITCH ? (float)Math.random() : 1.0f);
                    Utils.debugLog("Played the sound " + craftOpenSound + " to player " + target.getName(), new String[0]);
                }
                target.openWorkbench(target.getLocation(), true);
                Utils.debugLog("Opened the crafting inventory for" + target.getName() + ".", new String[0]);
                this.tellTarget(target, Messages.OPENED_CRAFTING);
                this.returnTell(Messages.OPENED_CRAFTING_OTHER.replace("{player}", target.getName()));
            }
        }
        if (args.length > 1 && Settings.USE_TOO_MANY_ARGS) {
            this.returnTell(Messages.TOO_MANY_ARGS);
        }
    }

    public static CraftCommand getInstance() {
        return instance;
    }

    public static void setInstance(CraftCommand instance) {
        CraftCommand.instance = instance;
    }
}

