/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.commands;

import com.itsschatten.libs.Utils;
import com.itsschatten.libs.commandutils.UniversalCommand;
import com.itsschatten.portablecrafting.Permissions;
import com.itsschatten.portablecrafting.PortableCraftingInvsPlugin;
import com.itsschatten.portablecrafting.configs.Messages;
import com.itsschatten.portablecrafting.configs.Settings;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EnchantmentTableCommand
extends UniversalCommand {
    public EnchantmentTableCommand() {
        super("enchanttable");
        this.setAliases(Arrays.asList("enchtable", "ectable", "enchantmenttable"));
        this.setPermission(Settings.USE_PERMISSIONS ? Permissions.ENCHANT_TABLE.getPermission() : "");
        this.setPermissionMessage(Utils.getNoPermsMessage().replace("{prefix}", Messages.PREFIX).replace("{permission}", Permissions.ENCHANT_TABLE.getPermission()));
    }

    @Override
    protected void run(CommandSender sender, String[] args) {
        String sound = Settings.ENCHANT_TABLE_OPEN_SOUND.toUpperCase();
        if (!(sender instanceof Player)) {
            if (args.length == 0) {
                this.returnTell(Messages.NOT_ENOUGH_ARGS);
            }
            Player target = Bukkit.getPlayer((String)args[0]);
            this.checkNotNull(target, Messages.PLAYER_DOES_NOT_EXIST.replace("{player}", args[0]));
            this.openEnchantingForTarget(sound, target);
            return;
        }
        Player player = (Player)sender;
        if (Settings.USE_PERMISSIONS) {
            this.checkPerms((CommandSender)player, Permissions.ENCHANT_TABLE);
        }
        if (args.length == 0 && PortableCraftingInvsPlugin.getFakeContainers().openEnchant(player)) {
            if (Settings.USE_ENCHANT_TABLE_SOUNDS) {
                player.playSound(player.getLocation(), Sound.valueOf((String)sound), 1.0f, Settings.USE_RANDOM_SOUND_PITCH ? (float)Math.random() : 1.0f);
                Utils.debugLog("Playing sound " + sound + " to " + player.getName(), new String[0]);
            }
            Utils.debugLog("Opened the enchantment table.", new String[0]);
            this.returnTell(Messages.OPENED_ENCHANT_TABLE);
        }
        if (args.length == 1) {
            try {
                if (Settings.USE_PERMISSIONS) {
                    this.checkPerms((CommandSender)player, Permissions.ENCHANT_USE_MAX_LEVEL);
                }
                Integer.parseInt(args[0]);
                int maxLevel = this.getNumber(0, 1, Settings.ENCHANT_MAX_LEVEL, Messages.MUST_BE_IN_RANGE.replace("{max}", "" + Settings.ENCHANT_MAX_LEVEL).replace("{min}", "1"));
                if (PortableCraftingInvsPlugin.getFakeContainers().openEnchant(player, maxLevel)) {
                    if (Settings.USE_ENCHANT_TABLE_SOUNDS) {
                        player.playSound(player.getLocation(), Sound.valueOf((String)sound), 1.0f, Settings.USE_RANDOM_SOUND_PITCH ? (float)Math.random() : 1.0f);
                        Utils.debugLog("Playing sound " + sound + " to " + player.getName(), new String[0]);
                    }
                    Utils.debugLog("Opened the enchantment table with max level " + maxLevel, new String[0]);
                    this.returnTell(Messages.OPENED_ENCHANT_WITH_MAX_LEVEL.replace("{level}", "" + maxLevel));
                }
            }
            catch (NumberFormatException ex) {
                if (Settings.USE_PERMISSIONS) {
                    this.checkPerms((CommandSender)player, Permissions.ENCHANT_TABLE_OTHER);
                }
                Player target = Bukkit.getPlayer((String)args[0]);
                this.checkNotNull(target, Messages.PLAYER_DOES_NOT_EXIST.replace("{player}", args[0]));
                this.openEnchantingForTarget(sound, target);
            }
        }
        if (args.length > 2 && Settings.USE_TOO_MANY_ARGS) {
            this.returnTell(Messages.TOO_MANY_ARGS);
        }
    }

    private void openEnchantingForTarget(String sound, Player target) {
        if (PortableCraftingInvsPlugin.getFakeContainers().openEnchant(target)) {
            if (Settings.USE_ENCHANT_TABLE_SOUNDS) {
                target.playSound(target.getLocation(), Sound.valueOf((String)sound), 1.0f, Settings.USE_RANDOM_SOUND_PITCH ? (float)Math.random() : 1.0f);
                Utils.debugLog("Playing sound " + sound + " to " + target.getName(), new String[0]);
            }
            Utils.debugLog("Opened the enchantment table.", new String[0]);
            this.tellTarget(target, Messages.OPENED_ENCHANT_TABLE);
            this.returnTell(Messages.OPENED_ENCHANT_TABLE_OTHER);
        }
    }
}

