/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.commands;

import com.itsschatten.libs.Utils;
import com.itsschatten.libs.commandutils.UniversalCommand;
import com.itsschatten.portablecrafting.Permissions;
import com.itsschatten.portablecrafting.configs.Messages;
import com.itsschatten.portablecrafting.configs.Settings;
import com.itsschatten.portablecrafting.events.EnderchestOpenEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;

public class EnderChestCommand
extends UniversalCommand {
    private static final Set<UUID> players = new HashSet<UUID>();
    static EnderChestCommand instance = null;

    public EnderChestCommand() {
        super("enderchest");
        EnderChestCommand.setInstance(this);
        this.setAliases(Arrays.asList("ec", "echest"));
        this.setPermission(Settings.USE_PERMISSIONS ? Permissions.ENDERCHEST.getPermission() : "");
        this.setPermissionMessage(Utils.getNoPermsMessage().replace("{prefix}", Messages.PREFIX).replace("{permission}", Permissions.ENDERCHEST.getPermission()));
    }

    @Override
    protected void run(CommandSender sender, String[] args) {
        String sound = Settings.ENDER_CHEST_OPEN_SOUND.toUpperCase();
        if (!(sender instanceof Player)) {
            this.checkArgsStrict(1, Messages.NOT_ENOUGH_ARGS);
            Player target = Bukkit.getPlayer((String)args[0]);
            EnderchestOpenEvent event = new EnderchestOpenEvent(target);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCanceled()) {
                if (Settings.USE_ENDERCHEST_SOUNDS) {
                    target.playSound(target.getLocation(), Sound.valueOf((String)sound), 1.0f, Settings.USE_RANDOM_SOUND_PITCH ? (float)Math.random() : 1.0f);
                    Utils.debugLog("Playing sound " + sound + " to " + target.getName(), new String[0]);
                }
                if (Settings.USE_ENDERCHEST_RESTRICTION) {
                    players.add(target.getUniqueId());
                }
                target.openInventory(target.getEnderChest());
                Utils.debugLog("Opening " + target.getName() + "'s enderchest for themselves.", new String[0]);
                this.tellTarget(target, Messages.OPENED_ENDERCHEST);
            }
            return;
        }
        Player player = (Player)sender;
        if (Settings.USE_PERMISSIONS) {
            this.checkPerms((CommandSender)player, Permissions.ENDERCHEST);
        }
        if (args.length == 0) {
            Inventory eChest = player.getEnderChest();
            EnderchestOpenEvent event = new EnderchestOpenEvent(player);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCanceled()) {
                player.openInventory(eChest);
                Utils.debugLog("Opened inventory", new String[0]);
                if (Settings.USE_ENDERCHEST_SOUNDS) {
                    player.playSound(player.getLocation(), Sound.valueOf((String)sound), 1.0f, Settings.USE_RANDOM_SOUND_PITCH ? (float)Math.random() : 1.0f);
                    Utils.debugLog("Playing sound " + sound + " to " + player.getName(), new String[0]);
                }
                if (Settings.USE_ENDERCHEST_RESTRICTION) {
                    players.add(player.getUniqueId());
                }
                this.returnTell(Messages.OPENED_ENDERCHEST);
            }
        }
        if (args.length == 1) {
            if (Settings.USE_PERMISSIONS) {
                this.checkPerms((CommandSender)player, Permissions.ENDERCHEST_OTHER);
            }
            Player target = Bukkit.getPlayer((String)args[0]);
            this.checkNotNull(target, Messages.PLAYER_DOES_NOT_EXIST.replace("{player}", args[0]));
            Inventory targetEChest = target.getEnderChest();
            if (Settings.USE_OLD_ENDERCHEST) {
                this.openEnderchestForPlayer(sound, player, target, targetEChest, player.getName());
                this.returnTell(Messages.OPEN_TARGET_ENDERCHEST_OLD.replace("{player}", target.getName()).replace("{playerFormatted}", target.getName().endsWith("s") ? target.getName() + "'" : target.getName() + "'s"));
            }
            EnderchestOpenEvent event = new EnderchestOpenEvent(target);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCanceled()) {
                this.openEnderchestForPlayer(sound, target, target, targetEChest, player.getName());
                this.returnTell(Messages.OPEN_TARGET_ENDERCHEST.replace("{player}", target.getName()).replace("{playerFormatted}", target.getName().endsWith("s") ? target.getName() + "'" : target.getName() + "'s"));
            }
        }
        if (args.length > 1 && Settings.USE_TOO_MANY_ARGS) {
            this.returnTell(Messages.TOO_MANY_ARGS);
        }
    }

    private void openEnderchestForPlayer(String sound, Player player, Player target, Inventory targetEChest, String name) {
        if (Settings.USE_ENDERCHEST_RESTRICTION) {
            players.add(target.getUniqueId());
        }
        player.openInventory(targetEChest);
        Utils.debugLog("Opening " + target.getName() + " enderchest for " + player.getName(), new String[0]);
        if (Settings.USE_ENDERCHEST_SOUNDS) {
            player.playSound(player.getLocation(), Sound.valueOf((String)sound), 1.0f, Settings.USE_RANDOM_SOUND_PITCH ? (float)Math.random() : 1.0f);
            Utils.debugLog("Playing sound " + sound + " to " + name, new String[0]);
        }
    }

    public static Set<UUID> getPlayers() {
        return players;
    }

    public static EnderChestCommand getInstance() {
        return instance;
    }

    public static void setInstance(EnderChestCommand instance) {
        EnderChestCommand.instance = instance;
    }
}

