/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.commands;

import com.itsschatten.libs.Utils;
import com.itsschatten.libs.commandutils.UniversalCommand;
import com.itsschatten.portablecrafting.Permissions;
import com.itsschatten.portablecrafting.PortableCraftingInvsPlugin;
import com.itsschatten.portablecrafting.configs.Messages;
import com.itsschatten.portablecrafting.configs.Settings;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GrindStoneCommand
extends UniversalCommand {
    public GrindStoneCommand() {
        super("grindstone");
        this.setAliases(Arrays.asList("grstone", "gstone"));
        this.setPermission(Settings.USE_PERMISSIONS ? Permissions.GRINDSTONE.getPermission() : "");
        this.setPermissionMessage(Utils.getNoPermsMessage().replace("{prefix}", Messages.PREFIX).replace("{permission}", Permissions.GRINDSTONE.getPermission()));
    }

    @Override
    protected void run(CommandSender commandSender, String[] args) {
        String grindStoneOpen = Settings.GRINDSTONE_OPEN_SOUND.toUpperCase();
        if (!(commandSender instanceof Player)) {
            this.checkArgs(1, Messages.NOT_ENOUGH_ARGS);
            Player target = Bukkit.getPlayer((String)args[0]);
            this.checkNotNull(target, Messages.PLAYER_DOES_NOT_EXIST.replace("{player}", args[0]));
            if (PortableCraftingInvsPlugin.getFakeContainers().openGrindStone(target)) {
                if (Settings.USE_GRINDSTONE_SOUNDS) {
                    target.playSound(target.getLocation(), Sound.valueOf((String)grindStoneOpen), 1.0f, Settings.USE_RANDOM_SOUND_PITCH ? (float)Math.random() : 1.0f);
                    Utils.debugLog("Playing sound " + grindStoneOpen + " to " + target.getName(), new String[0]);
                }
                Utils.debugLog("Opened the grindstone for " + target.getName(), new String[0]);
                this.tellTarget(target, Messages.OPENED_GRINDSTONE);
                this.returnTell(Messages.OPENED_GRINDSTONE_OTHER.replace("{target}", target.getName()));
            }
            return;
        }
        Player player = (Player)commandSender;
        if (Settings.USE_PERMISSIONS) {
            this.checkPerms((CommandSender)player, Permissions.GRINDSTONE);
        }
        if (args.length == 0 && PortableCraftingInvsPlugin.getFakeContainers().openGrindStone(player)) {
            if (Settings.USE_GRINDSTONE_SOUNDS) {
                player.playSound(player.getLocation(), Sound.valueOf((String)grindStoneOpen), 1.0f, Settings.USE_RANDOM_SOUND_PITCH ? (float)Math.random() : 1.0f);
                Utils.debugLog("Playing sound " + grindStoneOpen + " to " + player.getName(), new String[0]);
            }
            Utils.debugLog("Opened the grindstone for " + player.getName(), new String[0]);
            this.returnTell(Messages.OPENED_GRINDSTONE);
        }
        if (args.length == 1) {
            if (Settings.USE_PERMISSIONS) {
                this.checkPerms((CommandSender)player, Permissions.GRINDSTONE_OTHER);
            }
            Player target = Bukkit.getPlayer((String)args[0]);
            this.checkNotNull(target, Messages.PLAYER_DOES_NOT_EXIST.replace("{target}", args[0]));
            if (PortableCraftingInvsPlugin.getFakeContainers().openGrindStone(target)) {
                if (Settings.USE_GRINDSTONE_SOUNDS) {
                    target.playSound(target.getLocation(), Sound.valueOf((String)grindStoneOpen), 1.0f, Settings.USE_RANDOM_SOUND_PITCH ? (float)Math.random() : 1.0f);
                    Utils.debugLog("Playing sound " + grindStoneOpen + " to " + target.getName(), new String[0]);
                }
                Utils.debugLog("Opened the grindstone for " + target.getName(), new String[0]);
                this.tellTarget(target, Messages.OPENED_GRINDSTONE);
                this.returnTell(Messages.OPENED_GRINDSTONE_OTHER.replace("{target}", target.getName()));
            }
        }
        if (args.length > 1 && Settings.USE_TOO_MANY_ARGS) {
            this.returnTell(Messages.TOO_MANY_ARGS);
        }
    }
}

