/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.commands;

import com.itsschatten.libs.Utils;
import com.itsschatten.libs.commandutils.UniversalCommand;
import com.itsschatten.portablecrafting.Permissions;
import com.itsschatten.portablecrafting.PortableCraftingInvsPlugin;
import com.itsschatten.portablecrafting.configs.Messages;
import com.itsschatten.portablecrafting.configs.Settings;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LoomCommand
extends UniversalCommand {
    public LoomCommand() {
        super("loom");
        this.setPermission(Settings.USE_PERMISSIONS ? Permissions.LOOM.getPermission() : "");
        this.setPermissionMessage(Utils.getNoPermsMessage().replace("{prefix}", Messages.PREFIX).replace("{permission}", Permissions.LOOM.getPermission()));
    }

    @Override
    protected void run(CommandSender commandSender, String[] args) {
        String loomSoundOpen = Settings.LOOM_OPEN_SOUND.toUpperCase();
        if (!(commandSender instanceof Player)) {
            this.checkArgs(1, Messages.NOT_ENOUGH_ARGS);
            Player target = Bukkit.getPlayer((String)args[0]);
            this.checkNotNull(target, Messages.PLAYER_DOES_NOT_EXIST.replace("{player}", args[0]));
            if (PortableCraftingInvsPlugin.getFakeContainers().openLoom(target)) {
                if (Settings.USE_LOOM_SOUNDS) {
                    target.playSound(target.getLocation(), Sound.valueOf((String)loomSoundOpen), 1.0f, Settings.USE_RANDOM_SOUND_PITCH ? (float)Math.random() : 1.0f);
                    Utils.debugLog("Playing sound " + loomSoundOpen + " to " + target.getName(), new String[0]);
                }
                Utils.debugLog("Opened the loom for " + target.getName(), new String[0]);
                this.tellTarget(target, Messages.OPENED_LOOM);
                this.returnTell(Messages.OPENED_LOOM_OTHER.replace("{player}", target.getName()));
            }
            return;
        }
        Player player = (Player)commandSender;
        if (Settings.USE_PERMISSIONS) {
            this.checkPerms((CommandSender)player, Permissions.LOOM);
        }
        if (args.length == 0 && PortableCraftingInvsPlugin.getFakeContainers().openLoom(player)) {
            if (Settings.USE_LOOM_SOUNDS) {
                player.playSound(player.getLocation(), Sound.valueOf((String)loomSoundOpen), 1.0f, Settings.USE_RANDOM_SOUND_PITCH ? (float)Math.random() : 1.0f);
                Utils.debugLog("Playing sound " + loomSoundOpen + " to " + player.getName(), new String[0]);
            }
            Utils.debugLog("Opened the loom for " + player.getName(), new String[0]);
            this.returnTell(Messages.OPENED_LOOM);
        }
        if (args.length == 1) {
            if (Settings.USE_PERMISSIONS) {
                this.checkPerms((CommandSender)player, Permissions.LOOM_OTHER);
            }
            Player target = Bukkit.getPlayer((String)args[0]);
            this.checkNotNull(target, Messages.PLAYER_DOES_NOT_EXIST.replace("{player}", args[0]));
            if (PortableCraftingInvsPlugin.getFakeContainers().openLoom(target)) {
                if (Settings.USE_LOOM_SOUNDS) {
                    target.playSound(target.getLocation(), Sound.valueOf((String)loomSoundOpen), 1.0f, Settings.USE_RANDOM_SOUND_PITCH ? (float)Math.random() : 1.0f);
                    Utils.debugLog("Playing sound " + loomSoundOpen + " to " + target.getName(), new String[0]);
                }
                Utils.debugLog("Opened the loom for " + target.getName(), new String[0]);
                this.tellTarget(target, Messages.OPENED_LOOM);
                this.returnTell(Messages.OPENED_LOOM_OTHER.replace("{player}", target.getName()));
            }
        }
        if (args.length > 1 && Settings.USE_TOO_MANY_ARGS) {
            this.returnTell(Messages.TOO_MANY_ARGS);
        }
    }
}

