/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.commands;

import com.itsschatten.libs.InteractiveMessages;
import com.itsschatten.libs.Utils;
import com.itsschatten.libs.commandutils.UniversalCommand;
import com.itsschatten.portablecrafting.MigrationTask;
import com.itsschatten.portablecrafting.Permissions;
import com.itsschatten.portablecrafting.PortableCraftingInvsPlugin;
import com.itsschatten.portablecrafting.commands.CraftCommand;
import com.itsschatten.portablecrafting.commands.EnderChestCommand;
import com.itsschatten.portablecrafting.configs.Messages;
import com.itsschatten.portablecrafting.configs.Settings;
import com.itsschatten.portablecrafting.configs.SignsConfig;
import com.itsschatten.portablecrafting.storage.StorageMedium;
import com.itsschatten.portablecrafting.virtual.VirtualManager;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.md_5.bungee.api.chat.ClickEvent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class PortableCraftingInvsCommand
extends UniversalCommand {
    private static final List<String> TABBABLE = Arrays.asList("help", "version", "rl", "reload", "migrate");
    private static final List<String> CONFIGS = Arrays.asList("settings", "messages", "signs");

    public PortableCraftingInvsCommand() {
        super("portablecraftinginvs");
        this.setAliases(Arrays.asList("portablecraftinginv", "pci", "pi", "portableinv"));
    }

    @Override
    protected void run(CommandSender commandSender, String @NotNull [] args) {
        String param;
        if (args.length > 2 && Settings.USE_TOO_MANY_ARGS) {
            this.returnTell(Messages.TOO_MANY_ARGS);
        }
        if (args.length == 0) {
            this.tell(Messages.NOT_ENOUGH_ARGS + Messages.HELP_MESSAGE);
            return;
        }
        switch (param = args[0].toLowerCase()) {
            case "help": {
                this.returnTell(Messages.HELP_MESSAGE);
                break;
            }
            case "dump": {
                this.returnTell("&cYou've found a command that doesn't function at all yet!");
                break;
            }
            case "migrate": {
                if (!commandSender.hasPermission("pci.migrate")) {
                    this.returnTell("&cYou do not have permission to migrate data.");
                    return;
                }
                if (args.length >= 2) {
                    try {
                        StorageMedium medium = StorageMedium.valueOf(args[1].toUpperCase());
                        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Utils.getInstance(), (Runnable)new MigrationTask(medium));
                        this.tell("&aAttempting to migrate your data!");
                        this.tell("&7&oYou will not be notified when it completes! Check the console for when it will complete.");
                    }
                    catch (IllegalArgumentException ex) {
                        this.returnTell("&cInvalid medium! Must be one of the following: &e" + String.join((CharSequence)", ", Stream.of(StorageMedium.values()).map(Enum::name).toList()));
                    }
                    break;
                }
                this.returnTell("&cPlease provide which medium you want to migrate to.");
                break;
            }
            case "info": 
            case "ver": 
            case "version": {
                if (VirtualManager.getInstance() == null || !VirtualManager.getInstance().isLoaded()) {
                    this.tell("&7&oPortableCraftingInvs by ItsSchatten&r\n&8&oThis information may be used to debug issues and may be requested when reporting a bug report.\n&r\n&c&lThis server is not using Virtual tiles!\n&eYou are currently running version &b{ver}&e of PCI.\n&r\n&cThis server is running &3{version}&c.\n&cThis server is using {medium}&c as its storage solution.\n&7(&oUnused due to not utilizing virtual tiles.&7)".replace("{ver}", Utils.getInstance().getDescription().getVersion()).replace("{version}", Bukkit.getVersion()).replace("{medium}", VirtualManager.getInstance().getStorage().implementationName()));
                } else {
                    this.tell("&7&oPortableCraftingInvs by ItsSchatten&r\n&8&oThis information may be used to debug issues and may be requested when reporting a bug report.\n&r\n&a&lThis server is using Virtual tiles!\n&eYou are currently running version &b{ver}&e of PCI.\n&eThis server currently has &b{total_players} total players&e that have created at least one virtual tile entity.\n&r\n&cThis server is running &3{version}&c.\n&cThis server has &3{total_active_ticking}&c ticking virtual tiles.\n&cThis server is using {medium}&c as its storage solution.".replace("{ver}", Utils.getInstance().getDescription().getVersion()).replace("{total_players}", "" + VirtualManager.getInstance().allUniquePlayers()).replace("{version}", Bukkit.getVersion()).replace("{total_active_ticking}", "" + VirtualManager.getInstance().totalTickingVirtualTiles()).replace("{medium}", "&a" + VirtualManager.getInstance().getStorage().implementationName()));
                }
                String url = "https://github.com/ItsSchatten/PortableCraftingInvs/issues/new?labels=type%3A+bug%2Cpriority%3A+normal%2Cstatus%3A+awaiting+confirmation&template=bug_report.yml&version=" + this.getVersionInfoForURL();
                if (commandSender instanceof Player) {
                    Player player = (Player)commandSender;
                    InteractiveMessages.builder("&6[Open a Bug Report]").onHover("&7Click to open a bug report on PortableCraftingInvs Github.").onClick(ClickEvent.Action.OPEN_URL, url).send(player);
                    break;
                }
                this.tell("&6Click the below link to open a bug report for PortableCraftingInvs.");
                this.tell(url);
                break;
            }
            case "reload": 
            case "rl": {
                this.checkPerms(commandSender, Permissions.RELOAD);
                if (args.length == 1) {
                    Messages.getInstance().reload();
                    Settings.getInstance().reload();
                    if (SignsConfig.getInstance() != null && Settings.USE_SIGNS) {
                        SignsConfig.getInstance().reload();
                    } else if (Settings.USE_SIGNS) {
                        SignsConfig.init();
                    }
                    this.tell(Messages.RELOAD_MESSAGE);
                } else if (args.length == 2) {
                    String param2;
                    switch (param2 = args[1].toLowerCase()) {
                        case "settings": {
                            Settings.getInstance().reload();
                            this.tell(Messages.RELOAD_SPECIFIC.replace("{file}", "settings.yml"));
                            break;
                        }
                        case "messages": {
                            Messages.getInstance().reload();
                            this.tell(Messages.RELOAD_SPECIFIC.replace("{file}", "messages.yml"));
                            break;
                        }
                        case "signs": {
                            if (SignsConfig.getInstance() != null && Settings.USE_SIGNS) {
                                SignsConfig.getInstance().reload();
                            } else if (Settings.USE_SIGNS) {
                                SignsConfig.init();
                            }
                            this.tell(Messages.RELOAD_SPECIFIC.replace("{file}", "signs.yml"));
                        }
                        default: {
                            this.tell(Messages.WRONG_ARGS);
                        }
                    }
                }
                if (Bukkit.getPluginManager().isPluginEnabled("Essentials") && !Settings.USE_CRAFTING) {
                    PortableCraftingInvsPlugin.getInstance().unregisterCommand(CraftCommand.getInstance());
                    CraftCommand.setInstance(null);
                    Utils.logWarning("&c&lAttention:&c The craft command has been disabled, it cannot be re-enabled until a server restart is performed.", new String[0]);
                }
                if (!Bukkit.getPluginManager().isPluginEnabled("Essentials") || Settings.USE_ENDERCHEST) break;
                PortableCraftingInvsPlugin.getInstance().unregisterCommand(EnderChestCommand.getInstance());
                EnderChestCommand.setInstance(null);
                Utils.logWarning("&c&lAttention:&c The enderchest command has been disabled, it cannot be re-enabled until a server restart is performed.", new String[0]);
                break;
            }
            default: {
                if (Settings.USE_HELP_IF_WRONG_ARGS) {
                    this.tell(Messages.HELP_MESSAGE);
                }
                this.returnTell(Messages.WRONG_ARGS);
            }
        }
    }

    @Contract(pure=true)
    @NotNull
    private String getVersionInfoForURL() {
        return URLEncoder.encode("Server Version: {server}\nPCI Version: {ver}\n \nStorage Medium: {medium}".replace("{server}", Bukkit.getVersion()).replace("{ver}", Utils.getInstance().getDescription().getVersion()).replace("{medium}", Settings.STORAGE_MEDIUM), StandardCharsets.UTF_8);
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, String @NotNull [] args) throws IllegalArgumentException {
        if (args.length == 1) {
            String arg = args[0];
            ArrayList<String> list = new ArrayList<String>();
            for (String tab : TABBABLE) {
                if (!tab.startsWith(arg.toLowerCase())) continue;
                list.add(tab.toLowerCase());
            }
            return list;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("migrate") && sender.hasPermission("pci.migrate")) {
            return Stream.of(StorageMedium.values()).map(Enum::name).filter(name -> name.toLowerCase().contains(args[1].toLowerCase())).toList();
        }
        if (args.length == 2 && (args[0].equalsIgnoreCase("reload") || args[0].equalsIgnoreCase("rl"))) {
            String arg2 = args[1];
            ArrayList<String> configList = new ArrayList<String>();
            for (String tab : CONFIGS) {
                if (!tab.startsWith(arg2)) continue;
                configList.add(tab);
            }
            return configList;
        }
        return super.tabComplete(sender, alias, args);
    }
}

