/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.commands;

import com.itsschatten.libs.Utils;
import com.itsschatten.libs.commandutils.UniversalCommand;
import com.itsschatten.portablecrafting.Permissions;
import com.itsschatten.portablecrafting.PortableCraftingInvsPlugin;
import com.itsschatten.portablecrafting.configs.Messages;
import com.itsschatten.portablecrafting.configs.Settings;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SmithingCommand
extends UniversalCommand {
    public SmithingCommand() {
        super("smithing");
        this.setPermission(Settings.USE_PERMISSIONS ? Permissions.SMITHING_TABLE.getPermission() : "");
        this.setPermissionMessage(Utils.getNoPermsMessage().replace("{prefix}", Messages.PREFIX).replace("{permission}", Permissions.SMITHING_TABLE.getPermission()));
        this.setAliases(Arrays.asList("smithing-table", "smithingtable"));
    }

    @Override
    protected void run(CommandSender commandSender, String[] args) {
        String smithingTableOpen = Settings.SMITHING_TABLE_OPEN_SOUND;
        if (!(commandSender instanceof Player)) {
            this.checkArgs(1, Messages.NOT_ENOUGH_ARGS);
            Player target = Bukkit.getPlayer((String)args[0]);
            this.checkNotNull(target, Messages.PLAYER_DOES_NOT_EXIST.replace("{player}", args[1]));
            if (PortableCraftingInvsPlugin.getFakeContainers().openSmithing(target)) {
                if (Settings.USE_SMITHING_TABLE_SOUNDS) {
                    target.playSound(target.getLocation(), Sound.valueOf((String)smithingTableOpen), 1.0f, Settings.USE_RANDOM_SOUND_PITCH ? (float)Math.random() : 1.0f);
                    Utils.debugLog("Playing sound " + smithingTableOpen + " to " + target.getName(), new String[0]);
                }
                Utils.debugLog("Opened the smithing table for " + target.getName(), new String[0]);
                this.tellTarget(target, Messages.OPENED_SMITHING_TABLE);
                this.returnTell(Messages.OPENED_SMITHING_TABLE_OTHER.replace("{player}", target.getName()));
            }
            return;
        }
        Player player = (Player)commandSender;
        if (Settings.USE_PERMISSIONS) {
            this.checkPerms((CommandSender)player, Permissions.SMITHING_TABLE);
        }
        if (args.length == 0) {
            if (Settings.USE_SMITHING_TABLE_SOUNDS) {
                player.playSound(player.getLocation(), Sound.valueOf((String)smithingTableOpen), 1.0f, Settings.USE_RANDOM_SOUND_PITCH ? (float)Math.random() : 1.0f);
                Utils.debugLog("Playing sound " + smithingTableOpen + " to " + player.getName(), new String[0]);
            }
            PortableCraftingInvsPlugin.getFakeContainers().openSmithing(player);
            Utils.debugLog("Opened the smithing table for " + player.getName(), new String[0]);
            this.returnTell(Messages.OPENED_SMITHING_TABLE);
        }
        if (args.length == 1) {
            if (Settings.USE_PERMISSIONS) {
                this.checkPerms((CommandSender)player, Permissions.SMITHING_TABLE_OTHER);
            }
            Player target = Bukkit.getPlayer((String)args[0]);
            this.checkNotNull(target, Messages.PLAYER_DOES_NOT_EXIST.replace("{player}", args[0]));
            if (PortableCraftingInvsPlugin.getFakeContainers().openSmithing(target)) {
                if (Settings.USE_SMITHING_TABLE_SOUNDS) {
                    target.playSound(target.getLocation(), Sound.valueOf((String)smithingTableOpen), 1.0f, Settings.USE_RANDOM_SOUND_PITCH ? (float)Math.random() : 1.0f);
                    Utils.debugLog("Playing sound " + smithingTableOpen + " to " + target.getName(), new String[0]);
                }
                Utils.debugLog("Opened the smithing table for " + target.getName(), new String[0]);
                this.tellTarget(target, Messages.OPENED_SMITHING_TABLE);
                this.returnTell(Messages.OPENED_SMITHING_TABLE_OTHER.replace("{player}", target.getName()));
            }
        }
        if (args.length > 1 && Settings.USE_TOO_MANY_ARGS) {
            this.returnTell(Messages.TOO_MANY_ARGS);
        }
    }
}

