/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.configs;

import com.itsschatten.libs.Utils;
import com.itsschatten.libs.configutils.SimpleConfig;
import com.itsschatten.portablecrafting.PortableCraftingInvsPlugin;
import com.itsschatten.portablecrafting.storage.StorageMedium;
import com.itsschatten.portablecrafting.virtual.ISettings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Untainted;
import org.bukkit.Bukkit;
import org.bukkit.Server;

public class Settings
extends SimpleConfig
implements ISettings {
    public static StorageMedium CURRENT_MEDIUM = null;
    public static boolean SILENT_START_UP;
    public static boolean ATTEMPT_MIGRATION_AT_START;
    public static boolean DEBUG;
    public static boolean USE_PERMISSIONS;
    public static boolean USE_UPDATER;
    public static boolean USE_METRICS;
    public static boolean USE_MESSAGES;
    public static boolean USE_TOO_MANY_ARGS;
    public static boolean USE_HELP_IF_WRONG_ARGS;
    public static boolean USE_RANDOM_SOUND_PITCH;
    public static boolean USE_SIGNS;
    public static boolean USE_VIRTUAL_TILES;
    public static boolean REQUIRE_SIGHT_CLICK_BREAK_SIGN;
    public static boolean USE_ENDERCHEST;
    public static boolean USE_ENDERCHEST_RESTRICTION;
    public static boolean USE_OLD_ENDERCHEST;
    public static boolean USE_ENCHANT_TABLE;
    public static boolean USE_ENCHANT_MAX_LEVEL_ARGUMENT;
    public static boolean USE_CRAFTING;
    public static boolean USE_ANVIL;
    public static boolean USE_GRINDSTONE;
    public static boolean USE_LOOM;
    public static boolean USE_CARTOGRAPHY;
    public static boolean USE_STONE_CUTTER;
    public static boolean USE_SMITHING_TABLE;
    public static boolean USE_FURNACE;
    public static boolean USE_BLAST_FURNACE;
    public static boolean USE_SMOKER;
    public static boolean USE_BREWING;
    public static boolean USE_ANVIL_SOUNDS;
    public static boolean USE_CRAFTING_SOUNDS;
    public static boolean USE_ENCHANT_TABLE_SOUNDS;
    public static boolean USE_ENDERCHEST_SOUNDS;
    public static boolean USE_GRINDSTONE_SOUNDS;
    public static boolean USE_LOOM_SOUNDS;
    public static boolean USE_CARTOGRAPHY_SOUNDS;
    public static boolean USE_STONE_CUTTER_SOUNDS;
    public static boolean USE_SMITHING_TABLE_SOUNDS;
    public static boolean USE_ANVIL_SIGN;
    public static boolean USE_BLAST_FURNACE_SIGN;
    public static boolean USE_BREWING_STAND_SIGN;
    public static boolean USE_CARTOGRAPHY_SIGN;
    public static boolean USE_CRAFTING_SIGN;
    public static boolean USE_ENDERCHEST_SIGN;
    public static boolean USE_ENCHANT_TABLE_SIGN;
    public static boolean USE_FURNACE_SIGN;
    public static boolean USE_GRINDSTONE_SIGN;
    public static boolean USE_LOOM_SIGN;
    public static boolean USE_STONE_CUTTER_SIGN;
    public static boolean USE_SMITHING_SIGN;
    public static boolean USE_SMOKER_SIGN;
    public static int UPDATE_CHECK_INTERVAL;
    public static int ENCHANT_MAX_LEVEL;
    public static String ENDER_CHEST_OPEN_SOUND;
    public static String ENCHANT_TABLE_OPEN_SOUND;
    public static String CRAFTING_OPEN_SOUND;
    public static String ANVIL_OPEN_SOUND;
    public static String GRINDSTONE_OPEN_SOUND;
    public static String LOOM_OPEN_SOUND;
    public static String CARTOGRAPHY_OPEN_SOUND;
    public static String STONE_CUTTER_OPEN_SOUND;
    public static String SMITHING_TABLE_OPEN_SOUND;
    public static String STORAGE_MEDIUM;
    public static String DATABASE_ADDRESS;
    public static String DATABASE_USER;
    public static String DATABASE_PASSWORD;
    public static String DATABASE_DATABASE;
    @Untainted
    public static String DATABASE_PREFIX;
    public static int POOL_MAX_SIZE;
    public static int POOL_MIN_CONNECTIONS;
    public static int POOL_MAX_LIFE;
    public static int POOL_KEEP_ALIVE;
    public static int POOL_CONNECTION_TIMEOUT;
    public static Map<String, Object> PROPERTIES;
    private static Settings instance;

    public Settings(String fileName, StorageMedium current) {
        super(fileName);
        CURRENT_MEDIUM = current;
        Settings.setInstance(this);
    }

    public static void init() {
        new Settings("settings.yml", CURRENT_MEDIUM).onLoad();
        Utils.debugLog("Loaded the settings.yml file.", new String[0]);
    }

    private void onLoad() {
        PROPERTIES = new HashMap<String, Object>();
        SILENT_START_UP = this.getBoolean("silent-start");
        ATTEMPT_MIGRATION_AT_START = this.getBoolean("attempt-migration-at-start");
        DEBUG = this.getBoolean("debug");
        UPDATE_CHECK_INTERVAL = this.getInt("update-check-interval");
        USE_PERMISSIONS = this.getBoolean("use-permissions");
        USE_MESSAGES = this.getBoolean("use-messages");
        STORAGE_MEDIUM = this.getString("method");
        if (CURRENT_MEDIUM == null) {
            CURRENT_MEDIUM = StorageMedium.valueOf(Objects.requireNonNullElse(STORAGE_MEDIUM, "YAML").toUpperCase());
        }
        DATABASE_ADDRESS = this.getString("database.address");
        DATABASE_USER = this.getString("database.username");
        DATABASE_PASSWORD = this.getString("database.password");
        DATABASE_DATABASE = this.getString("database.database");
        DATABASE_PREFIX = this.getString("database.table-prefix");
        POOL_MAX_SIZE = this.getInt("database.pool-config.maximum-pool-size");
        POOL_MIN_CONNECTIONS = this.getInt("database.pool-config.minimum-idle-connections");
        POOL_MAX_LIFE = this.getInt("database.pool-config.maximum-lifetime");
        POOL_KEEP_ALIVE = this.getInt("database.pool-config.keep-alive-timeout");
        POOL_CONNECTION_TIMEOUT = this.getInt("database.pool-config.connection-timeout");
        PROPERTIES = this.getConfigurationSection("database.pool-config.properties").getValues(true);
        USE_VIRTUAL_TILES = this.getBoolean("use-virtual-tiles");
        USE_FURNACE = this.getBoolean("use-furnace");
        USE_BLAST_FURNACE = this.getBoolean("use-blast-furnace");
        USE_SMOKER = this.getBoolean("use-smoker");
        USE_BREWING = this.getBoolean("use-brewing");
        USE_TOO_MANY_ARGS = this.getBoolean("use-too-many-args");
        USE_HELP_IF_WRONG_ARGS = this.getBoolean("use-help-if-no-args");
        USE_UPDATER = this.getBoolean("use-updater");
        USE_METRICS = this.getBoolean("metrics");
        USE_CRAFTING = this.getBoolean("use-crafting");
        USE_ENDERCHEST = this.getBoolean("use-enderchest");
        USE_OLD_ENDERCHEST = this.getBoolean("old-enderchest");
        USE_ENCHANT_TABLE = this.getBoolean("use-enchanttable");
        USE_ENCHANT_MAX_LEVEL_ARGUMENT = this.getBoolean("allow-max-level-argument");
        ENCHANT_MAX_LEVEL = this.getInt("maximum-enchant-level");
        USE_ANVIL = this.getBoolean("use-anvil");
        USE_ENDERCHEST_RESTRICTION = this.getBoolean("ender-chest-restrictions");
        USE_GRINDSTONE = this.getBoolean("use-grindstone");
        USE_LOOM = this.getBoolean("use-loom");
        USE_CARTOGRAPHY = this.getBoolean("use-cartography");
        USE_STONE_CUTTER = this.getBoolean("use-stonecutter");
        USE_SMITHING_TABLE = this.getBoolean("use-smithing-table");
        USE_ANVIL_SOUNDS = this.getBoolean("use-anvil-sounds");
        USE_CRAFTING_SOUNDS = this.getBoolean("use-crafting-sounds");
        USE_ENCHANT_TABLE_SOUNDS = this.getBoolean("use-enchanttable-sounds");
        USE_ENDERCHEST_SOUNDS = this.getBoolean("use-enderchest-sounds");
        USE_GRINDSTONE_SOUNDS = this.getBoolean("use-grindstone-sounds");
        USE_LOOM_SOUNDS = this.getBoolean("use-loom-sounds");
        USE_CARTOGRAPHY_SOUNDS = this.getBoolean("use-cartography-sounds");
        USE_STONE_CUTTER_SOUNDS = this.getBoolean("use-stonecutter-sounds");
        USE_SMITHING_TABLE_SOUNDS = this.getBoolean("use-smithing-table-sounds");
        ENDER_CHEST_OPEN_SOUND = this.getString("enderchest-open-sound");
        ENCHANT_TABLE_OPEN_SOUND = this.getString("enchanttable-open-sound");
        CRAFTING_OPEN_SOUND = this.getString("crafting-open-sound");
        ANVIL_OPEN_SOUND = this.getString("anvil-open-sound");
        GRINDSTONE_OPEN_SOUND = this.getString("grindstone-open-sound");
        LOOM_OPEN_SOUND = this.getString("loom-open-sound");
        CARTOGRAPHY_OPEN_SOUND = this.getString("cartography-open-sound");
        STONE_CUTTER_OPEN_SOUND = this.getString("stonecutter-open-sound");
        SMITHING_TABLE_OPEN_SOUND = this.getString("smithing-open-sound");
        USE_RANDOM_SOUND_PITCH = this.getBoolean("use-random-sound-pitch");
        USE_SIGNS = this.getBoolean("use-signs");
        REQUIRE_SIGHT_CLICK_BREAK_SIGN = this.getBoolean("require-shift-click-to-break-signs");
        USE_ANVIL_SIGN = this.getBoolean("use-anvil-sign");
        USE_BLAST_FURNACE_SIGN = this.getBoolean("use-blast-furnace-sign");
        USE_BREWING_STAND_SIGN = this.getBoolean("use-brewing-sign");
        USE_CARTOGRAPHY_SIGN = this.getBoolean("use-cartography-sign");
        USE_CRAFTING_SIGN = this.getBoolean("use-crafting-sign");
        USE_ENDERCHEST_SIGN = this.getBoolean("use-enderchest-sign");
        USE_ENCHANT_TABLE_SIGN = this.getBoolean("use-enchanttable-sign");
        USE_FURNACE_SIGN = this.getBoolean("use-furnace-sign");
        USE_GRINDSTONE_SIGN = this.getBoolean("use-grindstone-sign");
        USE_LOOM_SIGN = this.getBoolean("use-loom-sign");
        USE_STONE_CUTTER_SIGN = this.getBoolean("use-stonecutter-sign");
        USE_SMITHING_SIGN = this.getBoolean("use-smithingtable-sign");
        USE_SMOKER_SIGN = this.getBoolean("use-smoker-sign");
        Utils.setDebugMode(DEBUG);
    }

    public void reload() {
        Settings.setInstance(null);
        Settings.init();
        PortableCraftingInvsPlugin.getInstance().getManager().setSettings(this);
        if (StorageMedium.valueOf(STORAGE_MEDIUM.toUpperCase()) != CURRENT_MEDIUM) {
            Utils.logError("Hey! Just so you're aware you cannot change the storage medium during runtime, please restart the server for that change to take effect.", new String[0]);
            Utils.logError("After switching over you may migrate your data to your new medium by running '/pci migrate'.", new String[0]);
        }
        Utils.debugLog("Reloaded the settings.yml file.", new String[0]);
    }

    @Override
    public int maximumFurnaces() {
        return this.getInt("maximum-furnaces", 3);
    }

    @Override
    public int maximumBrewingStands() {
        return this.getInt("maximum-brewing-stands", 3);
    }

    @Override
    public boolean useFurnaces() {
        return USE_VIRTUAL_TILES && USE_FURNACE;
    }

    @Override
    public boolean useBrewingStands() {
        if (PortableCraftingInvsPlugin.isPaperServer()) {
            try {
                Method minecraftVersion = Server.class.getDeclaredMethod("getMinecraftVersion", new Class[0]);
                String ver = (String)minecraftVersion.invoke((Object)Bukkit.getServer(), new Object[0]);
                if (!ver.contains("1.21") && !ver.equalsIgnoreCase("1.20.6")) {
                    Utils.logWarning("!!! ATTENTION !!! Due to breaking changes (and the goal to only actively support the latest Minecraft) the brewing stands cannot be used. Please update to a Minecraft 1.21.1 to continue using them.", new String[0]);
                    return false;
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                Utils.logError(e);
                Utils.logError("Failed to parse minecraft version!", new String[0]);
                Utils.logWarning("!!! ATTENTION !!! Due to breaking changes (and the goal to only actively support the latest Minecraft) the brewing stands cannot be used. Please update to a Minecraft 1.21.1 to continue using them.", new String[0]);
                return false;
            }
        }
        if (!PortableCraftingInvsPlugin.getServerVersion().contains("v1_21") && !PortableCraftingInvsPlugin.getServerVersion().equalsIgnoreCase("v1_20_R4")) {
            Utils.logWarning("!!! ATTENTION !!! Due to breaking changes (and the goal to only actively support the latest Minecraft) the brewing stands cannot be used. Please update to a Minecraft 1.21.1 to continue using them.", new String[0]);
            return false;
        }
        return USE_VIRTUAL_TILES && USE_BREWING;
    }

    public static Settings getInstance() {
        return instance;
    }

    private static void setInstance(Settings instance) {
        Settings.instance = instance;
    }
}

