/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.listeners;

import com.itsschatten.libs.Utils;
import com.itsschatten.portablecrafting.commands.EnderChestCommand;
import com.itsschatten.portablecrafting.configs.Messages;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.jetbrains.annotations.NotNull;

public class EnderchestListener
implements Listener {
    @EventHandler(priority=EventPriority.LOW)
    public void onEnderchestClick(@NotNull InventoryClickEvent event) {
        if (EnderChestCommand.getPlayers().contains(event.getWhoClicked().getUniqueId()) && event.getWhoClicked().getOpenInventory().getType().equals((Object)InventoryType.ENDER_CHEST)) {
            Utils.debugLog("Player " + event.getWhoClicked().getName() + " is contained in the set, and their open inventory is the Enderchest.", new String[0]);
            if (event.getSlotType().equals((Object)InventoryType.SlotType.OUTSIDE)) {
                return;
            }
            if (event.getClick().isShiftClick()) {
                event.setCancelled(true);
                return;
            }
            if (event.getClickedInventory() == null) {
                return;
            }
            if (event.getClickedInventory().equals((Object)event.getWhoClicked().getInventory()) && (event.getAction().equals((Object)InventoryAction.PLACE_ALL) || event.getAction().equals((Object)InventoryAction.PLACE_SOME) || event.getAction().equals((Object)InventoryAction.PLACE_ONE))) {
                Utils.tell((CommandSender)event.getWhoClicked(), Messages.CANT_RETRIEVE_ITEM_FROM_ENDER);
                Utils.debugLog("Player " + event.getWhoClicked().getName() + " clicked their own inventory with an item. Event canceled, message sent.", new String[0]);
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onInventoryClose(@NotNull InventoryCloseEvent event) {
        if (event.getPlayer().getOpenInventory().getType().equals((Object)InventoryType.ENDER_CHEST) && EnderChestCommand.getPlayers().contains(event.getPlayer().getUniqueId())) {
            EnderChestCommand.getPlayers().remove(event.getPlayer().getUniqueId());
            Utils.debugLog("Removed " + event.getPlayer().getName() + " from the enderchest Set.", new String[0]);
        }
    }
}

