/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.listeners;

import com.itsschatten.libs.UpdateNotifications;
import com.itsschatten.libs.Utils;
import com.itsschatten.libs.configutils.PlayerConfigManager;
import com.itsschatten.portablecrafting.Permissions;
import com.itsschatten.portablecrafting.configs.Settings;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;

public class PlayerJoinListener
implements Listener {
    final UpdateNotifications notifications;

    public PlayerJoinListener(UpdateNotifications notifications) {
        this.notifications = notifications;
    }

    @EventHandler
    public void onJoin(@NotNull PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!Settings.USE_UPDATER) {
            return;
        }
        if (!player.hasPermission(Permissions.UPDATE_NOTIFICATIONS.getPermission())) {
            return;
        }
        if (Settings.USE_UPDATER && this.notifications != null && this.notifications.isUpdateAvailable()) {
            PluginDescriptionFile pdf = Utils.getInstance().getDescription();
            Utils.debugLog("Found an update for the plugin, sending the message to the player.", new String[0]);
            Utils.tell((CommandSender)player, this.notifications.getUpdateMessage().replace("{currentVer}", pdf.getVersion()).replace("{newVer}", UpdateNotifications.getLatestVersion()).replace("{link}", "https://spigotmc.org/resources/" + UpdateNotifications.getProjectId()));
        }
    }

    @EventHandler
    public void onLeave(@NotNull PlayerQuitEvent event) {
        PlayerConfigManager.removeConfig(event.getPlayer());
    }
}

