/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.storage;

import com.itsschatten.libs.Utils;
import com.itsschatten.libs.hikari.HikariConfig;
import com.itsschatten.libs.hikari.HikariDataSource;
import com.itsschatten.portablecrafting.configs.Settings;
import com.itsschatten.portablecrafting.virtual.Storage;
import com.itsschatten.portablecrafting.virtual.utils.FurnaceType;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Player;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

public abstract class HikariConnection
implements Storage {
    @Language(value="SQL")
    public static final String COUNT_UNIQUE = "SELECT COUNT(DISTINCT `owner`) AS 'count' FROM `{prefix}brewing_stand_storage` UNION SELECT COUNT(DISTINCT `owner`) FROM `{prefix}furnace_storage`".replace("{prefix}", Settings.DATABASE_PREFIX);
    @Language(value="SQL")
    public static final String COUNT_FURNACE = "SELECT COUNT(`owner`) AS `count` FROM `{prefix}furnace_storage` WHERE `owner` = ? AND `type` = ?".replace("{prefix}", Settings.DATABASE_PREFIX);
    @Language(value="SQL")
    public static final String COUNT_BREWING = "SELECT COUNT(`owner`) AS `count` FROM `{prefix}brewing_stand_storage` WHERE `owner` = ?".replace("{prefix}", Settings.DATABASE_PREFIX);
    @Language(value="SQL")
    public static final String CHECK_FURNACE_EXISTS = "SELECT 1 FROM `{prefix}furnace_storage`".replace("{prefix}", Settings.DATABASE_PREFIX) + "WHERE `uuid` = ? AND `owner` = ?";
    @Language(value="SQL")
    public static final String CHECK_STAND_EXISTS = "SELECT 1 FROM `{prefix}brewing_stand_storage`".replace("{prefix}", Settings.DATABASE_PREFIX) + "WHERE `uuid` = ? AND `owner` = ?";
    @Language(value="SQL")
    public static final String GET_FURNACE = "SELECT * FROM `{prefix}furnace_storage` WHERE `owner` = ? AND `uuid` = ?".replace("{prefix}", Settings.DATABASE_PREFIX);
    @Language(value="SQL")
    public static final String GET_STAND = "SELECT * FROM `{prefix}brewing_stand_storage` WHERE `owner` = ? AND `uuid` = ?".replace("{prefix}", Settings.DATABASE_PREFIX);
    @Language(value="SQL")
    public static final String SAVE_FURNACE = "INSERT INTO `{prefix}furnace_storage` ".replace("{prefix}", Settings.DATABASE_PREFIX) + "(`uuid`, `owner`, `last_opened`, `type`, `cook_time`,`fuel_time`,`total_fuel`,`experience`,`fuel_item`,`input_item`,`output_item`, `title`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
    @Language(value="SQL")
    public static final String UPDATE_FURNACE = "UPDATE `{prefix}furnace_storage`".replace("{prefix}", Settings.DATABASE_PREFIX) + "SET `last_opened` = ?, `cook_time` = ?,`fuel_time` = ?, `total_fuel`= ?, `experience` = ?,`fuel_item` = ?, `input_item` = ?,`output_item` = ?, `title` = ? WHERE `uuid` = ? AND `owner` = ?";
    @Language(value="SQL")
    public static final String SAVE_STAND = "INSERT INTO `{prefix}brewing_stand_storage`".replace("{prefix}", Settings.DATABASE_PREFIX) + "(`uuid`, `owner`, `last_opened`, `fuel_time`, `brew_time`, `max_brews`, `fuel_item`, `ingredient`, `bottle_1`,`bottle_2`,`bottle_3`,`title`) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)";
    @Language(value="SQL")
    public static final String UPDATE_STAND = "UPDATE `{prefix}brewing_stand_storage`".replace("{prefix}", Settings.DATABASE_PREFIX) + "SET `last_opened` = ?, `fuel_time` = ?, `brew_time` = ?,`max_brews` = ?, `fuel_item` = ?,`ingredient` = ?, `bottle_1` = ?, `bottle_2` = ?, `bottle_3` = ?, `title` = ? WHERE `uuid` = ? AND `owner` = ?";
    @Language(value="SQL")
    public static final String GET_FURNACE_FROM_OWNER = "SELECT `id`,`uuid` FROM `{prefix}furnace_storage` WHERE `owner` = ? AND `type` = ? ORDER BY `id`".replace("{prefix}", Settings.DATABASE_PREFIX);
    @Language(value="SQL")
    public static final String GET_STAND_UUID_FROM_OWNER = "SELECT `id`,`uuid` FROM `{prefix}brewing_stand_storage` WHERE `owner` = ? ORDER BY `id`".replace("{prefix}", Settings.DATABASE_PREFIX);
    private final String address;
    private final String database;
    private final String username;
    private final String password;
    private final int maximumPoolSize;
    private final int minimumIdleConnections;
    private final int maxLifetime;
    private final int keepAliveTimeout;
    private final int connectionTimeout;
    private final Map<String, Object> properties;
    public HikariDataSource dataSource;

    public HikariConnection(String address, String database, String username, String password, int maximumPoolSize, int minimumIdleConnections, int maxLifetime, int keepAliveTimeout, int connectionTimeout, @NotNull Map<String, Object> properties) {
        this.address = address;
        this.database = database;
        this.username = username;
        this.password = password;
        this.maximumPoolSize = maximumPoolSize;
        this.minimumIdleConnections = minimumIdleConnections;
        this.maxLifetime = maxLifetime;
        this.keepAliveTimeout = keepAliveTimeout;
        this.connectionTimeout = connectionTimeout;
        this.properties = properties;
    }

    public final void init() {
        HikariConfig config;
        try {
            config = new HikariConfig();
        }
        catch (LinkageError er) {
            Utils.logError(er);
            Utils.logError("Failed to create a hikari config!", "https://github.com/ItsSchatten/PortableCraftingInvs/issues/new?template=bug_report.yml&labels=labels=type%3A+bug%2Cpriority%3A+normal%2Cstatus%3A+awaiting+confirmation");
            return;
        }
        config.setPoolName("portable-crafting-invs-hikari");
        this.configure(config);
        this.overrideProperties(this.properties);
        if (!this.properties.isEmpty()) {
            this.properties.forEach(config::addDataSourceProperty);
        }
        config.setMaximumPoolSize(this.maximumPoolSize);
        config.setMinimumIdle(this.minimumIdleConnections);
        config.setMaxLifetime(this.maxLifetime);
        config.setConnectionTimeout(this.connectionTimeout);
        config.setKeepaliveTime(this.keepAliveTimeout);
        config.setInitializationFailTimeout(-1L);
        this.dataSource = new HikariDataSource(config);
        this.postInit();
        HikariConnection.deregisterDriver(this.driverClass());
    }

    @Override
    public int getPlayerBrewingStandCount(Player player) {
        return this.getCount(player, COUNT_BREWING, null);
    }

    @Override
    public int getPlayerFurnaceCount(Player player, FurnaceType type) {
        return this.getCount(player, COUNT_FURNACE, type);
    }

    private int getCount(Player player, String statementString, FurnaceType type) {
        CompletableFuture<Integer> countFurnaces = CompletableFuture.supplyAsync(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
        try {
            return countFurnaces.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Utils.logError(e);
            return 0;
        }
    }

    @Override
    public int getUniquePlayers() {
        CompletableFuture<Integer> countPlayers = CompletableFuture.supplyAsync(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
        try {
            return countPlayers.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Utils.logError(e);
            return 0;
        }
    }

    @Override
    public final void shutdown() {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }

    @NotNull
    public final Connection getConnection() throws SQLException {
        if (this.dataSource == null) {
            throw new SQLException("Failed to get a connection from Hikari. (dataSource is null?)");
        }
        Connection connection = this.dataSource.getConnection();
        if (connection == null) {
            throw new SQLException("Unable to get a connection from Hikari. (dataSource.getConnection() returned null?)");
        }
        return connection;
    }

    protected void postInit() {
        try (Connection connection = this.getConnection();){
            try (PreparedStatement statement = connection.prepareStatement("CREATE TABLE IF NOT EXISTS {prefix}furnace_storage (".replace("{prefix}", Settings.DATABASE_PREFIX) + "`id` int NOT NULL AUTO_INCREMENT,`uuid` VARCHAR(36) NOT NULL,`owner` VARCHAR(36) NOT NULL,`last_opened` DATETIME NOT NULL DEFAULT current_timestamp(),`type` ENUM('BLASTING','FURNACE','SMOKER') NOT NULL DEFAULT 'FURNACE',`cook_time` INT,`fuel_time` INT ,`total_fuel` INT ,`experience` FLOAT(2),`fuel_item` TEXT,`input_item` TEXT,`output_item` TEXT,`title` TEXT,PRIMARY KEY (`id`),UNIQUE INDEX `uuid_owner` (`uuid`, `owner`)) DEFAULT CHARSET = utf8mb4");){
                statement.execute();
            }
            statement = connection.prepareStatement("CREATE TABLE IF NOT EXISTS {prefix}brewing_stand_storage (".replace("{prefix}", Settings.DATABASE_PREFIX) + "`id` int NOT NULL AUTO_INCREMENT,`uuid` VARCHAR(36) NOT NULL,`owner` VARCHAR(36) NOT NULL,`last_opened` DATETIME NOT NULL DEFAULT current_timestamp(),`brew_time` INT,`fuel_time` INT ,`max_brews` INT,`fuel_item` TEXT,`ingredient` TEXT,`bottle_1` TEXT,`bottle_2` TEXT,`bottle_3` TEXT,`title` TEXT,PRIMARY KEY (`id`),UNIQUE INDEX `uuid_owner` (`uuid`, `owner`)) DEFAULT CHARSET = utf8mb4");
            try {
                statement.execute();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException e) {
            Utils.logError(e);
            Utils.logError("Failed to create the tables!", new String[0]);
        }
    }

    protected void configure(@NotNull HikariConfig config) {
        String[] addressSplit = this.getAddress().split(":");
        String address = addressSplit[0];
        String port = addressSplit.length > 1 ? addressSplit[1] : this.defaultPort();
        config.setDriverClassName(this.driverClass());
        config.setJdbcUrl(String.format("jdbc:%s://%s:%s/%s", this.jdbcId(), address, port, this.getDatabase()));
        config.setUsername(this.getUsername());
        config.setPassword(this.getPassword());
    }

    protected void overrideProperties(@NotNull Map<String, Object> properties) {
        properties.putIfAbsent("socketTimeout", String.valueOf(TimeUnit.SECONDS.toMillis(30L)));
    }

    protected abstract String defaultPort();

    protected abstract String driverClass();

    protected abstract String jdbcId();

    public final String getAddress() {
        return Objects.requireNonNull(this.address, "'address' cannot be null");
    }

    public final String getDatabase() {
        return Objects.requireNonNull(this.database, "'database' cannot be null");
    }

    public final String getUsername() {
        return Objects.requireNonNull(this.username, "'username' cannot be null");
    }

    public final String getPassword() {
        return Objects.requireNonNull(this.password, "'password' cannot be null");
    }

    private static void deregisterDriver(String driverClassName) {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (!driver.getClass().getName().equals(driverClassName)) continue;
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException sQLException) {}
        }
    }
}

