/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.storage.implementations.sql;

import com.itsschatten.libs.Utils;
import com.itsschatten.portablecrafting.storage.HikariConnection;
import com.itsschatten.portablecrafting.storage.StorageCredentials;
import com.itsschatten.portablecrafting.virtual.machine.BrewingStand;
import com.itsschatten.portablecrafting.virtual.machine.Furnace;
import com.itsschatten.portablecrafting.virtual.utils.FurnaceType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MySQLStorage
extends HikariConnection {
    public MySQLStorage(@NotNull StorageCredentials credentials) {
        this(credentials.address(), credentials.database(), credentials.username(), credentials.password(), credentials.maxPool(), credentials.minIdle(), credentials.maxLife(), credentials.keepAlive(), credentials.connectionTimeout(), credentials.properties());
    }

    public MySQLStorage(String address, String database, String username, String password, int maximumPoolSize, int minimumIdleConnections, int maxLifetime, int keepAliveTimeout, int connectionTimeout, @NotNull Map<String, Object> properties) {
        super(address, database, username, password, maximumPoolSize, minimumIdleConnections, maxLifetime, keepAliveTimeout, connectionTimeout, properties);
    }

    @Override
    protected String defaultPort() {
        return "3306";
    }

    @Override
    protected String driverClass() {
        return "com.itsschatten.libs.drivers.mysql.cj.jdbc.Driver";
    }

    @Override
    protected String jdbcId() {
        return "mysql";
    }

    @Override
    protected void overrideProperties(@NotNull Map<String, Object> properties) {
        properties.putIfAbsent("cachePrepStmts", "true");
        properties.putIfAbsent("prepStmtCacheSize", "250");
        properties.putIfAbsent("prepStmtCacheSqlLimit", "2048");
        properties.putIfAbsent("useServerPrepStmts", "true");
        properties.putIfAbsent("useLocalSessionState", "true");
        properties.putIfAbsent("rewriteBatchedStatements", "true");
        properties.putIfAbsent("cacheResultSetMetadata", "true");
        properties.putIfAbsent("cacheServerConfiguration", "true");
        properties.putIfAbsent("elideSetAutoCommits", "true");
        properties.putIfAbsent("maintainTimeStats", "false");
        properties.putIfAbsent("alwaysSendSetIsolation", "false");
        properties.putIfAbsent("cacheCallableStmts", "true");
        properties.putIfAbsent("serverTimezone", "UTC");
        super.overrideProperties(properties);
    }

    @Override
    public String implementationName() {
        return "MySQL";
    }

    @Override
    public void saveFurnace(UUID uuid, Furnace furnace) {
        if (furnace == null) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Utils.getInstance(), () -> {
            block33: {
                try (Connection connection = this.getConnection();
                     PreparedStatement statement = connection.prepareStatement(CHECK_FURNACE_EXISTS);){
                    statement.setString(1, furnace.getUniqueId().toString());
                    statement.setString(2, uuid.toString());
                    HashMap<String, Object> data = new HashMap<String, Object>(furnace.serializeForSQL());
                    try (ResultSet resultSet = statement.executeQuery();){
                        if (!resultSet.next()) {
                            try (PreparedStatement insertStatement = connection.prepareStatement(SAVE_FURNACE);){
                                insertStatement.setString(1, furnace.getUniqueId().toString());
                                insertStatement.setString(2, uuid.toString());
                                insertStatement.setTimestamp(3, Timestamp.from(Instant.now()));
                                insertStatement.setString(4, furnace.getType().name());
                                insertStatement.setInt(5, (Integer)data.get("cook_time"));
                                insertStatement.setInt(6, (Integer)data.get("fuel_time"));
                                insertStatement.setInt(7, (Integer)data.get("total_fuel"));
                                insertStatement.setFloat(8, ((Float)data.get("experience")).floatValue());
                                insertStatement.setString(9, (String)data.get("fuel_item"));
                                insertStatement.setString(10, (String)data.get("input_item"));
                                insertStatement.setString(11, (String)data.get("output_item"));
                                insertStatement.setString(12, (String)data.get("title"));
                                insertStatement.executeUpdate();
                                break block33;
                            }
                        }
                        try (PreparedStatement updateStatement = connection.prepareStatement(UPDATE_FURNACE);){
                            updateStatement.setString(10, furnace.getUniqueId().toString());
                            updateStatement.setString(11, uuid.toString());
                            updateStatement.setTimestamp(1, Timestamp.from(Instant.now()));
                            updateStatement.setInt(2, (Integer)data.get("cook_time"));
                            updateStatement.setInt(3, (Integer)data.get("fuel_time"));
                            updateStatement.setInt(4, (Integer)data.get("total_fuel"));
                            updateStatement.setFloat(5, ((Float)data.get("experience")).floatValue());
                            updateStatement.setString(6, (String)data.get("fuel_item"));
                            updateStatement.setString(7, (String)data.get("input_item"));
                            updateStatement.setString(8, (String)data.get("output_item"));
                            updateStatement.setString(9, (String)data.get("title"));
                            updateStatement.executeUpdate();
                        }
                    }
                }
                catch (SQLException exception) {
                    Utils.logError(exception);
                }
            }
        });
    }

    @Override
    public Furnace loadFurnace(UUID player, UUID uuid) {
        CompletableFuture<Map<String, Object>> future = this.getDataFromDatabase(GET_FURNACE, player, uuid);
        try {
            Map<String, Object> data = future.get();
            return Furnace.deserializeFromSQL(data);
        }
        catch (InterruptedException | ExecutionException e) {
            Utils.logError(e);
            return null;
        }
    }

    @Override
    public void saveBrewingStand(@NotNull UUID uuid, BrewingStand brewingStand) {
        if (brewingStand == null) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Utils.getInstance(), () -> {
            block33: {
                try (Connection connection = this.getConnection();
                     PreparedStatement statement = connection.prepareStatement(CHECK_STAND_EXISTS);){
                    statement.setString(1, brewingStand.getUniqueId().toString());
                    statement.setString(2, uuid.toString());
                    HashMap<String, Object> data = new HashMap<String, Object>(brewingStand.serializeForSQL());
                    try (ResultSet resultSet = statement.executeQuery();){
                        if (!resultSet.next()) {
                            try (PreparedStatement insertStatement = connection.prepareStatement(SAVE_STAND);){
                                insertStatement.setString(1, brewingStand.getUniqueId().toString());
                                insertStatement.setString(2, uuid.toString());
                                insertStatement.setTimestamp(3, Timestamp.from(Instant.now()));
                                insertStatement.setInt(4, (Integer)data.get("fuel_time"));
                                insertStatement.setInt(5, (Integer)data.get("brew_time"));
                                insertStatement.setInt(6, (Integer)data.get("max_brews"));
                                insertStatement.setString(7, (String)data.get("fuel_item"));
                                insertStatement.setString(8, (String)data.get("ingredient"));
                                insertStatement.setString(9, (String)data.get("bottle_1"));
                                insertStatement.setString(10, (String)data.get("bottle_2"));
                                insertStatement.setString(11, (String)data.get("bottle_3"));
                                insertStatement.setString(12, (String)data.get("title"));
                                insertStatement.executeUpdate();
                                break block33;
                            }
                        }
                        try (PreparedStatement updateStatement = connection.prepareStatement(UPDATE_STAND);){
                            updateStatement.setString(11, brewingStand.getUniqueId().toString());
                            updateStatement.setString(12, uuid.toString());
                            updateStatement.setTimestamp(1, Timestamp.from(Instant.now()));
                            updateStatement.setInt(2, (Integer)data.get("fuel_time"));
                            updateStatement.setInt(3, (Integer)data.get("brew_time"));
                            updateStatement.setInt(4, (Integer)data.get("max_brews"));
                            updateStatement.setString(5, (String)data.get("fuel_item"));
                            updateStatement.setString(6, (String)data.get("ingredient"));
                            updateStatement.setString(7, (String)data.get("bottle_1"));
                            updateStatement.setString(8, (String)data.get("bottle_2"));
                            updateStatement.setString(9, (String)data.get("bottle_3"));
                            updateStatement.setString(10, (String)data.get("title"));
                            updateStatement.executeUpdate();
                        }
                    }
                }
                catch (SQLException exception) {
                    Utils.logError(exception);
                    Utils.logError("Failed to save a brewing stand (" + String.valueOf(brewingStand.getUniqueId()) + ") to your MySQL database!", new String[0]);
                }
            }
        });
    }

    @Override
    public BrewingStand loadBrewingStand(UUID player, UUID uuid) {
        CompletableFuture<Map<String, Object>> future = this.getDataFromDatabase(GET_STAND, player, uuid);
        try {
            Map<String, Object> data = future.get();
            return BrewingStand.deserializeFromSQL(data);
        }
        catch (InterruptedException | ExecutionException e) {
            Utils.logError(e);
            return null;
        }
    }

    @Override
    @Nullable
    public UUID getFurnaceUUIDFromID(UUID owner, Integer id, FurnaceType type) {
        return this.obtainUUID(owner, id, GET_FURNACE_FROM_OWNER, type == null ? FurnaceType.FURNACE : type);
    }

    @Override
    @Nullable
    public UUID getBrewingStandUUIDFromID(UUID owner, Integer id) {
        return this.obtainUUID(owner, id, GET_STAND_UUID_FROM_OWNER, null);
    }

    @Nullable
    private UUID obtainUUID(UUID player, Integer id, String getUuidFromOwner, FurnaceType type) {
        CompletableFuture<UUID> future = CompletableFuture.supplyAsync(() -> {
            ArrayList<UUID> uuids = new ArrayList<UUID>();
            try (Connection connection = this.getConnection();){
                UUID uUID;
                block23: {
                    PreparedStatement statement = connection.prepareStatement(getUuidFromOwner);
                    try {
                        statement.setString(1, player.toString());
                        if (type != null) {
                            statement.setString(2, type.name().toLowerCase());
                        }
                        try (ResultSet set = statement.executeQuery();){
                            while (set.next()) {
                                uuids.add(UUID.fromString(set.getString("uuid")));
                            }
                        }
                        UUID uUID2 = uuids.isEmpty() ? null : (uUID = uuids.size() <= id ? null : (UUID)uuids.get(id));
                        if (statement == null) break block23;
                    }
                    catch (Throwable throwable) {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    statement.close();
                }
                return uUID;
            }
            catch (SQLException exception) {
                Utils.logError(exception);
                return null;
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Utils.logError(e);
            return null;
        }
    }

    @NotNull
    private CompletableFuture<Map<String, Object>> getDataFromDatabase(String getString, UUID player, UUID machine) {
        return CompletableFuture.supplyAsync(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }
}

