/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.virtual;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.itsschatten.libs.Utils;
import com.itsschatten.portablecrafting.virtual.ISettings;
import com.itsschatten.portablecrafting.virtual.fuel.BrewingFuel;
import com.itsschatten.portablecrafting.virtual.fuel.FurnaceFuel;
import com.itsschatten.portablecrafting.virtual.recipe.BrewingRecipe;
import com.itsschatten.portablecrafting.virtual.recipe.FurnaceRecipe;
import com.itsschatten.portablecrafting.virtual.utils.FurnaceType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class RecipeManager {
    private static RecipeManager instance;
    private final Map<NamespacedKey, FurnaceFuel> furnaceFuelMap;
    private final Map<NamespacedKey, BrewingFuel> brewingFuelMap;
    private final Multimap<NamespacedKey, FurnaceRecipe> furnaceRecipeMap;
    private final Map<NamespacedKey, BrewingRecipe> brewingRecipeMap;

    public RecipeManager(ISettings settings) {
        instance = this;
        this.furnaceFuelMap = new HashMap<NamespacedKey, FurnaceFuel>();
        this.brewingFuelMap = new HashMap<NamespacedKey, BrewingFuel>();
        this.furnaceRecipeMap = HashMultimap.create();
        this.brewingRecipeMap = new HashMap<NamespacedKey, BrewingRecipe>();
        if (settings.useFurnaces()) {
            this.loadFuels();
            this.loadFurnaceRecipes();
        }
        if (settings.useBrewingStands()) {
            this.registerBrewingFuel(BrewingFuel.BLAZE_POWDER);
            this.loadBrewingRecipes();
        }
        if (Utils.isDebugMode()) {
            this.logNotRegisteredFuels();
        }
    }

    public final boolean registerFurnaceFuel(@NotNull FurnaceFuel fuel) {
        if (this.furnaceFuelMap.containsKey(fuel.getKey())) {
            return false;
        }
        this.furnaceFuelMap.put(fuel.getKey(), fuel);
        return true;
    }

    public final boolean registerBrewingFuel(@NotNull BrewingFuel fuel) {
        if (this.brewingFuelMap.containsKey(fuel.getKey())) {
            return false;
        }
        this.brewingFuelMap.put(fuel.getKey(), fuel);
        return true;
    }

    public final void logNotRegisteredFuels() {
        Arrays.stream(Material.values()).filter(Material::isFuel).filter(fuel -> FurnaceFuel.VANILLA_FUELS.stream().filter(furnaceFuel -> furnaceFuel.matches((Material)fuel)).findAny().isEmpty()).forEach(fuel -> Utils.debugLog("Furnace Fuel not registered: " + String.valueOf(fuel), new String[0]));
    }

    public final void loadFuels() {
        FurnaceFuel.VANILLA_FUELS.forEach(this::registerFurnaceFuel);
    }

    public final void loadFurnaceRecipes() {
        Iterator recipes = Bukkit.recipeIterator();
        while (recipes.hasNext()) {
            RecipeChoice recipeChoice;
            Recipe recipe = (Recipe)recipes.next();
            if (recipe instanceof CampfireRecipe || !(recipe instanceof CookingRecipe)) continue;
            CookingRecipe furnaceRecipe = (CookingRecipe)recipe;
            FurnaceType type = recipe instanceof BlastingRecipe ? FurnaceType.BLASTING : (recipe instanceof SmokingRecipe ? FurnaceType.SMOKER : FurnaceType.FURNACE);
            Utils.debugLog("Loading " + String.valueOf(furnaceRecipe.getKey()) + " (a " + String.valueOf((Object)type) + " recipe) into the recipes.", new String[0]);
            if (!furnaceRecipe.getKey().getNamespace().equalsIgnoreCase("minecraft")) {
                Utils.log("Loading a non-minecraft recipe (or at minimum a recipe that is not under the Minecraft namespace): " + String.valueOf(furnaceRecipe.getKey()) + " If any issues arise with this recipe please post an issue on the PortableCraftingInvs Github. (run /pci info in-game)", new String[0]);
            }
            if (!((recipeChoice = furnaceRecipe.getInputChoice()) instanceof RecipeChoice.MaterialChoice)) continue;
            RecipeChoice.MaterialChoice choice = (RecipeChoice.MaterialChoice)recipeChoice;
            FurnaceRecipe customRecipe = choice.getChoices().size() > 1 ? new FurnaceRecipe(furnaceRecipe.getKey().getKey(), furnaceRecipe.getResult(), (List<Material>)choice.getChoices(), furnaceRecipe.getCookingTime(), furnaceRecipe.getExperience(), type) : new FurnaceRecipe(furnaceRecipe.getKey().getKey(), furnaceRecipe.getResult(), (Material)choice.getChoices().getFirst(), furnaceRecipe.getCookingTime(), furnaceRecipe.getExperience(), type);
            this.furnaceRecipeMap.put((Object)customRecipe.getKey(), (Object)customRecipe);
        }
        Utils.log("Loaded a total of " + this.furnaceRecipeMap.size() + " furnace recipes.", new String[0]);
    }

    public final void loadBrewingRecipes() {
        ArrayList<BrewingRecipe> recipes = new ArrayList<BrewingRecipe>();
        recipes.addAll(BrewingRecipe.getAllRecipes("awkward", Material.NETHER_WART, PotionType.WATER, PotionType.AWKWARD));
        recipes.addAll(this.getMundane(Material.REDSTONE));
        recipes.addAll(this.getMundane(Material.SUGAR));
        recipes.addAll(this.getMundane(Material.RABBIT));
        recipes.addAll(this.getMundane(Material.GLISTERING_MELON_SLICE));
        recipes.addAll(this.getMundane(Material.SPIDER_EYE));
        recipes.addAll(this.getMundane(Material.MAGMA_CREAM));
        recipes.addAll(this.getMundane(Material.BLAZE_POWDER));
        recipes.addAll(this.getMundane(Material.GHAST_TEAR));
        recipes.addAll(BrewingRecipe.getAllRecipes("thick", Material.GLOWSTONE_DUST, PotionType.WATER, PotionType.THICK));
        recipes.addAll(BrewingRecipe.getAllRecipes("swiftness", Material.SUGAR, PotionType.AWKWARD, PotionType.SWIFTNESS));
        recipes.addAll(BrewingRecipe.getAllRecipes("swiftness_strong", Material.GLOWSTONE, PotionType.SWIFTNESS, PotionType.STRONG_SWIFTNESS));
        recipes.addAll(BrewingRecipe.getAllRecipes("swiftness_long", Material.REDSTONE, PotionType.SWIFTNESS, PotionType.LONG_SWIFTNESS));
        recipes.addAll(BrewingRecipe.getAllRecipes("slowness", Material.FERMENTED_SPIDER_EYE, PotionType.SWIFTNESS, PotionType.SLOWNESS));
        recipes.addAll(BrewingRecipe.getAllRecipes("slowness_strong", Material.GLOWSTONE, PotionType.SLOWNESS, PotionType.STRONG_SLOWNESS));
        recipes.addAll(BrewingRecipe.getAllRecipes("slowness_long", Material.REDSTONE, PotionType.SLOWNESS, PotionType.LONG_SLOWNESS));
        recipes.addAll(BrewingRecipe.getAllRecipes("slowness_long_2", Material.FERMENTED_SPIDER_EYE, PotionType.LONG_SWIFTNESS, PotionType.LONG_SLOWNESS));
        recipes.addAll(BrewingRecipe.getAllRecipes("slowness_long_3", Material.FERMENTED_SPIDER_EYE, PotionType.LONG_LEAPING, PotionType.LONG_SLOWNESS));
        recipes.addAll(BrewingRecipe.getAllRecipes("jump_boost", Material.RABBIT_FOOT, PotionType.AWKWARD, PotionType.LEAPING));
        recipes.addAll(BrewingRecipe.getAllRecipes("jump_boost_strong", Material.GLOWSTONE, PotionType.LEAPING, PotionType.STRONG_LEAPING));
        recipes.addAll(BrewingRecipe.getAllRecipes("jump_boost_long", Material.REDSTONE, PotionType.LEAPING, PotionType.LONG_LEAPING));
        recipes.addAll(BrewingRecipe.getAllRecipes("strength", Material.BLAZE_POWDER, PotionType.AWKWARD, PotionType.STRENGTH));
        recipes.addAll(BrewingRecipe.getAllRecipes("strength_strong", Material.GLOWSTONE, PotionType.STRENGTH, PotionType.STRONG_STRENGTH));
        recipes.addAll(BrewingRecipe.getAllRecipes("strength_long", Material.REDSTONE, PotionType.STRENGTH, PotionType.LONG_STRENGTH));
        recipes.addAll(BrewingRecipe.getAllRecipes("healing", Material.GLISTERING_MELON_SLICE, PotionType.AWKWARD, PotionType.HEALING));
        recipes.addAll(BrewingRecipe.getAllRecipes("healing_strong", Material.GLOWSTONE, PotionType.HEALING, PotionType.STRONG_HEALING));
        recipes.addAll(BrewingRecipe.getAllRecipes("poison", Material.SPIDER_EYE, PotionType.AWKWARD, PotionType.POISON));
        recipes.addAll(BrewingRecipe.getAllRecipes("poison_strong", Material.GLOWSTONE, PotionType.POISON, PotionType.STRONG_POISON));
        recipes.addAll(BrewingRecipe.getAllRecipes("poison_long", Material.REDSTONE, PotionType.POISON, PotionType.LONG_POISON));
        recipes.addAll(BrewingRecipe.getAllRecipes("harming", Material.FERMENTED_SPIDER_EYE, PotionType.POISON, PotionType.HARMING));
        recipes.addAll(BrewingRecipe.getAllRecipes("harming_2", Material.FERMENTED_SPIDER_EYE, PotionType.HEALING, PotionType.HARMING));
        recipes.addAll(BrewingRecipe.getAllRecipes("harming_strong", Material.FERMENTED_SPIDER_EYE, PotionType.STRONG_POISON, PotionType.STRONG_HARMING));
        recipes.addAll(BrewingRecipe.getAllRecipes("harming_strong_2", Material.FERMENTED_SPIDER_EYE, PotionType.STRONG_HEALING, PotionType.STRONG_HARMING));
        recipes.addAll(BrewingRecipe.getAllRecipes("harming_strong_3", Material.GLOWSTONE, PotionType.HARMING, PotionType.STRONG_HARMING));
        recipes.addAll(BrewingRecipe.getAllRecipes("regeneration", Material.GHAST_TEAR, PotionType.AWKWARD, PotionType.REGENERATION));
        recipes.addAll(BrewingRecipe.getAllRecipes("regeneration_strong", Material.GLOWSTONE, PotionType.REGENERATION, PotionType.STRONG_REGENERATION));
        recipes.addAll(BrewingRecipe.getAllRecipes("regeneration_long", Material.REDSTONE, PotionType.AWKWARD, PotionType.LONG_REGENERATION));
        recipes.addAll(BrewingRecipe.getAllRecipes("fire_resistance", Material.MAGMA_CREAM, PotionType.AWKWARD, PotionType.FIRE_RESISTANCE));
        recipes.addAll(BrewingRecipe.getAllRecipes("fire_resistance_long", Material.GLOWSTONE, PotionType.FIRE_RESISTANCE, PotionType.LONG_FIRE_RESISTANCE));
        recipes.addAll(BrewingRecipe.getAllRecipes("water_breathing", Material.PUFFERFISH, PotionType.AWKWARD, PotionType.WATER_BREATHING));
        recipes.addAll(BrewingRecipe.getAllRecipes("water_breathing_long", Material.GLOWSTONE, PotionType.WATER_BREATHING, PotionType.LONG_WATER_BREATHING));
        recipes.addAll(BrewingRecipe.getAllRecipes("night_vision", Material.GOLDEN_CARROT, PotionType.AWKWARD, PotionType.NIGHT_VISION));
        recipes.addAll(BrewingRecipe.getAllRecipes("night_vision_long", Material.GLOWSTONE, PotionType.NIGHT_VISION, PotionType.LONG_NIGHT_VISION));
        recipes.addAll(BrewingRecipe.getAllRecipes("invisibility", Material.FERMENTED_SPIDER_EYE, PotionType.NIGHT_VISION, PotionType.INVISIBILITY));
        recipes.addAll(BrewingRecipe.getAllRecipes("invisibility_long", Material.FERMENTED_SPIDER_EYE, PotionType.LONG_NIGHT_VISION, PotionType.LONG_INVISIBILITY));
        recipes.addAll(BrewingRecipe.getAllRecipes("invisibility_long_2", Material.GLOWSTONE, PotionType.INVISIBILITY, PotionType.LONG_INVISIBILITY));
        recipes.addAll(BrewingRecipe.getAllRecipes("turtle_master", Material.TURTLE_HELMET, PotionType.AWKWARD, PotionType.TURTLE_MASTER));
        recipes.addAll(BrewingRecipe.getAllRecipes("turtle_master_strong", Material.GLOWSTONE, PotionType.TURTLE_MASTER, PotionType.STRONG_TURTLE_MASTER));
        recipes.addAll(BrewingRecipe.getAllRecipes("turtle_master_long", Material.REDSTONE, PotionType.TURTLE_MASTER, PotionType.LONG_TURTLE_MASTER));
        recipes.addAll(BrewingRecipe.getAllRecipes("slow_falling", Material.PHANTOM_MEMBRANE, PotionType.AWKWARD, PotionType.SLOW_FALLING));
        recipes.addAll(BrewingRecipe.getAllRecipes("slow_falling_long", Material.REDSTONE, PotionType.SLOW_FALLING, PotionType.LONG_SLOW_FALLING));
        recipes.addAll(BrewingRecipe.getAllRecipes("weakness", Material.FERMENTED_SPIDER_EYE, PotionType.WATER, PotionType.WEAKNESS));
        recipes.addAll(BrewingRecipe.getAllRecipes("weakness_long", Material.REDSTONE, PotionType.WEAKNESS, PotionType.LONG_WEAKNESS));
        recipes.forEach(recipe -> this.brewingRecipeMap.put(recipe.getKey(), (BrewingRecipe)recipe));
        Utils.log("Loaded a total of " + recipes.size() + " brewing recipes.", new String[0]);
    }

    @Contract(value="_ -> new")
    private @Unmodifiable List<BrewingRecipe> getMundane(Material ingredient) {
        return BrewingRecipe.getAllRecipes("mundane_" + ingredient.getKey().getKey().toLowerCase(), ingredient, PotionType.WATER, PotionType.MUNDANE);
    }

    public Optional<FurnaceFuel> getFurnaceFuel(Material material) {
        return this.furnaceFuelMap.values().stream().filter(fuel -> fuel.matches(material)).findAny();
    }

    public Optional<BrewingFuel> getBrewingFuel(Material material) {
        return this.brewingFuelMap.values().stream().filter(fuel -> fuel.matches(material)).findAny();
    }

    @NotNull
    public final Optional<BrewingRecipe> getRecipe(@NotNull ItemStack ingredient, ItemStack bottle) {
        ItemStack checkIng = ingredient.clone();
        checkIng.setAmount(1);
        return this.brewingRecipeMap.values().stream().filter(recipe -> {
            PotionMeta inputMeta = (PotionMeta)recipe.getInputBottle().getItemMeta();
            if (inputMeta == null) {
                return false;
            }
            PotionMeta passedMeta = (PotionMeta)bottle.getItemMeta();
            if (passedMeta == null) {
                return false;
            }
            return recipe.getIngredient().isSimilar(checkIng) && bottle.getType() == recipe.getInputBottle().getType() && inputMeta.getBasePotionType() == passedMeta.getBasePotionType();
        }).findAny();
    }

    @NotNull
    public final Optional<FurnaceRecipe> getRecipe(Material material, FurnaceType type) {
        return this.furnaceRecipeMap.values().stream().filter(recipe -> {
            if (recipe.getIngredients() != null) {
                return recipe.getIngredients().contains(material) && type == recipe.getType();
            }
            return recipe.getIngredient() == material && type == recipe.getType();
        }).findAny();
    }

    public Map<NamespacedKey, FurnaceFuel> getFurnaceFuelMap() {
        return this.furnaceFuelMap;
    }

    public Map<NamespacedKey, BrewingFuel> getBrewingFuelMap() {
        return this.brewingFuelMap;
    }

    public Multimap<NamespacedKey, FurnaceRecipe> getFurnaceRecipeMap() {
        return this.furnaceRecipeMap;
    }

    public Map<NamespacedKey, BrewingRecipe> getBrewingRecipeMap() {
        return this.brewingRecipeMap;
    }

    public static RecipeManager getInstance() {
        return instance;
    }
}

