/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.virtual;

import com.itsschatten.libs.Utils;
import com.itsschatten.portablecrafting.events.BrewingOpenEvent;
import com.itsschatten.portablecrafting.events.FurnaceOpenEvent;
import com.itsschatten.portablecrafting.virtual.ISettings;
import com.itsschatten.portablecrafting.virtual.RecipeManager;
import com.itsschatten.portablecrafting.virtual.ReturnReason;
import com.itsschatten.portablecrafting.virtual.Storage;
import com.itsschatten.portablecrafting.virtual.machine.BrewingStand;
import com.itsschatten.portablecrafting.virtual.machine.Furnace;
import com.itsschatten.portablecrafting.virtual.machine.properties.BlastingProperties;
import com.itsschatten.portablecrafting.virtual.machine.properties.BrewingProperties;
import com.itsschatten.portablecrafting.virtual.machine.properties.FurnaceProperties;
import com.itsschatten.portablecrafting.virtual.machine.properties.SmokerProperties;
import com.itsschatten.portablecrafting.virtual.utils.FurnaceType;
import com.itsschatten.portablecrafting.virtual.utils.InventoryClickListener;
import com.itsschatten.portablecrafting.virtual.utils.TickTask;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualManager {
    private final Storage storage;
    private ISettings settings;
    private final Map<UUID, Furnace> openFurnaces;
    private final Map<UUID, BrewingStand> openBrewingStands;
    private final Map<Inventory, Furnace> inventoryFurnaceMap;
    private final Map<Inventory, BrewingStand> inventoryBrewingStandMap;
    private static VirtualManager instance;
    private final boolean loaded;
    private final TickTask tickTask;

    public VirtualManager(Storage storage, ISettings settings) {
        instance = this;
        this.openFurnaces = new HashMap<UUID, Furnace>();
        this.openBrewingStands = new HashMap<UUID, BrewingStand>();
        this.inventoryBrewingStandMap = new HashMap<Inventory, BrewingStand>();
        this.inventoryFurnaceMap = new HashMap<Inventory, Furnace>();
        this.loaded = true;
        this.storage = storage;
        this.settings = settings;
        new RecipeManager(settings);
        this.tickTask = new TickTask();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new InventoryClickListener(), (Plugin)Utils.getInstance());
    }

    public final void shutdown() {
        this.tickTask.cancel();
        if (this.storage != null) {
            this.storage.shutdown();
        }
    }

    public final ReturnReason openBlasting(Player player, int number) {
        return this.openFurnace(FurnaceType.BLASTING, player, number);
    }

    public final ReturnReason openBlasting(Player player, UUID id) throws UnsupportedOperationException {
        return this.openFurnace(player, id);
    }

    public final ReturnReason openSmoker(Player player, int number) {
        return this.openFurnace(FurnaceType.SMOKER, player, number);
    }

    public final ReturnReason openSmoker(Player player, UUID id) throws UnsupportedOperationException {
        return this.openFurnace(player, id);
    }

    public final ReturnReason openFurnace(Player player, int number) {
        return this.openFurnace(FurnaceType.FURNACE, player, number);
    }

    public final ReturnReason openFurnace(Player player, UUID id) throws UnsupportedOperationException {
        Furnace furnace = this.getFurnace(player, id);
        if (furnace == null) {
            throw new UnsupportedOperationException("Cannot create a furnace with a predefined UUID, please call #openFurnace(type, player, integer).");
        }
        return this.openFurnace(player, furnace);
    }

    public final ReturnReason openFurnace(FurnaceType type, Player player, int number) {
        return this.openFurnace(player, this.getFurnace(type, player, number));
    }

    public final ReturnReason openFurnace(FurnaceType type, Player player, String title) {
        return this.openFurnace(player, this.getFurnace(type, player, title));
    }

    private ReturnReason openFurnace(Player player, Furnace furnace2) {
        if (furnace2 == null) {
            return ReturnReason.REACHED_MAXIMUM;
        }
        FurnaceOpenEvent event = new FurnaceOpenEvent(player, furnace2);
        if (event.isCanceled()) {
            return ReturnReason.EVENT_CANCELED;
        }
        furnace2.openInventory(player);
        this.inventoryFurnaceMap.put(furnace2.getInventory(), furnace2);
        this.openFurnaces.put(furnace2.getUniqueId(), furnace2);
        return ReturnReason.OPENED;
    }

    @Contract(value="_, _, _ -> new")
    @Nullable
    public final Furnace getFurnace(FurnaceType type, Player player, int number) {
        UUID uuid = this.storage.getFurnaceUUIDFromID(player, (Integer)number, type);
        if (uuid != null) {
            return this.storage.loadFurnace(player, uuid);
        }
        if (!player.hasPermission("pci.furnace.limit.bypass") && this.storage.getPlayerFurnaceCount(player, type) >= this.settings.maximumFurnaces()) {
            return null;
        }
        return new Furnace(type.getName(), type, type.getProperties());
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public final Furnace getFurnace(FurnaceType type, Player player, String title) {
        return new Furnace(title, type, type.getProperties());
    }

    @Contract(pure=true)
    @Nullable
    public final Furnace getFurnace(@NotNull Player player, UUID id) {
        return this.getFurnace(player.getUniqueId(), id);
    }

    @Contract(pure=true)
    @Nullable
    public final Furnace getFurnace(UUID uuid, UUID id) {
        if (this.openFurnaces.containsKey(id)) {
            return this.openFurnaces.get(id);
        }
        return this.storage.loadFurnace(uuid, id);
    }

    public final ReturnReason openBrewingStand(Player player) {
        return this.openBrewingStand(player, 0);
    }

    public final ReturnReason openBrewingStand(Player player, int number) {
        BrewingStand stand = this.getBrewingStand(player, number);
        if (stand == null) {
            return ReturnReason.REACHED_MAXIMUM;
        }
        return this.openStand(player, stand);
    }

    public final ReturnReason openBrewingStand(Player player, UUID id) throws UnsupportedOperationException {
        BrewingStand stand = this.getBrewingStand(player, id);
        if (stand == null) {
            throw new UnsupportedOperationException("Cannot create a brewing stand with a predefined UUID, please call #openBrewingStand(player, integer).");
        }
        return this.openStand(player, stand);
    }

    private ReturnReason openStand(Player player, BrewingStand stand) {
        BrewingOpenEvent event = new BrewingOpenEvent(player, stand);
        if (event.isCanceled()) {
            return ReturnReason.EVENT_CANCELED;
        }
        stand.openInventory(player);
        this.openBrewingStands.put(stand.getUniqueId(), stand);
        this.inventoryBrewingStandMap.put(stand.getInventory(), stand);
        return ReturnReason.OPENED;
    }

    @Contract(pure=true)
    @Nullable
    public final BrewingStand getBrewingStand(Player player, int number) {
        UUID uuid = this.storage.getBrewingStandUUIDFromID(player, (Integer)number);
        if (uuid != null) {
            return this.storage.loadBrewingStand(player, uuid);
        }
        if (!player.hasPermission("pci.brewing.limit.bypass") && this.storage.getPlayerBrewingStandCount(player) >= this.settings.maximumBrewingStands()) {
            return null;
        }
        return new BrewingStand("Brewing Stand", BrewingProperties.NORMAL);
    }

    @Contract(pure=true)
    @Nullable
    public final BrewingStand getBrewingStand(Player player, UUID id) {
        return this.getBrewingStand(player.getUniqueId(), id);
    }

    @Contract(pure=true)
    @Nullable
    public final BrewingStand getBrewingStand(UUID uuid, UUID id) {
        if (this.openBrewingStands.containsKey(id)) {
            return this.openBrewingStands.get(id);
        }
        return this.storage.loadBrewingStand(uuid, id);
    }

    public final void closeAllVirtualTiles() {
        this.getOpenFurnaces().forEach((uuid, furnace) -> furnace.forceCloseInventory());
        this.getOpenBrewingStands().forEach((uuid, stand) -> stand.forceCloseInventory());
        Utils.debugLog("All virtual tiles should have been closed.", new String[0]);
    }

    public final int totalTickingVirtualTiles() {
        return this.openFurnaces.size() + this.openBrewingStands.size();
    }

    public final int allUniquePlayers() {
        return this.storage.getUniquePlayers();
    }

    public Storage getStorage() {
        return this.storage;
    }

    public ISettings getSettings() {
        return this.settings;
    }

    public Map<UUID, Furnace> getOpenFurnaces() {
        return this.openFurnaces;
    }

    public Map<UUID, BrewingStand> getOpenBrewingStands() {
        return this.openBrewingStands;
    }

    public Map<Inventory, Furnace> getInventoryFurnaceMap() {
        return this.inventoryFurnaceMap;
    }

    public Map<Inventory, BrewingStand> getInventoryBrewingStandMap() {
        return this.inventoryBrewingStandMap;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public TickTask getTickTask() {
        return this.tickTask;
    }

    public void setSettings(ISettings settings) {
        this.settings = settings;
    }

    public static VirtualManager getInstance() {
        return instance;
    }

    static {
        ConfigurationSerialization.registerClass(Furnace.class, (String)"furnace");
        ConfigurationSerialization.registerClass(FurnaceProperties.class, (String)"furnace_properties");
        ConfigurationSerialization.registerClass(SmokerProperties.class, (String)"smoker_properties");
        ConfigurationSerialization.registerClass(BlastingProperties.class, (String)"blasting_properties");
        ConfigurationSerialization.registerClass(BrewingStand.class, (String)"brewing_stand");
        ConfigurationSerialization.registerClass(BrewingProperties.class, (String)"brewing_stand_properties");
    }
}

