/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.virtual.fuel;

import com.itsschatten.libs.Utils;
import com.itsschatten.portablecrafting.virtual.fuel.Fuel;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BrewingFuel
extends Fuel {
    public static final BrewingFuel BLAZE_POWDER = BrewingFuel.get("blaze_powder", Material.BLAZE_POWDER, 20);
    private final int duration;

    public BrewingFuel(String name, Material item, int duration) {
        super(Utils.getKey("brewing_fuel_" + name), new ItemStack(item, 1), null);
        this.duration = duration;
    }

    public BrewingFuel(String name, ItemStack item, int duration) {
        super(Utils.getKey("brewing_fuel_" + name), item, null);
        this.duration = duration;
    }

    @NotNull
    public static BrewingFuel get(String name, Material material, int duration) {
        return new BrewingFuel(name, material, duration);
    }

    @NotNull
    public static BrewingFuel get(String name, ItemStack item, int duration) {
        return new BrewingFuel(name, item, duration);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BrewingFuel that = (BrewingFuel)o;
        return this.getDuration() == that.getDuration();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getDuration());
    }

    @Override
    public String toString() {
        return "BrewingFuel{duration=" + this.duration + "} " + super.toString();
    }

    public int getDuration() {
        return this.duration;
    }
}

