/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.virtual.fuel;

import java.util.Objects;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.inventory.ItemStack;

public abstract class Fuel
implements Keyed {
    final NamespacedKey key;
    final ItemStack fuelItem;
    final Tag<Material> tag;

    public Fuel(NamespacedKey key, ItemStack fuelItem, Tag<Material> tag) {
        this.key = key;
        if (fuelItem != null && fuelItem.getAmount() > 1) {
            fuelItem.setAmount(1);
        }
        this.fuelItem = fuelItem;
        this.tag = tag;
    }

    public final boolean matches(ItemStack item) {
        if (item == null) {
            return false;
        }
        ItemStack clone = item.clone();
        clone.setAmount(1);
        if (this.fuelItem != null && this.fuelItem.equals((Object)clone)) {
            return true;
        }
        return this.tag != null && this.tag.isTagged((Keyed)item.getType());
    }

    public final boolean matches(Material material) {
        if (material == null) {
            return false;
        }
        if (this.fuelItem != null && this.fuelItem.getType() == material) {
            return true;
        }
        return this.tag != null && this.tag.isTagged((Keyed)material);
    }

    public String toString() {
        return "Fuel{key=" + String.valueOf(this.key) + ", fuelItem=" + String.valueOf(this.fuelItem) + ", tag=" + String.valueOf(this.tag) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Fuel fuel = (Fuel)o;
        return Objects.equals(this.getKey(), fuel.getKey()) && Objects.equals(this.getFuelItem(), fuel.getFuelItem()) && Objects.equals(this.getTag(), fuel.getTag());
    }

    public int hashCode() {
        return Objects.hash(this.getKey(), this.getFuelItem(), this.getTag());
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public ItemStack getFuelItem() {
        return this.fuelItem;
    }

    public Tag<Material> getTag() {
        return this.tag;
    }
}

