/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.virtual.fuel;

import com.itsschatten.libs.Utils;
import com.itsschatten.portablecrafting.virtual.fuel.Fuel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FurnaceFuel
extends Fuel {
    public static final List<FurnaceFuel> VANILLA_FUELS = new ArrayList<FurnaceFuel>();
    public static final FurnaceFuel ANY_BANNER = FurnaceFuel.get("any_banner", (Tag<Material>)Tag.BANNERS, 300);
    public static final FurnaceFuel ANY_BOAT = FurnaceFuel.get("any_boat", (Tag<Material>)Tag.ITEMS_BOATS, 1200);
    public static final FurnaceFuel ANY_CARPET = FurnaceFuel.get("any_carpet", (Tag<Material>)Tag.WOOL_CARPETS, 67);
    public static final FurnaceFuel ANY_LOG = FurnaceFuel.get("any_log", (Tag<Material>)Tag.LOGS, 300);
    public static final FurnaceFuel ANY_PLANK = FurnaceFuel.get("any_plank", (Tag<Material>)Tag.PLANKS, 300);
    public static final FurnaceFuel ANY_SAPLING = FurnaceFuel.get("any_sapling", (Tag<Material>)Tag.SAPLINGS, 100);
    public static final FurnaceFuel ANY_SIGN = FurnaceFuel.get("any_sign", (Tag<Material>)Tag.ALL_SIGNS, 200);
    public static final FurnaceFuel ANY_WOODEN_BUTTON = FurnaceFuel.get("any_wooden_button", (Tag<Material>)Tag.WOODEN_BUTTONS, 100);
    public static final FurnaceFuel ANY_WOODEN_DOOR = FurnaceFuel.get("any_wooden_door", (Tag<Material>)Tag.WOODEN_DOORS, 200);
    public static final FurnaceFuel ANY_WOODEN_SLAB = FurnaceFuel.get("any_wooden_slab", (Tag<Material>)Tag.WOODEN_SLABS, 150);
    public static final FurnaceFuel ANY_WOOD_FENCE = FurnaceFuel.get("any_wood_fence", (Tag<Material>)Tag.WOODEN_FENCES, 300);
    public static final FurnaceFuel ANY_WOOD_FENCE_GATE = FurnaceFuel.get("any_wood_fence_gate", (Tag<Material>)Tag.FENCE_GATES, 300);
    public static final FurnaceFuel ANY_WOOD_PRESSURE_PLATE = FurnaceFuel.get("any_wood_pressure_plate", (Tag<Material>)Tag.WOODEN_PRESSURE_PLATES, 300);
    public static final FurnaceFuel ANY_WOOD_STAIR = FurnaceFuel.get("any_wood_stair", (Tag<Material>)Tag.WOODEN_STAIRS, 300);
    public static final FurnaceFuel ANY_WOOD_TRAPDOOR = FurnaceFuel.get("any_wood_trapdoor", (Tag<Material>)Tag.WOODEN_TRAPDOORS, 300);
    public static final FurnaceFuel ANY_WOOL = FurnaceFuel.get("any_wool", (Tag<Material>)Tag.WOOL, 100);
    public static final FurnaceFuel BAMBOO = FurnaceFuel.get("bamboo", Material.BAMBOO, 50);
    public static final FurnaceFuel BAMBOO_BLOCKS = FurnaceFuel.get("bamboo_blocks", (Tag<Material>)Tag.BAMBOO_BLOCKS, 300);
    public static final FurnaceFuel BAMBOO_MOSAIC = FurnaceFuel.get("bamboo_mosaic", Material.BAMBOO_MOSAIC, 300);
    public static final FurnaceFuel BAMBOO_MOSAIC_SLAB = FurnaceFuel.get("bamboo_mosaic_slab", Material.BAMBOO_MOSAIC_SLAB, 150);
    public static final FurnaceFuel BAMBOO_MOSAIC_STAIRS = FurnaceFuel.get("bamboo_mosaic_stairs", Material.BAMBOO_MOSAIC_STAIRS, 300);
    public static final FurnaceFuel BARREL = FurnaceFuel.get("barrel", Material.BARREL, 300);
    public static final FurnaceFuel BLAZE_ROD = FurnaceFuel.get("blaze_rod", Material.BLAZE_ROD, 2400);
    public static final FurnaceFuel BLOCK_OF_COAL = FurnaceFuel.get("block_of_coal", Material.COAL_BLOCK, 16000);
    public static final FurnaceFuel BOOKSHELF = FurnaceFuel.get("bookshelf", Material.BOOKSHELF, 300);
    public static final FurnaceFuel BOW = FurnaceFuel.get("bow", Material.BOW, 300);
    public static final FurnaceFuel BOWL = FurnaceFuel.get("bowl", Material.BOWL, 100);
    public static final FurnaceFuel CARTOGRAPHY_TABLE = FurnaceFuel.get("cartography_table", Material.CARTOGRAPHY_TABLE, 300);
    public static final FurnaceFuel CHARCOAL = FurnaceFuel.get("charcoal", Material.CHARCOAL, 1600);
    public static final FurnaceFuel CHEST = FurnaceFuel.get("chest", Material.CHEST, 300);
    public static final FurnaceFuel CHISELED_BOOKSHELF = FurnaceFuel.get("chiseled_bookshelf", Material.CHISELED_BOOKSHELF, 300);
    public static final FurnaceFuel COAL = FurnaceFuel.get("coal", Material.COAL, 1600);
    public static final FurnaceFuel COMPOSTER = FurnaceFuel.get("composter", Material.COMPOSTER, 300);
    public static final FurnaceFuel CRAFTING_TABLE = FurnaceFuel.get("crafting_table", Material.CRAFTING_TABLE, 300);
    public static final FurnaceFuel CROSSBOW = FurnaceFuel.get("cross_bow", Material.CROSSBOW, 300);
    public static final FurnaceFuel DAYLIGHT_DETECTOR = FurnaceFuel.get("daylight_detector", Material.DAYLIGHT_DETECTOR, 300);
    public static final FurnaceFuel DEAD_BUSH = FurnaceFuel.get("dead_bush", Material.DEAD_BUSH, 100);
    public static final FurnaceFuel DRIED_KELP_BLOCK = FurnaceFuel.get("dried_kelp_block", Material.DRIED_KELP_BLOCK, 4000);
    public static final FurnaceFuel FISHING_ROD = FurnaceFuel.get("fishing_rod", Material.FISHING_ROD, 300);
    public static final FurnaceFuel FLETCHING_TABLE = FurnaceFuel.get("fletching_table", Material.FLETCHING_TABLE, 300);
    public static final FurnaceFuel JUKEBOX = FurnaceFuel.get("jukebox", Material.JUKEBOX, 300);
    public static final FurnaceFuel LADDER = FurnaceFuel.get("ladder", Material.LADDER, 300);
    public static final FurnaceFuel LAVA_BUCKET = FurnaceFuel.get("lava_bucket", Material.LAVA_BUCKET, 20000);
    public static final FurnaceFuel LECTERN = FurnaceFuel.get("lectern", Material.LECTERN, 300);
    public static final FurnaceFuel LOOM = FurnaceFuel.get("loom", Material.LOOM, 300);
    public static final FurnaceFuel MANGROVE_ROOTS = FurnaceFuel.get("mangrove_roots", Material.MANGROVE_ROOTS, 300);
    public static final FurnaceFuel NOTE_BLOCK = FurnaceFuel.get("note_block", Material.NOTE_BLOCK, 300);
    public static final FurnaceFuel SCAFFOLDING = FurnaceFuel.get("scaffolding", Material.SCAFFOLDING, 50);
    public static final FurnaceFuel SMITHING_TABLE = FurnaceFuel.get("smithing_table", Material.SMITHING_TABLE, 300);
    public static final FurnaceFuel STICK = FurnaceFuel.get("stick", Material.STICK, 100);
    public static final FurnaceFuel TRAPPED_CHEST = FurnaceFuel.get("trapped_chest", Material.TRAPPED_CHEST, 300);
    public static final FurnaceFuel WOODEN_AXE = FurnaceFuel.get("wooden_axe", Material.WOODEN_AXE, 200);
    public static final FurnaceFuel WOODEN_HOE = FurnaceFuel.get("wooden_hoe", Material.WOODEN_HOE, 200);
    public static final FurnaceFuel WOODEN_PICKAXE = FurnaceFuel.get("wooden_pickaxe", Material.WOODEN_PICKAXE, 200);
    public static final FurnaceFuel WOODEN_SHOVEL = FurnaceFuel.get("wooden_shovel", Material.WOODEN_SHOVEL, 200);
    public static final FurnaceFuel WOODEN_SWORD = FurnaceFuel.get("wooden_sword", Material.WOODEN_SWORD, 200);
    private final int burnTime;

    public FurnaceFuel(String name, Material material, int burnTime) {
        super(Utils.getKey("furnace_fuel_" + name), new ItemStack(material, 1), null);
        this.burnTime = burnTime;
    }

    public FurnaceFuel(String name, ItemStack fuelItem, int burnTime) {
        super(Utils.getKey("furnace_fuel_" + name), fuelItem, null);
        this.burnTime = burnTime;
    }

    public FurnaceFuel(String name, Tag<Material> tag, int burnTime) {
        super(Utils.getKey("furnace_fuel_" + name), null, tag);
        this.burnTime = burnTime;
    }

    @NotNull
    public static FurnaceFuel get(String name, Material fuelMaterial, int burnTime) {
        return new FurnaceFuel(name, fuelMaterial, burnTime);
    }

    @NotNull
    public static FurnaceFuel get(String name, ItemStack fuelItemStack, int burnTime) {
        return new FurnaceFuel(name, fuelItemStack, burnTime);
    }

    @NotNull
    public static FurnaceFuel get(String name, Tag<Material> fuelTag, int burnTime) {
        return new FurnaceFuel(name, fuelTag, burnTime);
    }

    @Nullable
    public final Material getFuel() {
        return this.getFuelItem() == null ? null : this.fuelItem.getType();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FurnaceFuel that = (FurnaceFuel)o;
        return this.getBurnTime() == that.getBurnTime();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getBurnTime());
    }

    @Override
    public String toString() {
        return "FurnaceFuel{burnTime=" + this.burnTime + "} " + super.toString();
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    static {
        VANILLA_FUELS.add(ANY_BANNER);
        VANILLA_FUELS.add(ANY_BOAT);
        VANILLA_FUELS.add(ANY_CARPET);
        VANILLA_FUELS.add(ANY_LOG);
        VANILLA_FUELS.add(ANY_PLANK);
        VANILLA_FUELS.add(ANY_SAPLING);
        VANILLA_FUELS.add(ANY_SIGN);
        VANILLA_FUELS.add(ANY_WOODEN_BUTTON);
        VANILLA_FUELS.add(ANY_WOODEN_DOOR);
        VANILLA_FUELS.add(ANY_WOODEN_SLAB);
        VANILLA_FUELS.add(ANY_WOOD_FENCE);
        VANILLA_FUELS.add(ANY_WOOD_FENCE_GATE);
        VANILLA_FUELS.add(ANY_WOOD_PRESSURE_PLATE);
        VANILLA_FUELS.add(ANY_WOOD_STAIR);
        VANILLA_FUELS.add(ANY_WOOD_TRAPDOOR);
        VANILLA_FUELS.add(ANY_WOOL);
        VANILLA_FUELS.add(BAMBOO);
        VANILLA_FUELS.add(BAMBOO_BLOCKS);
        VANILLA_FUELS.add(BAMBOO_MOSAIC);
        VANILLA_FUELS.add(BAMBOO_MOSAIC_SLAB);
        VANILLA_FUELS.add(BAMBOO_MOSAIC_STAIRS);
        VANILLA_FUELS.add(BARREL);
        VANILLA_FUELS.add(BLAZE_ROD);
        VANILLA_FUELS.add(BLOCK_OF_COAL);
        VANILLA_FUELS.add(BOOKSHELF);
        VANILLA_FUELS.add(BOW);
        VANILLA_FUELS.add(BOWL);
        VANILLA_FUELS.add(CARTOGRAPHY_TABLE);
        VANILLA_FUELS.add(CHARCOAL);
        VANILLA_FUELS.add(CHEST);
        VANILLA_FUELS.add(CHISELED_BOOKSHELF);
        VANILLA_FUELS.add(COAL);
        VANILLA_FUELS.add(COMPOSTER);
        VANILLA_FUELS.add(CRAFTING_TABLE);
        VANILLA_FUELS.add(CROSSBOW);
        VANILLA_FUELS.add(DAYLIGHT_DETECTOR);
        VANILLA_FUELS.add(DEAD_BUSH);
        VANILLA_FUELS.add(DRIED_KELP_BLOCK);
        VANILLA_FUELS.add(FISHING_ROD);
        VANILLA_FUELS.add(FLETCHING_TABLE);
        VANILLA_FUELS.add(JUKEBOX);
        VANILLA_FUELS.add(LADDER);
        VANILLA_FUELS.add(LAVA_BUCKET);
        VANILLA_FUELS.add(LECTERN);
        VANILLA_FUELS.add(LOOM);
        VANILLA_FUELS.add(MANGROVE_ROOTS);
        VANILLA_FUELS.add(NOTE_BLOCK);
        VANILLA_FUELS.add(SCAFFOLDING);
        VANILLA_FUELS.add(SMITHING_TABLE);
        VANILLA_FUELS.add(STICK);
        VANILLA_FUELS.add(TRAPPED_CHEST);
        VANILLA_FUELS.add(WOODEN_AXE);
        VANILLA_FUELS.add(WOODEN_HOE);
        VANILLA_FUELS.add(WOODEN_PICKAXE);
        VANILLA_FUELS.add(WOODEN_SHOVEL);
        VANILLA_FUELS.add(WOODEN_SWORD);
    }
}

