/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.virtual.machine;

import com.itsschatten.libs.Utils;
import com.itsschatten.portablecrafting.virtual.RecipeManager;
import com.itsschatten.portablecrafting.virtual.SQLSerializable;
import com.itsschatten.portablecrafting.virtual.VirtualManager;
import com.itsschatten.portablecrafting.virtual.fuel.BrewingFuel;
import com.itsschatten.portablecrafting.virtual.machine.Machine;
import com.itsschatten.portablecrafting.virtual.machine.properties.BrewingProperties;
import com.itsschatten.portablecrafting.virtual.recipe.BrewingRecipe;
import com.itsschatten.portablecrafting.virtual.utils.PropertyHolder;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrewingStand
extends Machine
implements PropertyHolder<BrewingProperties>,
ConfigurationSerializable,
SQLSerializable {
    private final Inventory inventory;
    private final ItemStack[] bottles;
    private final BrewingProperties properties;
    private ItemStack fuel = null;
    private ItemStack ingredient = null;
    private int fuelTime = 0;
    private int max = 0;
    private int brewTime = 0;
    private int speed = 1;
    private BrewingRecipe currentRecipe = null;

    public BrewingStand(@NotNull String name, BrewingProperties properties) {
        super(name, UUID.randomUUID(), null);
        this.inventory = Bukkit.createInventory(null, (InventoryType)InventoryType.BREWING, (String)name);
        this.bottles = new ItemStack[3];
        this.properties = properties;
        this.updateInventory();
    }

    public BrewingStand(@NotNull String name, @NotNull UUID uniqueId, ItemStack[] bottles, BrewingProperties properties, ItemStack fuel, ItemStack ingredient, int fuelTime, int max, int brewTime, int speed, @Nullable LocalDateTime date) {
        super(name, uniqueId, date);
        this.inventory = Bukkit.createInventory(null, (InventoryType)InventoryType.BREWING, (String)name);
        this.bottles = bottles;
        this.properties = properties;
        this.fuel = fuel;
        this.ingredient = ingredient;
        this.fuelTime = fuelTime;
        this.max = max;
        this.brewTime = brewTime;
        this.speed = speed;
    }

    @Override
    public void openInventory(@NotNull Player player) {
        this.preOpen();
        this.updateInventory();
        this.updateBrewSpeed();
        player.openInventory(this.inventory);
        this.updateInventoryView();
    }

    @Override
    public void forceCloseInventory() {
        this.inventory.getViewers().forEach(HumanEntity::closeInventory);
    }

    private void updateInventory() {
        this.inventory.setItem(0, this.bottles[0]);
        this.inventory.setItem(1, this.bottles[1]);
        this.inventory.setItem(2, this.bottles[2]);
        this.inventory.setItem(3, this.ingredient);
        this.inventory.setItem(4, this.fuel);
    }

    private void updateInventoryView() {
        ItemStack bottle1 = this.inventory.getItem(0);
        ItemStack bottle2 = this.inventory.getItem(1);
        ItemStack bottle3 = this.inventory.getItem(2);
        ItemStack ingredient = this.inventory.getItem(3);
        ItemStack fuel = this.inventory.getItem(4);
        if (!this.matchBottle(this.bottles[0], bottle1)) {
            this.bottles[0] = bottle1;
        }
        if (!this.matchBottle(this.bottles[1], bottle2)) {
            this.bottles[1] = bottle2;
        }
        if (!this.matchBottle(this.bottles[2], bottle3)) {
            this.bottles[2] = bottle3;
        }
        if (this.doesNotMatch(this.ingredient, ingredient)) {
            this.ingredient = ingredient;
        }
        if (this.doesNotMatch(this.fuel, fuel)) {
            this.fuel = fuel;
        }
        this.inventory.getViewers().forEach(viewer -> {
            try {
                InventoryView view = viewer.getOpenInventory();
                view.setProperty(InventoryView.Property.BREW_TIME, this.brewTime);
                view.setProperty(InventoryView.Property.FUEL_TIME, (int)Math.round((double)this.fuelTime / (double)(this.max / 20)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private boolean matchBottle(ItemStack first, ItemStack second) {
        PotionMeta firstMeta;
        ItemMeta itemMeta;
        block5: {
            block4: {
                if (first == null || second == null) {
                    return false;
                }
                itemMeta = first.getItemMeta();
                if (!(itemMeta instanceof PotionMeta)) break block4;
                firstMeta = (PotionMeta)itemMeta;
                itemMeta = second.getItemMeta();
                if (itemMeta instanceof PotionMeta) break block5;
            }
            return false;
        }
        PotionMeta secondMeta = (PotionMeta)itemMeta;
        return first.getType() == second.getType() && firstMeta.getBasePotionType() == secondMeta.getBasePotionType();
    }

    private boolean doesNotMatch(ItemStack first, ItemStack second) {
        if (first == null || second == null) {
            return true;
        }
        return !first.equals((Object)second);
    }

    private boolean canUseFuel() {
        if (this.fuel == null) {
            return false;
        }
        return RecipeManager.getInstance().getBrewingFuel(this.fuel.getType()).isPresent();
    }

    private boolean canBrew() {
        return this.assignRecipe() != null;
    }

    private void processBrew() {
        BrewingRecipe recipe = this.currentRecipe;
        for (int i = 0; i < 3; ++i) {
            if (!this.matchBottle(this.bottles[i], recipe.getInputBottle())) continue;
            this.bottles[i] = recipe.getResult();
        }
        if (this.fuelTime > 0) {
            --this.fuelTime;
        }
        if (this.ingredient.getAmount() > 1) {
            this.ingredient.setAmount(this.ingredient.getAmount() - 1);
        } else {
            this.ingredient = null;
        }
        this.brewTime = 0;
        this.currentRecipe = null;
        this.updateInventory();
        this.updateInventoryView();
        for (HumanEntity viewer : this.inventory.getViewers()) {
            Player player = (Player)viewer;
            player.playSound(player.getLocation(), Sound.BLOCK_BREWING_STAND_BREW, 1.0f, 1.0f);
        }
    }

    private void processFuel() {
        BrewingFuel brewingFuel = RecipeManager.getInstance().getBrewingFuel(this.fuel.getType()).orElse(null);
        if (brewingFuel == null) {
            return;
        }
        this.max = this.fuelTime = brewingFuel.getDuration();
        if (this.fuel.getAmount() > 1) {
            this.fuel.setAmount(this.fuel.getAmount() - 1);
        } else {
            this.fuel = null;
        }
        this.updateInventory();
        this.updateInventoryView();
    }

    @Nullable
    private BrewingRecipe assignRecipe() {
        if (this.ingredient == null || this.bottles.length == 0) {
            return null;
        }
        BrewingRecipe foundRecipe = null;
        for (int i = 0; i < 3; ++i) {
            Optional<BrewingRecipe> recipeOptional;
            if (this.bottles[i] == null || (foundRecipe = (BrewingRecipe)(recipeOptional = RecipeManager.getInstance().getRecipe(this.ingredient, this.bottles[i])).orElse(null)) == null || !foundRecipe.equals(this.currentRecipe)) continue;
            return this.currentRecipe;
        }
        if (foundRecipe == null) {
            return null;
        }
        this.currentRecipe = foundRecipe;
        return foundRecipe;
    }

    private void updateBrewSpeed() {
        BrewingRecipe recipe = this.currentRecipe;
        if (recipe != null) {
            this.speed = (int)((double)(400 / recipe.getBrewTime()) / this.properties.getBrewMultiplier());
        }
    }

    @Override
    public void tick() {
        try {
            if (this.currentRecipe == null && this.canBrew()) {
                this.brewTime = 400;
                this.updateBrewSpeed();
            }
            if (this.fuelTime > 0) {
                if (this.brewTime > 0) {
                    if (this.ingredient != null) {
                        this.brewTime -= this.speed;
                        if (this.brewTime <= 0) {
                            this.processBrew();
                        }
                    } else {
                        this.brewTime = 0;
                    }
                } else if (this.canBrew()) {
                    this.brewTime = this.currentRecipe.getBrewTime();
                    this.updateBrewSpeed();
                }
            } else if (this.canUseFuel()) {
                this.processFuel();
            }
            this.updateInventoryView();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("name", this.getName());
        result.put("uuid", this.getUniqueId().toString());
        result.put("brewTime", this.brewTime);
        result.put("fuelTime", this.fuelTime);
        result.put("maxBrews", this.max);
        result.put("fuel", this.fuel);
        result.put("ingredient", this.ingredient);
        result.put("bottle-1", this.bottles[0]);
        result.put("bottle-2", this.bottles[1]);
        result.put("bottle-3", this.bottles[2]);
        result.put("lastOpened", LocalDateTime.now().toString());
        return result;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static BrewingStand deserialize(@NotNull Map<String, Object> args) {
        String name = (String)args.get("name");
        UUID uuid = UUID.fromString((String)args.get("uuid"));
        int brewTime = ((Number)args.get("brewTime")).intValue();
        int fuelTime = ((Number)args.get("fuelTime")).intValue();
        int maxBrews = ((Number)args.get("maxBrews")).intValue();
        ItemStack fuel = (ItemStack)args.get("fuel");
        ItemStack ing = (ItemStack)args.get("ingredient");
        ItemStack[] bottles = new ItemStack[]{(ItemStack)args.get("bottle-1"), (ItemStack)args.get("bottle-2"), (ItemStack)args.get("bottle-3")};
        LocalDateTime date = LocalDateTime.parse((String)args.get("lastOpened"));
        return new BrewingStand(name, uuid, bottles, BrewingProperties.NORMAL, fuel, ing, fuelTime, maxBrews, brewTime, 1, date);
    }

    @Override
    public Map<String, Object> serializeForSQL() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bottle_1", Utils.serialize(this.bottles[0]));
        map.put("bottle_2", Utils.serialize(this.bottles[1]));
        map.put("bottle_3", Utils.serialize(this.bottles[2]));
        map.put("ingredient", Utils.serialize(this.ingredient));
        map.put("fuel_item", Utils.serialize(this.fuel));
        map.put("title", this.getName());
        map.put("brew_time", this.brewTime);
        map.put("fuel_time", this.fuelTime);
        map.put("max_brews", this.max);
        map.put("last_opened", LocalDateTime.now());
        return map;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static BrewingStand deserializeFromSQL(@NotNull Map<String, Object> sql) {
        String name = (String)sql.get("title");
        UUID uuid = UUID.fromString((String)sql.get("uuid"));
        int brewTime = ((Number)sql.get("brew_time")).intValue();
        int fuelTime = ((Number)sql.get("fuel_time")).intValue();
        int maxBrews = ((Number)sql.get("max_brews")).intValue();
        ItemStack fuel = Utils.deserialize((String)sql.get("fuel_item"));
        ItemStack ing = Utils.deserialize((String)sql.get("ingredient"));
        ItemStack[] bottles = new ItemStack[]{Utils.deserialize((String)sql.get("bottle_1")), Utils.deserialize((String)sql.get("bottle_2")), Utils.deserialize((String)sql.get("bottle_3"))};
        LocalDateTime date = ((Timestamp)sql.get("last_opened")).toLocalDateTime();
        return new BrewingStand(name, uuid, bottles, BrewingProperties.NORMAL, fuel, ing, fuelTime, maxBrews, brewTime, 1, date);
    }

    @Override
    public void preOpen() {
        if (this.getLastOpened() != null) {
            long secondsSinceLastOpen = ChronoUnit.SECONDS.between(this.getLastOpened(), LocalDateTime.now());
            long ticks = secondsSinceLastOpen * 20L;
            if (this.canBrew()) {
                int recipeCookTime = this.currentRecipe.getBrewTime();
                this.brewTime += Math.min((int)ticks, recipeCookTime);
                if (this.brewTime > recipeCookTime) {
                    Utils.debugLog("Processing brew operation for " + String.valueOf(this.getUniqueId()) + ".", new String[0]);
                    this.processBrew();
                }
            }
        }
    }

    public final void save(Player player) {
        VirtualManager.getInstance().getStorage().saveBrewingStand(player, this);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public ItemStack[] getBottles() {
        return this.bottles;
    }

    @Override
    public BrewingProperties getProperties() {
        return this.properties;
    }

    public ItemStack getFuel() {
        return this.fuel;
    }

    public ItemStack getIngredient() {
        return this.ingredient;
    }

    public int getFuelTime() {
        return this.fuelTime;
    }

    public int getMax() {
        return this.max;
    }

    public int getBrewTime() {
        return this.brewTime;
    }

    public int getSpeed() {
        return this.speed;
    }

    public BrewingRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }
}

