/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.virtual.machine;

import com.itsschatten.libs.Utils;
import com.itsschatten.portablecrafting.virtual.RecipeManager;
import com.itsschatten.portablecrafting.virtual.SQLSerializable;
import com.itsschatten.portablecrafting.virtual.VirtualManager;
import com.itsschatten.portablecrafting.virtual.fuel.FurnaceFuel;
import com.itsschatten.portablecrafting.virtual.machine.Machine;
import com.itsschatten.portablecrafting.virtual.machine.properties.FurnaceProperties;
import com.itsschatten.portablecrafting.virtual.recipe.FurnaceRecipe;
import com.itsschatten.portablecrafting.virtual.utils.FurnaceType;
import com.itsschatten.portablecrafting.virtual.utils.PropertyHolder;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.view.FurnaceView;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Furnace
extends Machine
implements PropertyHolder<FurnaceProperties>,
ConfigurationSerializable,
SQLSerializable {
    private final FurnaceProperties properties;
    private final Inventory inventory;
    private final FurnaceType type;
    private ItemStack fuel;
    private ItemStack input;
    private ItemStack output;
    private int cookTime;
    private int totalCookTime;
    private int fuelTime;
    private int totalFuelTime;
    private float experience;
    private FurnaceRecipe currentRecipe = null;

    public Furnace(String name) {
        this(name, FurnaceType.FURNACE, FurnaceProperties.FURNACE);
    }

    public Furnace(String name, @NotNull FurnaceType type, FurnaceProperties properties) {
        super(name, UUID.randomUUID(), null);
        this.type = type;
        this.properties = properties;
        this.inventory = Bukkit.createInventory(null, (InventoryType)InventoryType.FURNACE, (String)name);
    }

    public Furnace(@NotNull String name, @NotNull UUID uniqueId, FurnaceProperties properties, @NotNull FurnaceType type, ItemStack fuel, ItemStack input, ItemStack output, int cookTime, int fuelTime, int totalFuel, float experience, @Nullable LocalDateTime date) {
        super(name, uniqueId, date);
        this.properties = properties;
        this.type = type;
        this.inventory = Bukkit.createInventory(null, (InventoryType)InventoryType.FURNACE, (String)name);
        this.fuel = fuel;
        this.input = input;
        this.output = output;
        this.cookTime = cookTime;
        this.fuelTime = fuelTime;
        this.totalFuelTime = totalFuel;
        this.experience = experience;
    }

    @Override
    public void tick() {
        if (this.fuelTime > 0) {
            --this.fuelTime;
            if (this.canSmelt()) {
                ++this.cookTime;
                if (this.cookTime >= this.totalCookTime) {
                    this.cookTime = 1;
                    this.processSmelt();
                }
            } else {
                this.cookTime = 0;
            }
        } else if (this.canBurnFuel() && this.canSmelt()) {
            this.processFuelBurn();
        } else if (this.cookTime > 0) {
            this.cookTime = this.canSmelt() ? (this.cookTime -= 5) : 0;
        }
        this.updateInventoryView();
    }

    public ItemStack getOutput() {
        if (this.output == null) {
            return null;
        }
        ItemStack output = this.output.clone();
        this.output = null;
        return output;
    }

    @Override
    public void openInventory(@NotNull Player player) {
        this.preOpen();
        this.updateInventory();
        player.openInventory(this.inventory);
    }

    @Override
    public void forceCloseInventory() {
        this.inventory.getViewers().forEach(HumanEntity::closeInventory);
    }

    private boolean canBurnFuel() {
        if (this.fuel == null) {
            return false;
        }
        return RecipeManager.getInstance().getFurnaceFuel(this.fuel.getType()).orElse(null) != null;
    }

    private void processFuelBurn() {
        int burn;
        FurnaceFuel furnaceFuel = RecipeManager.getInstance().getFurnaceFuel(this.fuel.getType()).orElse(null);
        if (furnaceFuel == null) {
            return;
        }
        if (this.fuel.getAmount() > 1) {
            this.fuel.setAmount(this.fuel.getAmount() - 1);
        } else if (this.fuel.getType() == Material.LAVA_BUCKET) {
            this.fuel.setType(Material.BUCKET);
        } else {
            this.fuel = null;
        }
        this.fuelTime = burn = (int)((double)furnaceFuel.getBurnTime() / this.properties.getCookMultiplier());
        this.totalFuelTime = burn;
        this.updateInventory();
    }

    private boolean canSmelt() {
        if (this.assignRecipe() == null) {
            return false;
        }
        if (this.output == null) {
            return true;
        }
        Material outputType = this.output.getType();
        if (outputType == this.currentRecipe.getResult().getType()) {
            return this.output.getAmount() < outputType.getMaxStackSize();
        }
        return false;
    }

    @Nullable
    private FurnaceRecipe assignRecipe() {
        if (this.input == null) {
            if (this.currentRecipe != null) {
                this.currentRecipe = null;
                this.totalCookTime = 0;
            }
            return null;
        }
        FurnaceRecipe recipe = RecipeManager.getInstance().getRecipe(this.input.getType(), this.getType()).orElse(null);
        if (recipe == null) {
            if (this.currentRecipe != null) {
                this.currentRecipe = null;
                this.totalCookTime = 0;
            }
            return null;
        }
        if (recipe.equals(this.currentRecipe)) {
            return this.currentRecipe;
        }
        this.currentRecipe = recipe;
        this.totalCookTime = recipe.getCookTime();
        return recipe;
    }

    private void processSmelt() {
        if (this.currentRecipe == null) {
            return;
        }
        if (this.output == null) {
            this.output = this.currentRecipe.getResult();
        } else {
            this.output.setAmount(this.output.getAmount() + 1);
        }
        this.experience += this.currentRecipe.getExperience();
        if (this.input != null && this.input.getAmount() > 1) {
            this.input.setAmount(this.input.getAmount() - 1);
        } else {
            this.input = null;
        }
        this.updateInventory();
    }

    private void updateInventory() {
        this.inventory.setItem(0, this.input);
        this.inventory.setItem(1, this.fuel);
        this.inventory.setItem(2, this.output);
    }

    private void updateInventoryView() {
        ItemStack input = this.inventory.getItem(0);
        if (input != null && !input.equals((Object)this.input)) {
            this.input = input;
        } else if (input == null) {
            this.input = null;
        }
        ItemStack fuel = this.inventory.getItem(1);
        if (fuel != null && !fuel.equals((Object)this.fuel)) {
            this.fuel = fuel;
        } else if (fuel == null) {
            this.fuel = null;
        }
        ItemStack output = this.inventory.getItem(2);
        if (output != null && !output.equals((Object)this.output)) {
            this.output = output;
        } else if (output == null) {
            this.output = null;
        }
        this.inventory.getViewers().forEach(viewer -> {
            try {
                InventoryView view = viewer.getOpenInventory();
                if (view instanceof FurnaceView) {
                    FurnaceView furnace = (FurnaceView)view;
                    furnace.setProperty(InventoryView.Property.COOK_TIME, this.cookTime);
                    furnace.setProperty(InventoryView.Property.TICKS_FOR_CURRENT_SMELTING, this.totalCookTime);
                    furnace.setProperty(InventoryView.Property.BURN_TIME, this.fuelTime);
                    furnace.setProperty(InventoryView.Property.TICKS_FOR_CURRENT_FUEL, this.totalFuelTime);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public final float extractExperience() {
        float experience = this.experience;
        this.experience = 0.0f;
        return experience;
    }

    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("name", this.getName());
        result.put("uuid", this.getUniqueId().toString());
        result.put("cookTime", this.cookTime);
        result.put("fuelTime", this.fuelTime);
        result.put("maxFuel", this.totalFuelTime);
        result.put("xp", Float.valueOf(this.experience));
        result.put("fuel", this.fuel);
        result.put("input", this.input);
        result.put("output", this.output);
        result.put("type", this.type.name());
        result.put("lastOpened", this.getLastOpened().toString());
        return result;
    }

    @NotNull
    public static Furnace deserialize(@NotNull Map<String, Object> args) {
        String name = (String)args.get("name");
        UUID uuid = UUID.fromString((String)args.get("uuid"));
        int cookTime = ((Number)args.get("cookTime")).intValue();
        int fuelTime = ((Number)args.get("fuelTime")).intValue();
        int totalFuel = ((Number)args.get("maxFuel")).intValue();
        float xp = args.containsKey("xp") ? ((Number)args.get("xp")).floatValue() : 0.0f;
        ItemStack fuel = (ItemStack)args.get("fuel");
        ItemStack input = (ItemStack)args.get("input");
        ItemStack output = (ItemStack)args.get("output");
        FurnaceType furnaceType = FurnaceType.valueOf((String)args.get("type"));
        FurnaceProperties furnaceProperties = furnaceType.getProperties();
        LocalDateTime date = LocalDateTime.parse((String)args.get("lastOpened"));
        return new Furnace(name, uuid, furnaceProperties, furnaceType, fuel, input, output, cookTime, fuelTime, totalFuel, xp, date);
    }

    @Override
    public Map<String, Object> serializeForSQL() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", (Object)this.type);
        map.put("cook_time", this.cookTime);
        map.put("fuel_time", this.fuelTime);
        map.put("total_fuel", this.totalFuelTime);
        map.put("experience", Float.valueOf(this.experience));
        map.put("fuel_item", Utils.serialize(this.fuel));
        map.put("input_item", Utils.serialize(this.input));
        map.put("output_item", Utils.serialize(this.output));
        map.put("title", this.getName());
        map.put("last_opened", LocalDateTime.now());
        return map;
    }

    @Contract(pure=true)
    @NotNull
    public static Furnace deserializeFromSQL(@NotNull Map<String, Object> sql) {
        String name = (String)sql.get("title");
        UUID uuid = UUID.fromString((String)sql.get("uuid"));
        int cookTime = ((Number)sql.get("cook_time")).intValue();
        int fuelTime = ((Number)sql.get("fuel_time")).intValue();
        int totalFuel = ((Number)sql.get("total_fuel")).intValue();
        float xp = ((Number)sql.get("experience")).floatValue();
        ItemStack fuel = Utils.deserialize((String)sql.get("fuel_item"));
        ItemStack input = Utils.deserialize((String)sql.get("input_item"));
        ItemStack output = Utils.deserialize((String)sql.get("output_item"));
        FurnaceType furnaceType = FurnaceType.valueOf((String)sql.get("type"));
        FurnaceProperties furnaceProperties = furnaceType.getProperties();
        LocalDateTime date = ((Timestamp)sql.get("last_opened")).toLocalDateTime();
        return new Furnace(name, uuid, furnaceProperties, furnaceType, fuel, input, output, cookTime, fuelTime, totalFuel, xp, date);
    }

    @Override
    public void preOpen() {
        if (this.getLastOpened() != null) {
            long secondsSinceLastOpen = ChronoUnit.SECONDS.between(this.getLastOpened(), LocalDateTime.now());
            long ticksSinceLastOpened = secondsSinceLastOpen * 20L;
            this.setLastOpened(LocalDateTime.now());
            if (this.canSmelt()) {
                int recipeCookTime = this.currentRecipe.getCookTime();
                if (ticksSinceLastOpened < (long)recipeCookTime) {
                    if (this.fuelTime > 0) {
                        this.cookTime += (int)ticksSinceLastOpened;
                        this.fuelTime -= (int)ticksSinceLastOpened;
                    }
                } else {
                    if (this.fuelTime == 0 && (this.fuel == null || this.fuel.getType().isAir())) {
                        return;
                    }
                    if (this.output != null && this.output.getType() != this.currentRecipe.getResult().getType()) {
                        return;
                    }
                    FurnaceFuel furnaceFuel = this.fuel == null ? null : (FurnaceFuel)RecipeManager.getInstance().getFurnaceFuel(this.fuel.getType()).orElse(null);
                    int maxFurnaceFuelTime = furnaceFuel != null ? (int)((double)furnaceFuel.getBurnTime() / this.properties.getCookMultiplier()) : 0;
                    int maxItemsPerOneFuel = maxFurnaceFuelTime / recipeCookTime;
                    if (this.fuel == null || furnaceFuel == null || this.fuel.getType().isAir()) {
                        int operations = this.maximumOperations((this.fuelTime + this.cookTime) / recipeCookTime);
                        this.fuelTime -= recipeCookTime * operations;
                        Utils.debugLog("Running " + operations + " smelting operations for " + String.valueOf(this.getUniqueId()) + ".", new String[0]);
                        for (int i = 0; i < operations; ++i) {
                            this.processSmelt();
                        }
                        return;
                    }
                    int operations = Math.min((int)((ticksSinceLastOpened + (long)this.cookTime) / (long)recipeCookTime), this.maximumOperations(maxItemsPerOneFuel * this.fuel.getAmount()));
                    int fuelConsumed = operations * recipeCookTime;
                    int fuelConsumedUpdated = fuelConsumed - (this.fuelTime + this.cookTime);
                    this.fuelTime = fuelConsumed < this.fuelTime ? (this.fuelTime -= fuelConsumed) : 0;
                    int fuelItemsConsumed = fuelConsumedUpdated / (maxItemsPerOneFuel * recipeCookTime);
                    int remaining = fuelConsumedUpdated % (maxItemsPerOneFuel * recipeCookTime);
                    if (this.fuel != null) {
                        if (this.fuel.getAmount() > 1) {
                            this.fuel.setAmount(this.fuel.getAmount() - fuelItemsConsumed);
                        } else if (this.fuel.getType() == Material.LAVA_BUCKET) {
                            this.fuel.setType(Material.BUCKET);
                        } else {
                            this.fuel = null;
                        }
                    }
                    Utils.debugLog("Running " + operations + " smelting operations for " + String.valueOf(this.getUniqueId()) + ".", new String[0]);
                    for (int i = 0; i < operations; ++i) {
                        this.processSmelt();
                    }
                    if (remaining > 0) {
                        this.fuelTime = remaining;
                    }
                }
            } else if (this.fuelTime > 0) {
                this.fuelTime -= Math.toIntExact(Math.min(ticksSinceLastOpened, (long)this.totalFuelTime));
            }
        }
    }

    private int maximumOperations(int maxItems) {
        int operations;
        if (this.output != null && this.output.getAmount() > 0) {
            ItemMeta outputMeta = this.output.getItemMeta();
            assert (outputMeta != null);
            operations = outputMeta.hasMaxStackSize() ? outputMeta.getMaxStackSize() - this.output.getAmount() : this.output.getMaxStackSize() - this.output.getAmount();
        } else {
            ItemMeta inputMeta = this.input.getItemMeta();
            assert (inputMeta != null);
            int maxInputSize = inputMeta.hasMaxStackSize() ? inputMeta.getMaxStackSize() : this.input.getMaxStackSize();
            operations = Math.min(this.input.getAmount(), maxInputSize);
        }
        return Math.min(maxItems, operations);
    }

    public final void save(Player player) {
        VirtualManager.getInstance().getStorage().saveFurnace(player, this);
    }

    @Override
    public String toString() {
        return "Furnace{properties=" + String.valueOf(this.properties) + ", inventory=" + String.valueOf(this.inventory) + ", type=" + String.valueOf((Object)this.type) + ", fuel=" + String.valueOf(this.fuel) + ", input=" + String.valueOf(this.input) + ", output=" + String.valueOf(this.output) + ", cookTime=" + this.cookTime + ", totalCookTime=" + this.totalCookTime + ", fuelTime=" + this.fuelTime + ", totalFuelTime=" + this.totalFuelTime + ", experience=" + this.experience + "} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Furnace furnace = (Furnace)o;
        return this.getCookTime() == furnace.getCookTime() && this.getTotalCookTime() == furnace.getTotalCookTime() && this.getFuelTime() == furnace.getFuelTime() && this.getTotalFuelTime() == furnace.getTotalFuelTime() && Float.compare(this.getExperience(), furnace.getExperience()) == 0 && Objects.equals(this.getProperties(), furnace.getProperties()) && Objects.equals(this.getInventory(), furnace.getInventory()) && this.getType() == furnace.getType() && Objects.equals(this.getFuel(), furnace.getFuel()) && Objects.equals(this.getInput(), furnace.getInput()) && Objects.equals(this.getOutput(), furnace.getOutput());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getProperties(), this.getInventory(), this.getType(), this.getFuel(), this.getInput(), this.getOutput(), this.getCookTime(), this.getTotalCookTime(), this.getFuelTime(), this.getTotalFuelTime(), Float.valueOf(this.getExperience())});
    }

    @Override
    public FurnaceProperties getProperties() {
        return this.properties;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public FurnaceType getType() {
        return this.type;
    }

    public ItemStack getFuel() {
        return this.fuel;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public int getTotalCookTime() {
        return this.totalCookTime;
    }

    public int getFuelTime() {
        return this.fuelTime;
    }

    public int getTotalFuelTime() {
        return this.totalFuelTime;
    }

    public float getExperience() {
        return this.experience;
    }

    public FurnaceRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }
}

