/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.virtual.machine;

import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Machine {
    private final String name;
    private final UUID uniqueId;
    private LocalDateTime lastOpened;

    public Machine(@NotNull String name, @NotNull UUID uniqueId, @Nullable LocalDateTime lastOpened) {
        this.name = name;
        this.uniqueId = uniqueId;
        this.lastOpened = lastOpened == null ? LocalDateTime.now() : lastOpened;
    }

    public abstract void preOpen();

    public abstract void tick();

    public abstract void openInventory(Player var1);

    public abstract void forceCloseInventory();

    public String toString() {
        return "Machine{name='" + this.name + "', uniqueId=" + String.valueOf(this.uniqueId) + ", lastOpened=" + String.valueOf(this.lastOpened) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Machine machine = (Machine)o;
        return Objects.equals(this.getName(), machine.getName()) && Objects.equals(this.getUniqueId(), machine.getUniqueId());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getUniqueId());
    }

    public String getName() {
        return this.name;
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public LocalDateTime getLastOpened() {
        return this.lastOpened;
    }

    public void setLastOpened(LocalDateTime lastOpened) {
        this.lastOpened = lastOpened;
    }
}

