/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.virtual.machine.properties;

import com.itsschatten.libs.Utils;
import com.itsschatten.portablecrafting.virtual.machine.properties.Properties;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrewingProperties
extends Properties
implements ConfigurationSerializable {
    public static final BrewingProperties NORMAL = new BrewingProperties("brewing");
    private final double brewMultiplier;

    public BrewingProperties(String key) {
        super(Utils.getKey(key));
        this.brewMultiplier = 1.0;
    }

    public BrewingProperties(String key, double brewMultiplier) {
        super(Utils.getKey(key));
        this.brewMultiplier = brewMultiplier;
    }

    @Nullable
    private static BrewingProperties getProperty(String key) {
        for (NamespacedKey namespacedKey : KEY_MAP.keySet()) {
            if (!namespacedKey.getKey().equalsIgnoreCase(key)) continue;
            return (BrewingProperties)KEY_MAP.get(namespacedKey);
        }
        return null;
    }

    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> serialized = new LinkedHashMap<String, Object>();
        serialized.put("key", this.getKey().toString());
        serialized.put("brewMultiplier", this.getBrewMultiplier());
        return serialized;
    }

    public static BrewingProperties deserialize(@NotNull Map<String, Object> args) {
        String stringKey = ((String)args.get("key")).split(":")[1];
        double cook = (Double)args.get("brewMultiplier");
        BrewingProperties furnaceProperties = BrewingProperties.getProperty(stringKey);
        return Objects.requireNonNullElseGet(furnaceProperties, () -> new BrewingProperties(stringKey, cook));
    }

    public String toString() {
        return "BrewingProperties{brewMultiplier=" + this.brewMultiplier + "} " + super.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrewingProperties that = (BrewingProperties)o;
        return Double.compare(this.getBrewMultiplier(), that.getBrewMultiplier()) == 0;
    }

    public int hashCode() {
        return Objects.hashCode(this.getBrewMultiplier());
    }

    public double getBrewMultiplier() {
        return this.brewMultiplier;
    }
}

