/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.virtual.machine.properties;

import com.itsschatten.libs.Utils;
import com.itsschatten.portablecrafting.virtual.machine.properties.Properties;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FurnaceProperties
extends Properties
implements ConfigurationSerializable {
    public static final FurnaceProperties FURNACE = new FurnaceProperties("furnace");
    private final double cookMultiplier;

    public FurnaceProperties(String name, double cookMultiplier) {
        super(Utils.getKey(name));
        this.cookMultiplier = cookMultiplier;
    }

    public FurnaceProperties(String name) {
        this(name, 1.0);
    }

    @Nullable
    private static FurnaceProperties getProperty(String key) {
        for (NamespacedKey namespacedKey : KEY_MAP.keySet()) {
            if (!namespacedKey.getKey().equalsIgnoreCase(key)) continue;
            return (FurnaceProperties)KEY_MAP.get(namespacedKey);
        }
        return null;
    }

    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("key", this.key.toString());
        result.put("cookMultiplier", this.cookMultiplier);
        return result;
    }

    public static FurnaceProperties deserialize(@NotNull Map<String, Object> args) {
        String stringKey = ((String)args.get("key")).split(":")[1];
        double cook = (Double)args.get("cookMultiplier");
        FurnaceProperties furnaceProperties = FurnaceProperties.getProperty(stringKey);
        return Objects.requireNonNullElseGet(furnaceProperties, () -> new FurnaceProperties(stringKey, cook));
    }

    public String toString() {
        return "FurnaceProperties{cookMultiplier=" + this.cookMultiplier + "} " + super.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FurnaceProperties that = (FurnaceProperties)o;
        return Double.compare(this.cookMultiplier, that.cookMultiplier) == 0;
    }

    public int hashCode() {
        return Objects.hashCode(this.cookMultiplier);
    }

    public double getCookMultiplier() {
        return this.cookMultiplier;
    }
}

