/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.virtual.machine.properties;

import com.itsschatten.portablecrafting.virtual.machine.properties.FurnaceProperties;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmokerProperties
extends FurnaceProperties {
    public static final SmokerProperties SMOKER = new SmokerProperties("smoker");

    public SmokerProperties(String name) {
        super(name, 2.0);
    }

    private SmokerProperties(String name, double cookMultiplier) {
        super(name, cookMultiplier);
    }

    @Nullable
    private static SmokerProperties getProperty(String key) {
        for (NamespacedKey namespacedKey : KEY_MAP.keySet()) {
            if (!namespacedKey.getKey().equalsIgnoreCase(key)) continue;
            return (SmokerProperties)KEY_MAP.get(namespacedKey);
        }
        return null;
    }

    @Override
    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("key", this.key.toString());
        result.put("cookMultiplier", this.getCookMultiplier());
        return result;
    }

    public static SmokerProperties deserialize(@NotNull Map<String, Object> args) {
        String stringKey = ((String)args.get("key")).split(":")[1];
        double cook = (Double)args.get("cookMultiplier");
        SmokerProperties furnaceProperties = SmokerProperties.getProperty(stringKey);
        return Objects.requireNonNullElseGet(furnaceProperties, () -> new SmokerProperties(stringKey, cook));
    }
}

