/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.virtual.recipe;

import com.itsschatten.libs.Utils;
import com.itsschatten.portablecrafting.virtual.recipe.Recipe;
import java.util.List;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class BrewingRecipe
extends Recipe {
    private final ItemStack ingredient;
    private final ItemStack inputBottle;
    private final int brewTime;

    public BrewingRecipe(String name, @NotNull ItemStack result, ItemStack ingredient, ItemStack inputBottle, int brewTime) {
        super(Utils.getKey("brewing_recipe_" + name), result);
        this.ingredient = ingredient;
        this.inputBottle = inputBottle;
        this.brewTime = brewTime;
    }

    public BrewingRecipe(String name, ItemStack result, Material ingredient, ItemStack inputBottle) {
        this(name, result, new ItemStack(ingredient), inputBottle, 400);
    }

    public BrewingRecipe(String name, ItemStack result, ItemStack ingredient, ItemStack inputBottle) {
        this(name, result, ingredient, inputBottle, 400);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static BrewingRecipe get(String name, Material ingredient, PotionType input, PotionType output) {
        return new BrewingRecipe(name, BrewingRecipe.makeBottle(Material.POTION, output), ingredient, BrewingRecipe.makeBottle(Material.POTION, input));
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static BrewingRecipe getSplash(String name, PotionType input) {
        return new BrewingRecipe("splash_" + name, BrewingRecipe.makeBottle(Material.SPLASH_POTION, input), Material.GUNPOWDER, BrewingRecipe.makeBottle(Material.POTION, input));
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static BrewingRecipe getLingering(String name, PotionType input) {
        return new BrewingRecipe("lingering_" + name, BrewingRecipe.makeBottle(Material.LINGERING_POTION, input), Material.DRAGON_BREATH, BrewingRecipe.makeBottle(Material.SPLASH_POTION, input));
    }

    @Contract(value="_, _, _, _ -> new")
    public static @Unmodifiable List<BrewingRecipe> getAllRecipes(String name, Material ingredient, PotionType input, PotionType output) {
        return List.of(new BrewingRecipe[]{BrewingRecipe.get(name, ingredient, input, output), BrewingRecipe.getSplash(name, output), BrewingRecipe.getLingering(name, output)});
    }

    @NotNull
    private static ItemStack makeBottle(Material material, PotionType type) {
        ItemStack bottle = new ItemStack(material);
        PotionMeta bottleMeta = (PotionMeta)bottle.getItemMeta();
        assert (bottleMeta != null);
        bottleMeta.setBasePotionType(type);
        bottleMeta.clearCustomEffects();
        bottle.setItemMeta((ItemMeta)bottleMeta);
        return bottle;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrewingRecipe recipe = (BrewingRecipe)o;
        return this.getBrewTime() == recipe.getBrewTime() && Objects.equals(this.getIngredient(), recipe.getIngredient()) && Objects.equals(this.getInputBottle(), recipe.getInputBottle());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getIngredient(), this.getInputBottle(), this.getBrewTime());
    }

    @Override
    public String toString() {
        return "BrewingRecipe{ingredient=" + String.valueOf(this.ingredient) + ", inputBottle=" + String.valueOf(this.inputBottle) + ", brewTime=" + this.brewTime + "} " + super.toString();
    }

    public ItemStack getIngredient() {
        return this.ingredient;
    }

    public ItemStack getInputBottle() {
        return this.inputBottle;
    }

    public int getBrewTime() {
        return this.brewTime;
    }
}

