/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.virtual.recipe;

import com.itsschatten.libs.Utils;
import com.itsschatten.portablecrafting.virtual.recipe.Recipe;
import com.itsschatten.portablecrafting.virtual.utils.FurnaceType;
import java.util.List;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class FurnaceRecipe
extends Recipe {
    private final Material ingredient;
    private final List<Material> ingredients;
    private final int cookTime;
    private final float experience;
    private final FurnaceType type;

    public FurnaceRecipe(String name, @NotNull ItemStack result, Material ingredient, List<Material> ingredients, int cookTime, float experience, FurnaceType type) {
        super(Utils.getKey("furnace_recipe_" + name), result);
        this.ingredient = ingredient;
        this.ingredients = ingredients == null ? null : List.copyOf(ingredients);
        this.cookTime = cookTime;
        this.experience = experience;
        this.type = type;
    }

    public FurnaceRecipe(String name, @NotNull Material result, Material ingredient, int cookTime, float experience, FurnaceType type) {
        this(name, new ItemStack(result), ingredient, null, cookTime, experience, type);
    }

    public FurnaceRecipe(String name, @NotNull ItemStack result, Material ingredient, int cookTime, float experience, FurnaceType type) {
        this(name, result, ingredient, null, cookTime, experience, type);
    }

    public FurnaceRecipe(String name, @NotNull Material result, List<Material> ingredients, int cookTime, float experience, FurnaceType type) {
        this(name, new ItemStack(result), null, ingredients, cookTime, experience, type);
    }

    public FurnaceRecipe(String name, @NotNull ItemStack result, List<Material> ingredients, int cookTime, float experience, FurnaceType type) {
        this(name, result, null, ingredients, cookTime, experience, type);
    }

    @Override
    public String toString() {
        return "FurnaceRecipe{ingredient=" + String.valueOf(this.ingredient) + ", ingredientTag=" + String.valueOf(this.ingredients) + ", cookTime=" + this.cookTime + ", experience=" + this.experience + "} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FurnaceRecipe that = (FurnaceRecipe)o;
        return this.getCookTime() == that.getCookTime() && Float.compare(this.getExperience(), that.getExperience()) == 0 && this.getIngredient() == that.getIngredient() && Objects.equals(this.getIngredients(), that.getIngredients()) && this.type == that.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getIngredient(), this.getIngredients(), this.getCookTime(), Float.valueOf(this.getExperience()), this.type});
    }

    public Material getIngredient() {
        return this.ingredient;
    }

    public List<Material> getIngredients() {
        return this.ingredients;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public float getExperience() {
        return this.experience;
    }

    public FurnaceType getType() {
        return this.type;
    }
}

