/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.virtual.recipe;

import java.util.Objects;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class Recipe
implements Keyed {
    final NamespacedKey key;
    final ItemStack result;

    public Recipe(NamespacedKey key, @NotNull ItemStack result) {
        this.key = key;
        this.result = result;
    }

    public Recipe(NamespacedKey key, @NotNull Material result) {
        this.key = key;
        this.result = new ItemStack(result);
    }

    public ItemStack getResult() {
        return this.result.clone();
    }

    @NotNull
    public final Material getMaterialResult() {
        return this.result.getType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recipe recipe = (Recipe)o;
        return Objects.equals(this.getKey(), recipe.getKey()) && Objects.equals(this.getResult(), recipe.getResult());
    }

    public int hashCode() {
        return Objects.hash(this.getKey(), this.getResult());
    }

    public String toString() {
        return "Recipe{key=" + String.valueOf(this.key) + ", result=" + String.valueOf(this.result) + "}";
    }

    public NamespacedKey getKey() {
        return this.key;
    }
}

