/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.virtual.utils;

import com.itsschatten.libs.Utils;
import com.itsschatten.portablecrafting.virtual.RecipeManager;
import com.itsschatten.portablecrafting.virtual.VirtualManager;
import com.itsschatten.portablecrafting.virtual.fuel.FurnaceFuel;
import com.itsschatten.portablecrafting.virtual.machine.BrewingStand;
import com.itsschatten.portablecrafting.virtual.machine.Furnace;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class InventoryClickListener
implements Listener {
    public InventoryClickListener() {
        Utils.debugLog("Loaded the InventoryClickListener class from the virtual tile API.", new String[0]);
    }

    @EventHandler
    private void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Inventory inventory = event.getInventory();
        if (VirtualManager.getInstance().getInventoryFurnaceMap().containsKey(inventory)) {
            Furnace furnace = VirtualManager.getInstance().getInventoryFurnaceMap().get(inventory);
            VirtualManager.getInstance().getOpenFurnaces().remove(furnace.getUniqueId());
            VirtualManager.getInstance().getInventoryFurnaceMap().remove(inventory);
            furnace.save((Player)event.getPlayer());
        } else if (VirtualManager.getInstance().getInventoryBrewingStandMap().containsKey(inventory)) {
            BrewingStand stand = VirtualManager.getInstance().getInventoryBrewingStandMap().get(inventory);
            VirtualManager.getInstance().getOpenBrewingStands().remove(stand.getUniqueId());
            VirtualManager.getInstance().getInventoryBrewingStandMap().remove(inventory);
            stand.save((Player)event.getPlayer());
        }
    }

    @EventHandler
    private void onInventoryClick(@NotNull InventoryClickEvent event) {
        Inventory inventory = event.getInventory();
        InventoryView view = event.getView();
        HumanEntity clicker = event.getWhoClicked();
        int slot = event.getRawSlot();
        if (VirtualManager.getInstance().getInventoryFurnaceMap().containsKey(inventory) && clicker instanceof Player) {
            Furnace furnace = VirtualManager.getInstance().getInventoryFurnaceMap().get(inventory);
            if (slot == 2) {
                ItemStack output = furnace.getOutput();
                if (output != null) {
                    float exp = furnace.extractExperience();
                    ((Player)clicker).giveExp((int)exp);
                    event.setCurrentItem(output);
                }
            } else if (slot == 1) {
                ItemStack cursor = clicker.getItemOnCursor();
                FurnaceFuel fuel = RecipeManager.getInstance().getFurnaceFuel(cursor.getType()).orElse(null);
                if (fuel != null && this.isNotVanillaFuel(cursor)) {
                    ItemStack furnaceFuel = furnace.getFuel();
                    event.setCancelled(true);
                    if (furnaceFuel != null && furnaceFuel.getType() == cursor.getType()) {
                        int fuelAmount = furnaceFuel.getAmount();
                        int cursorAmount = cursor.getAmount();
                        int maxStack = cursor.getType().getMaxStackSize();
                        ItemStack fuelSlot = view.getItem(1);
                        assert (fuelSlot != null);
                        if (fuelAmount < maxStack) {
                            int diff = maxStack - fuelAmount;
                            if (cursorAmount < diff) {
                                cursor.setAmount(0);
                                fuelSlot.setAmount(fuelAmount + cursorAmount);
                            } else {
                                cursor.setAmount(cursorAmount - diff);
                                fuelSlot.setAmount(maxStack);
                            }
                        }
                    } else {
                        ItemStack oldCursor = cursor.clone();
                        clicker.setItemOnCursor(furnaceFuel);
                        event.getView().setItem(1, oldCursor);
                    }
                }
            }
        }
    }

    private boolean isNotVanillaFuel(ItemStack itemStack) {
        for (FurnaceFuel fuel : FurnaceFuel.VANILLA_FUELS) {
            if (fuel.getFuel() != itemStack.getType()) continue;
            return false;
        }
        return true;
    }
}

