/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.portablecrafting.virtual.utils;

import com.itsschatten.libs.Utils;
import com.itsschatten.portablecrafting.virtual.VirtualManager;
import com.itsschatten.portablecrafting.virtual.machine.BrewingStand;
import com.itsschatten.portablecrafting.virtual.machine.Furnace;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TickTask
extends BukkitRunnable {
    private final int id = this.runTaskTimerAsynchronously((Plugin)Utils.getInstance(), 15L, 1L).getTaskId();
    private boolean running = true;

    public TickTask() {
        Utils.debugLog("Set running the ticking task with ID: " + this.id, new String[0]);
    }

    public synchronized void cancel() throws IllegalStateException {
        if (this.running) {
            this.running = false;
        }
        Bukkit.getScheduler().cancelTask(this.id);
    }

    public void run() {
        if (VirtualManager.getInstance().getOpenFurnaces().isEmpty() && VirtualManager.getInstance().getOpenBrewingStands().isEmpty()) {
            return;
        }
        if (!this.running) {
            this.cancel();
            return;
        }
        try {
            for (Furnace furnace : VirtualManager.getInstance().getOpenFurnaces().values()) {
                furnace.tick();
            }
            for (BrewingStand stand : VirtualManager.getInstance().getOpenBrewingStands().values()) {
                stand.tick();
            }
        }
        catch (Exception ex) {
            Utils.logError(ex);
            Utils.logError("Failed to tick virtual tile entities!", new String[0]);
        }
    }
}

