package fun.wich;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import net.fabricmc.api.ModInitializer;

import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import java.util.Collection;

public class IgniteCommand implements ModInitializer {
	@Override public void onInitialize() { CommandRegistrationCallback.EVENT.register(IgniteCommand::register); }
	public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 access, class_2170.class_5364 environment) {
		dispatcher.register(class_2170.method_9247("ignite")
				.requires(source -> source.method_9259(2))
				.executes((context) -> ignite(context.getSource(), ImmutableList.of(context.getSource().method_9229()), 10))
				.then(class_2170.method_9244("targets", class_2186.method_9306())
						.executes((context) -> ignite(context.getSource(), class_2186.method_9317(context, "targets"), 10))
						.then((class_2170.method_9244("seconds", IntegerArgumentType.integer(1, 1000000))
								.executes(context -> ignite(context.getSource(), class_2186.method_9317(context, "targets"), IntegerArgumentType.getInteger(context, "seconds")))))));
		dispatcher.register(class_2170.method_9247("extinguish")
				.requires((source) -> source.method_9259(2))
				.executes((context) -> extinguish(context.getSource(), ImmutableList.of(context.getSource().method_9229())))
				.then(class_2170.method_9244("targets", class_2186.method_9306())
						.executes((context) -> extinguish(context.getSource(), class_2186.method_9317(context, "targets")))));
	}
	private static int ignite(class_2168 source, Collection<? extends class_1297> targets, int duration) {
		int count = 0;
		for (class_1297 entity : targets) {
			if (!entity.method_5753()) {
				entity.method_5639(duration);
				count++;
			}
		}
		if (targets.size() == 1 && count > 0) source.method_9226(class_2561.method_43469("commands.ignite.success.single", targets.iterator().next().method_5476()), true);
		else source.method_9226(class_2561.method_43469("commands.ignite.success.multiple", count), true);
		return targets.size();
	}
	private static int extinguish(class_2168 source, Collection<? extends class_1297> targets) {
		int count = 0;
		for (class_1297 entity : targets) {
			if (entity.method_5809()) {
				entity.method_5646();
				count++;
			}
		}
		if (targets.size() == 1 && count > 0) source.method_9226(class_2561.method_43469("commands.extinguish.success.single", targets.iterator().next().method_5476()), true);
		else source.method_9226(class_2561.method_43469("commands.extinguish.success.multiple", count), true);
		return targets.size();
	}
}