	# - CHECK AND STORE DIFFICULTY -

execute store result score @p current_difficulty run difficulty



	# - SPAWN UHV HORSES IN ZOMBIE VILLAGES -

# Whenever a zombie village generates an animal pen or a stables, it includes a marker entity. If UHV horses spawning in zombie villages is currently enabled, the marker entity will generate a value between 1 and 10.
execute unless score toggle spawn_uhv_horses matches 0 unless score toggle spawn_uhv_horses matches 2 as @e[type=marker,tag=zombie_village] store result score @s spawn_uhv_horses run random value 1..10

# If the value generated by the marker is a 3 or higher, a zombie (or husk/drowned depending on the biome) horse will be spawned at that location.
execute at @e[type=marker,tag=zombie_village,scores={spawn_uhv_horses=3..10}] run summon zombie_horse ~ ~ ~ {Tame:1,PersistenceRequired:1b,Motion:[0.1d,0d,0.1d],Tags:["from_zombie_village"]}

# If the value generated by the marker is a 7 or higher, a second zombie horse will be spawned as well.
execute at @e[type=marker,tag=zombie_village,scores={spawn_uhv_horses=7..10}] run summon zombie_horse ~ ~ ~ {Tame:1,PersistenceRequired:1b,Motion:[-0.1d,0d,-0.1d],Tags:["from_zombie_village"]}


# If UHV horses spawning in zombie villages is currently enabled and no UHV horses were spawned by the random value generated previously, then another value will be generated.
# This value will determine whether or not to spawn butcher animals.
execute as @e[type=marker,tag=zombie_village,scores={spawn_uhv_horses=1..3}] store result score @s spawn_butcher_animals run random value 1..10
# The same thing will happen if UHV horses spawning in zombie villages is currently disabled.
execute as @e[type=marker,tag=zombie_village] unless entity @s[scores={spawn_uhv_horses=1..10}] store result score @s spawn_butcher_animals run random value 1..10

# If the value generated is 2, 3, or 4, then two pigs will be spawned.
execute at @e[type=marker,tag=zombie_village,scores={spawn_butcher_animals=2..4}] run summon pig ~ ~ ~ {Motion:[0.1d,0d,0.1d]}
execute at @e[type=marker,tag=zombie_village,scores={spawn_butcher_animals=2..4}] run summon pig ~ ~ ~ {Motion:[-0.1d,0d,-0.1d]}

# If the value generated is 5, 6, or 7, then two cows will be spawned.
execute at @e[type=marker,tag=zombie_village,scores={spawn_butcher_animals=5..7}] run summon cow ~ ~ ~ {Motion:[0.1d,0d,0.1d]}
execute at @e[type=marker,tag=zombie_village,scores={spawn_butcher_animals=5..7}] run summon cow ~ ~ ~ {Motion:[-0.1d,0d,-0.1d]}

# If the value generated is 8, 9, or 10, then two sheep will be spawned.
execute at @e[type=marker,tag=zombie_village,scores={spawn_butcher_animals=8..10}] run summon sheep ~ ~ ~ {Motion:[0.1d,0d,0.1d]}
execute at @e[type=marker,tag=zombie_village,scores={spawn_butcher_animals=8..10}] run summon sheep ~ ~ ~ {Motion:[-0.1d,0d,-0.1d]}


# Once this process completes, the marker will be deleted.
kill @e[type=marker,tag=zombie_village]


# What all of this amounts to is fairly simple:
# Per each animal pen/stables generated in an abandoned village, there's a 20% chance for no UHV horses to spawn, a 40% chance for one horse to spawn, and a 40% chance for two horses to spawn.
# The horses spawned will be either zombie horses, husk horses, or drowned horses depending on the spawn location.
# If no UHV horses are spawned, then there's a 90% chance for two butcher animals to spawn instead. There's an equal chance of these animals being pigs, cows, or sheep.



	# - SPAWN DROWNED HORSES IN UNDERWATER RUINS -

# Whenever a large underwater ruins piece generates, it includes a marker entity. If drowned horses spawning in underwater ruins is currently enabled, the marker entity will generate a value between 1 and 10.
execute unless score toggle spawn_uhv_horses matches 0 unless score toggle spawn_uhv_horses matches 3 as @e[type=marker,tag=underwater_ruins] store result score @s spawn_uhv_horses run random value 1..10

# If the value generated by the marker is a 4 or higher AND the marker is in water, a drowned horse will be spawned at that location.
execute at @e[type=marker,tag=underwater_ruins,scores={spawn_uhv_horses=4..10}] if block ~ ~ ~ #uhv:always_waterlogged run summon zombie_horse ~ ~ ~ {Tame:1,PersistenceRequired:1b,Motion:[0.1d,0d,0.1d],Tags:["from_underwater_ruins"],Team:drowned_horse}

# If the value generated by the marker is exactly a 10, a second drowned horse will be spawned as well.
execute at @e[type=marker,tag=underwater_ruins,scores={spawn_uhv_horses=10}] if block ~ ~ ~ #uhv:always_waterlogged run summon zombie_horse ~ ~ ~ {Tame:1,PersistenceRequired:1b,Motion:[-0.1d,0d,-0.1d],Tags:["from_underwater_ruins"],Team:drowned_horse}

# Once this process completes (or if the process is currently disabled), the marker will be deleted.
execute unless score toggle spawn_uhv_horses matches 0 run kill @e[type=marker,tag=underwater_ruins,scores={spawn_uhv_horses=1..10}]
execute if score toggle spawn_uhv_horses matches 0 run kill @e[type=marker,tag=underwater_ruins]


# The TLDR here is much the same as for the abandoned village horse spawning, just with different values:
# Underwater ruins can either spawn as small ruins or as large ruins surrounded by smaller ruins. Each of these large ruins has a chance to spawn a drowned horse upon generating.
# There's a 30% chance for no UHV horses to spawn, a 60% chance for one horse to spawn, and a 10% chance for two horses to spawn. 
# If the spawn location isn't underwater, no horses will be spawned.



	# - MISC ZOMBIE CURING LOGIC -

execute as @a if items entity @s weapon.mainhand minecraft:golden_carrot run tag @s add hold_golden_carrot
execute as @a unless items entity @s weapon.mainhand minecraft:golden_carrot run tag @s remove hold_golden_carrot
execute as @e[type=zombie_horse,predicate=uhv:weakened] at @s if entity @p[tag=hold_golden_carrot,distance=..5] run effect give @s slowness 1 255 true



	# - MISC BOGGED LOGIC -

execute as @a if items entity @s weapon.mainhand minecraft:shears run tag @s add hold_shears
execute as @a unless items entity @s weapon.mainhand minecraft:shears run tag @s remove hold_shears
execute as @e[type=skeleton_horse,team=bogged_horse] at @s if entity @p[tag=hold_shears,distance=..5] run effect give @s slowness 1 255 true

execute as @a if items entity @s weapon.mainhand minecraft:bone_meal run tag @s add hold_bonemeal
execute as @a unless items entity @s weapon.mainhand minecraft:bone_meal run tag @s remove hold_bonemeal
execute as @e[type=skeleton_horse,team=shorn_bog_horse] at @s if entity @p[tag=hold_bonemeal,distance=..5] run effect give @s slowness 1 255 true



	# - MISC SKELETON -> WITHER SKELETON LOGIC -

execute as @a if items entity @s weapon.mainhand minecraft:wither_rose run tag @s add hold_wth_rose
execute as @a unless items entity @s weapon.mainhand minecraft:wither_rose run tag @s remove hold_wth_rose
execute as @e[type=skeleton_horse,team=skeleton_horse] at @s if entity @p[tag=hold_wth_rose,distance=..5] run effect give @s slowness 1 255 true



	# - WITHER SKELETON EFFECTS -

# Wither skeleton horses are given golden boots with a custom enchantment which provides the wearer with immunity to fire, withering, and also the projectiles shot by the Wither itself.

item replace entity @e[type=skeleton_horse,team=wither_horse] armor.feet with golden_boots[custom_name="UHV Booties - Wither Immunity",enchantments={binding_curse:1,vanishing_curse:1,wither_horse_immunity:1},attribute_modifiers=[{type:armor,amount:0,id:"uhvboots",operation:add_value}]]



	# - MISC DROWNED LOGIC -

# If a zombie, husk, or drowned horse tries to go underwater and is being riden by a non-player entity, their passenger will be kicked off.

execute as @e[type=zombie_horse] on passengers at @s if entity @s[type=!player] if block ~ ~1.5 ~ #uhv:always_waterlogged run ride @s dismount



	# - TRAP CONVERSION -

# If a trapped skeleton horse converts into a stray or bogged horse, their "SkeletonTrap" value will be set to 0 and the appropriate trap tag will be added.
# For stray horses, there's an additional command which will give them a saddle.

tag @e[type=skeleton_horse,team=stray_horse,tag=vanilla_trap] add stray_horse_trap
item replace entity @e[type=skeleton_horse,team=stray_horse,tag=vanilla_trap] saddle with saddle
execute as @e[type=skeleton_horse,team=stray_horse,tag=vanilla_trap] run data modify entity @s SkeletonTrap set value 0
tag @e[type=skeleton_horse,team=stray_horse,tag=vanilla_trap] remove vanilla_trap

tag @e[type=skeleton_horse,team=bogged_horse,tag=vanilla_trap] add bogged_horse_trap
execute as @e[type=skeleton_horse,team=bogged_horse,tag=vanilla_trap] run data modify entity @s SkeletonTrap set value 0
tag @e[type=skeleton_horse,team=bogged_horse,tag=vanilla_trap] remove vanilla_trap



	# - MISC SPONGE YOUR HORSE LOGIC -

# Zombie horses and drowned horses look at players if they are holding a sponge.

execute as @a if items entity @s weapon.mainhand minecraft:sponge run tag @s add hold_sponge
execute as @a unless items entity @s weapon.mainhand minecraft:sponge run tag @s remove hold_sponge
execute as @e[type=zombie_horse,team=!husk_horse] at @s if entity @p[tag=hold_sponge,distance=..5] run effect give @s slowness 1 255 true


# If a zombie horse or drowned horse enters water, their sponge_counter will be reset to zero.

execute as @e[type=zombie_horse,team=!husk_horse,scores={sponge_counter=1..}] at @s if block ~ ~ ~ #uhv:always_waterlogged run particle minecraft:dolphin ~ ~ ~ 0.5 0.5 0.5 0.1 50
execute as @e[type=zombie_horse,team=!husk_horse,scores={sponge_counter=1..}] at @s if block ~ ~ ~ #uhv:always_waterlogged run playsound minecraft:block.bubble_column.upwards_ambient neutral @a ~ ~ ~ 1 1
execute as @e[type=zombie_horse,team=!husk_horse,scores={sponge_counter=1..}] at @s if block ~ ~ ~ #uhv:always_waterlogged run scoreboard players reset @s sponge_counter



	# - INTERACTION ENTITIES -

# This has been hair-tuggingly annoying and finicky to get working...
# For some unknown reason, the exact same functions would behave differently depending on the specific variables used?
# Like, using a sponge on a zombie horse would work fine, but with any of the others, their respective interaction entities refused to summon properly despite their functions working fine when called manually.
# Or sometimes the interaction would show up fine for one of the bogged horses, but for another, identical bogged horse (except for the UUID) it wouldn't work?
# Sometimes they would work for a while and then just... stop? Or the interactions would flicker? I still don't know why any of these issues occurred.

# HOWEVER, I did get things to work! Somehow! Sooooo...uh.. problem solved, I guess!


# Put simply, the functions below keep track of two things:
# One, whether or not a player is currently holding an item which allows for them to interact with one of the undead horses, and-
# Two, whether or not an undead horse is able to be interacted with.
# Using this information, the "interaction_entities" function/advancement is able to summon interaction entities when needed.
# Afterwards, "clear_interactions" cleans up the mess it leaves behind, killing interaction entities once they're no longer necessary.
# When a player interacts with an interaction entity, the appropriate function/advancement combo is called.

scoreboard players set @a[predicate=uhv:target_bog] target_bog 1
scoreboard players set @a[predicate=uhv:target_shorn] target_shorn 1
scoreboard players set @a[predicate=uhv:target_held_rose] target_held_rose 1
scoreboard players set @a[predicate=uhv:target_held_sponge] target_held_sponge 1
scoreboard players set @a[predicate=uhv:target_held_carrot] target_held_carrot 1

scoreboard players reset @a[predicate=!uhv:target_bog] target_bog
scoreboard players reset @a[predicate=!uhv:target_shorn] target_shorn
scoreboard players reset @a[predicate=!uhv:target_held_rose] target_held_rose
scoreboard players reset @a[predicate=!uhv:target_held_sponge] target_held_sponge
scoreboard players reset @a[predicate=!uhv:target_held_carrot] target_held_carrot

execute as @e[type=#uhv:undead_horses,team=!wither_horse,team=!stray_horse] unless predicate uhv:has_rider run tag @s remove uhv_non_interactable

tag @e[type=skeleton_horse,team=wither_horse] add uhv_non_interactable
tag @e[type=skeleton_horse,team=stray_horse] add uhv_non_interactable
tag @e[type=#uhv:undead_horses,predicate=uhv:has_rider] add uhv_non_interactable



	# - APPLY EFFECTS/BEHAVIOR MODIFIERS TO MOUNTS -

# Since I removed zombie horses from the vanilla tag, "dismounts_underwater", drowned horses are now able to be ridden while submerged underwater.
# However, this means that a command had to be added which replicates the vanilla underwater dismount behavior but ONLY applies it to zombie horses and husk horses, NOT drowned horses.
# There's also another command which will apply this same behavior to the drowned horses if the score responsible for enabling it has been set to 2.

execute unless score toggle uhv_horses_swim matches 1 as @e[type=zombie_horse,team=!drowned_horse] on passengers at @s if block ~ ~1.5 ~ #uhv:always_waterlogged run ride @s dismount
execute if score toggle drowned_horses_swim matches 2 as @e[type=zombie_horse,team=drowned_horse] on passengers at @s if block ~ ~1.5 ~ #uhv:always_waterlogged run ride @s dismount


# Giving entities leather armor prevents them from taking freeze damage. As such, skeleton horses are given leather tunics while in powder snow.
# Their tunic will be removed if they're converted into a bogged horse or a wither skeleton horse. If bonus effects are disabled, stray horses will also be given a leather tunic.

item replace entity @e[type=skeleton_horse,team=skeleton_horse] armor.chest with leather_chestplate[custom_name="UHV Tunic - Skeleton Horse",enchantments={binding_curse:1,vanishing_curse:1},attribute_modifiers=[{type:armor,amount:0,id:"uhvtunic",operation:add_value}]]
execute as @e[type=skeleton_horse,team=!skeleton_horse] if items entity @s armor.chest leather_chestplate[custom_name="UHV Tunic - Skeleton Horse"] run item replace entity @s armor.chest with air

execute if score toggle uhv_bonuses matches 0 run item replace entity @e[type=skeleton_horse,team=stray_horse] armor.chest with leather_chestplate[custom_name="UHV Tunic",enchantments={binding_curse:1,vanishing_curse:1},attribute_modifiers=[{type:armor,amount:0,id:"uhvtunic",operation:add_value}]]


# If gameplay bonuses are enabled, the function responsible for those will also run.

execute if score toggle uhv_bonuses matches 1 run function uhv:effects

# If not, then any UHV Booties will be obliterated except for boardwalk boots.

execute if score toggle uhv_bonuses matches 0 as @a on vehicle if items entity @s[type=#uhv:undead_horses] armor.feet *[custom_name="UHV Booties"] run item replace entity @s armor.feet with air
execute if score toggle uhv_bonuses matches 0 as @e[type=#uhv:undead_horses,team=!drowned_horse] if items entity @s armor.feet *[custom_name="UHV Booties"] run item replace entity @s armor.feet with air
execute if score toggle uhv_bonuses matches 0 as @e[type=zombie_horse,team=drowned_horse] unless data entity @s Passengers if items entity @s armor.feet *[custom_name="UHV Booties"] run item replace entity @s armor.feet with air



	# - TRIGGER TRAPS -

execute at @e[type=#uhv:undead_horses,tag=uhv_trap] if entity @p[distance=..10] run summon lightning_bolt ~ ~-10 ~

execute as @e[type=skeleton_horse,tag=stray_horse_trap] at @s if entity @p[distance=..10] run function uhv:summon_trap/stray
execute as @e[type=skeleton_horse,tag=bogged_horse_trap] at @s if entity @p[distance=..10] run function uhv:summon_trap/bogged
execute as @e[type=skeleton_horse,tag=wither_horse_trap] at @s if entity @p[distance=..10] run function uhv:summon_trap/wither
execute as @e[type=zombie_horse,tag=zombie_horse_trap] at @s if entity @p[distance=..10] run function uhv:summon_trap/zombie
execute as @e[type=zombie_horse,tag=drowned_horse_trap] at @s if entity @p[distance=..10] run function uhv:summon_trap/drowned
execute as @e[type=zombie_horse,tag=husk_horse_trap] at @s if entity @p[distance=..10] run function uhv:summon_trap/husk



execute if score toggle uhv_enabled matches 1 run schedule function uhv:run_if_enabled_4t 4t