/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.texturepackforce;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import de.scholle.texturepackforce.TexturePackTabCompleter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class TexturePackForce
extends JavaPlugin
implements Listener {
    private HttpServer server;
    private int port;
    private File packFolder;
    private FileConfiguration config;

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.port = this.config.getInt("port", 8080);
        this.packFolder = this.getDataFolder();
        try {
            this.server = HttpServer.create(new InetSocketAddress(this.port), 0);
            File[] packs = this.packFolder.listFiles((dir, name) -> name.endsWith(".zip"));
            if (packs != null) {
                for (File file : packs) {
                    String path = "/" + file.getName();
                    this.server.createContext(path, new FileHandler(file));
                }
            }
            this.server.start();
            this.getLogger().info("Local ResourcePack server running on port " + this.port);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Objects.requireNonNull(this.getCommand("texturepack")).setExecutor(this::onCommand);
        Objects.requireNonNull(this.getCommand("texturepack")).setTabCompleter((TabCompleter)new TexturePackTabCompleter(this));
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("TexturePackForce enabled successfully.");
    }

    public void onDisable() {
        if (this.server != null) {
            this.server.stop(0);
        }
        this.getLogger().info("TexturePackForce disabled.");
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!this.config.getBoolean("force-on-join", false)) {
            return;
        }
        if (this.config.getBoolean("automatic-force-all-texturepacks", false)) {
            this.applyAllPacks(player);
        } else {
            this.applyEnabledPacks(player);
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length < 1 || args.length > 2) {
            sender.sendMessage("\u00a7cUse: /texturepack <packname> [player|@a]");
            return true;
        }
        String packName = args[0] + ".zip";
        File packFile = new File(this.packFolder, packName);
        if (!packFile.exists()) {
            sender.sendMessage("\u00a7cTexture pack not found: " + packName);
            return true;
        }
        boolean enabled = this.config.getBoolean("texturepacks." + packName, false);
        if (!enabled && !this.config.getBoolean("automatic-force-all-texturepacks", false)) {
            sender.sendMessage("\u00a7cThis texture pack is disabled in the config.yml.");
            return true;
        }
        ArrayList<Player> targets = new ArrayList<Player>();
        if (args.length == 2) {
            String targetArg = args[1];
            if (targetArg.equalsIgnoreCase("@a")) {
                targets.addAll(Bukkit.getOnlinePlayers());
            } else {
                Player target = Bukkit.getPlayer((String)targetArg);
                if (target == null) {
                    sender.sendMessage("\u00a7cPlayer not found: " + targetArg);
                    return true;
                }
                targets.add(target);
            }
        } else {
            if (!(sender instanceof Player)) {
                sender.sendMessage("\u00a7cYou must specify a player when using this command from console.");
                return true;
            }
            targets.add((Player)sender);
        }
        for (Player p : targets) {
            this.applyPack(p, packFile);
        }
        sender.sendMessage("\u00a7aApplied texture pack \u00a7f" + packFile.getName() + " \u00a7ato " + (String)(targets.size() == Bukkit.getOnlinePlayers().size() ? "\u00a7eall players" : "\u00a7e" + targets.size() + " player(s)"));
        return true;
    }

    public File getPackFolder() {
        return this.packFolder;
    }

    private void applyAllPacks(Player player) {
        File[] packs = this.packFolder.listFiles((dir, name) -> name.endsWith(".zip"));
        if (packs == null) {
            return;
        }
        for (File pack : packs) {
            this.applyPack(player, pack);
        }
    }

    private void applyEnabledPacks(Player player) {
        for (String name : this.config.getConfigurationSection("texturepacks").getKeys(false)) {
            File packFile;
            if (!this.config.getBoolean("texturepacks." + name, false) || !(packFile = new File(this.packFolder, name)).exists()) continue;
            this.applyPack(player, packFile);
        }
    }

    private void applyPack(Player player, File packFile) {
        try {
            byte[] hash = TexturePackForce.calculateSHA1(packFile);
            String url = "http://localhost:" + this.port + "/" + packFile.getName();
            player.setResourcePack(url, hash, "Applying Texture Pack: " + packFile.getName());
            player.sendMessage("\u00a7aApplied texture pack: \u00a7f" + packFile.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
            player.sendMessage("\u00a7cFailed to apply texture pack: " + packFile.getName());
        }
    }

    private static byte[] calculateSHA1(File file) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        try (FileInputStream fis = new FileInputStream(file);){
            int read;
            byte[] buffer = new byte[8192];
            while ((read = fis.read(buffer)) != -1) {
                digest.update(buffer, 0, read);
            }
        }
        return digest.digest();
    }

    private static class FileHandler
    implements HttpHandler {
        private final File file;

        public FileHandler(File file) {
            this.file = file;
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            try (FileInputStream fis = new FileInputStream(this.file);
                 OutputStream os = exchange.getResponseBody();){
                exchange.sendResponseHeaders(200, this.file.length());
                fis.transferTo(os);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

