/*
 * Decompiled with CFR 0.152.
 */
package net.none.combinemod.item;

import com.google.common.collect.Iterables;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.registries.ForgeRegistries;
import net.none.combinemod.procedures.TotemArmorBootsTickEventProcedure;

public abstract class TotemArmorItem
extends ArmorItem {
    public TotemArmorItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int m_266425_(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.m_266308_().m_20749_()] * 150;
            }

            public int m_7366_(ArmorItem.Type type) {
                return (new int[]{20, 50, 60, 20})[type.m_266308_().m_20749_()];
            }

            public int m_6646_() {
                return 90;
            }

            public SoundEvent m_7344_() {
                return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"item.totem.use"));
            }

            public Ingredient m_6230_() {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42747_)});
            }

            public String m_6082_() {
                return "totem_armor";
            }

            public float m_6651_() {
                return 4.0f;
            }

            public float m_6649_() {
                return 0.0f;
            }
        }, type, properties);
    }

    public static class Boots
    extends TotemArmorItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "combine_mod:textures/models/armor/totemnew_layer_1.png";
        }

        public void m_6883_(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.m_6883_(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).m_6168_(), (Object)itemstack)) {
                TotemArmorBootsTickEventProcedure.execute((LevelAccessor)world, itemstack);
            }
        }
    }

    public static class Leggings
    extends TotemArmorItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "combine_mod:textures/models/armor/totemnew_layer_2.png";
        }
    }

    public static class Chestplate
    extends TotemArmorItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "combine_mod:textures/models/armor/totemnew_layer_1.png";
        }
    }

    public static class Helmet
    extends TotemArmorItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "combine_mod:textures/models/armor/totemnew_layer_1.png";
        }
    }
}

