/*
 * Decompiled with CFR 0.152.
 */
package net.none.combinemod;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.none.combinemod.init.CombineModModBlockEntities;
import net.none.combinemod.init.CombineModModBlocks;
import net.none.combinemod.init.CombineModModEntities;
import net.none.combinemod.init.CombineModModItems;
import net.none.combinemod.init.CombineModModMenus;
import net.none.combinemod.init.CombineModModMobEffects;
import net.none.combinemod.init.CombineModModParticleTypes;
import net.none.combinemod.init.CombineModModSounds;
import net.none.combinemod.init.CombineModModTabs;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="combine_mod")
public class CombineModMod {
    public static final Logger LOGGER = LogManager.getLogger(CombineModMod.class);
    public static final String MODID = "combine_mod";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"combine_mod", (String)"combine_mod"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public CombineModMod(FMLJavaModLoadingContext context) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = context.getModEventBus();
        CombineModModSounds.REGISTRY.register(bus);
        CombineModModBlocks.REGISTRY.register(bus);
        CombineModModBlockEntities.REGISTRY.register(bus);
        CombineModModItems.REGISTRY.register(bus);
        CombineModModEntities.REGISTRY.register(bus);
        CombineModModTabs.REGISTRY.register(bus);
        CombineModModMobEffects.REGISTRY.register(bus);
        CombineModModMenus.REGISTRY.register(bus);
        CombineModModParticleTypes.REGISTRY.register(bus);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

