/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.api;

import de.geheimagentnr1.world_pre_generator.api.config.AbstractConfig;
import de.geheimagentnr1.world_pre_generator.api.events.NeoForgeEventHandlerInterface;
import java.util.function.Function;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMod {
    @NotNull
    private final ModContainer modContainer;
    @NotNull
    private final IEventBus modEventBus;

    protected AbstractMod(@NotNull ModContainer modContainer, @NotNull IEventBus modEventBus) {
        this.modContainer = modContainer;
        this.modEventBus = modEventBus;
        this.initMod();
    }

    @NotNull
    public abstract String getModId();

    protected abstract void initMod();

    protected <T extends AbstractConfig> T registerConfig(@NotNull Function<AbstractMod, T> configFactory) {
        AbstractConfig config = (AbstractConfig)configFactory.apply(this);
        this.modContainer.registerConfig(config.type(), (IConfigSpec)config.build());
        return (T)config;
    }

    protected void registerEventHandler(@NotNull NeoForgeEventHandlerInterface eventHandler) {
        NeoForge.EVENT_BUS.register((Object)eventHandler);
    }

    protected void registerModEventHandler(@NotNull Object eventHandler) {
        this.modEventBus.register(eventHandler);
    }

    @NotNull
    public ModContainer getModContainer() {
        return this.modContainer;
    }

    @NotNull
    public IEventBus getModEventBus() {
        return this.modEventBus;
    }
}

