/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.api.config;

import de.geheimagentnr1.world_pre_generator.api.AbstractMod;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractConfig {
    @NotNull
    private final AbstractMod abstractMod;
    @NotNull
    private final ModConfigSpec.Builder builder;
    @NotNull
    private final Map<String, ModConfigSpec.ConfigValue<?>> configValues;
    private ModConfigSpec spec;

    protected AbstractConfig(@NotNull AbstractMod abstractMod) {
        this.abstractMod = abstractMod;
        this.builder = new ModConfigSpec.Builder();
        this.configValues = new HashMap();
    }

    @NotNull
    public abstract ModConfig.Type type();

    public abstract boolean isEarlyLoad();

    protected abstract void registerConfigValues();

    @NotNull
    public ModConfigSpec build() {
        this.registerConfigValues();
        this.spec = this.builder.build();
        return this.spec;
    }

    protected void push(@NotNull String comment, @NotNull String key) {
        this.builder.comment(comment).push(key);
    }

    protected void pop() {
        this.builder.pop();
    }

    protected void registerConfigValue(@NotNull String comment, @NotNull String key, boolean defaultValue) {
        ModConfigSpec.BooleanValue value = this.builder.comment(comment).define(key, defaultValue);
        this.configValues.put(key, (ModConfigSpec.ConfigValue<?>)value);
    }

    protected void registerConfigValue(@NotNull String comment, @NotNull List<String> path, @NotNull BiFunction<ModConfigSpec.Builder, String, ModConfigSpec.ConfigValue<?>> definer) {
        String key = String.join((CharSequence)".", path);
        ModConfigSpec.ConfigValue<?> value = definer.apply(this.builder.comment(comment), key);
        this.configValues.put(key, value);
    }

    protected void registerConfigValue(@NotNull List<String> comments, @NotNull List<String> path, @NotNull BiFunction<ModConfigSpec.Builder, String, ModConfigSpec.ConfigValue<?>> definer) {
        String key = String.join((CharSequence)".", path);
        ModConfigSpec.ConfigValue<?> value = definer.apply(this.builder.comment(comments.toArray(new String[0])), key);
        this.configValues.put(key, value);
    }

    protected <T> T getValue(@NotNull Class<T> clazz, @NotNull String key) {
        ModConfigSpec.ConfigValue<?> configValue = this.configValues.get(key);
        if (configValue == null) {
            throw new IllegalArgumentException("Config value not found: " + key);
        }
        return (T)configValue.get();
    }

    protected <T> T getValue(@NotNull Class<T> clazz, @NotNull List<String> path) {
        String key = String.join((CharSequence)".", path);
        return this.getValue(clazz, key);
    }

    protected <T> void setValue(@NotNull Class<T> clazz, @NotNull String key, @NotNull T value) {
        ModConfigSpec.ConfigValue<?> configValue = this.configValues.get(key);
        if (configValue == null) {
            throw new IllegalArgumentException("Config value not found: " + key);
        }
        configValue.set(value);
    }

    @NotNull
    protected AbstractMod getAbstractMod() {
        return this.abstractMod;
    }
}

