/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.config;

import de.geheimagentnr1.world_pre_generator.api.AbstractMod;
import de.geheimagentnr1.world_pre_generator.api.config.AbstractConfig;
import de.geheimagentnr1.world_pre_generator.config.GenerationType;
import java.util.List;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class ServerConfig
extends AbstractConfig {
    @NotNull
    private static final String SEND_FEEDBACK_KEY = "send_feedback";
    @NotNull
    private static final String GENERATION_KEY = "generation";
    @NotNull
    private static final List<String> GENERATION_TYPE_KEY = List.of("generation", "type");
    @NotNull
    private static final List<String> GENERATION_SEMI_PARALLEL_TASK_COUNT_KEY = List.of("generation", "semi_parallel_task_count");
    @NotNull
    private static final String DELAYS_KEY = "delays";
    @NotNull
    private static final List<String> PRINT_DELAY_KEY = List.of("delays", "print");
    @NotNull
    private static final List<String> SAVE_DELAY_KEY = List.of("delays", "save");

    public ServerConfig(@NotNull AbstractMod _abstractMod) {
        super(_abstractMod);
    }

    @Override
    @NotNull
    public ModConfig.Type type() {
        return ModConfig.Type.SERVER;
    }

    @Override
    public boolean isEarlyLoad() {
        return false;
    }

    @Override
    protected void registerConfigValues() {
        this.registerConfigValue("Shall a pre generation feedback send to all online players?", SEND_FEEDBACK_KEY, true);
        this.push("Parameters for generation", GENERATION_KEY);
        this.registerConfigValue(List.of("Type of generation", String.valueOf((Object)GenerationType.SERIAL) + ": Every chunk one after another is generated.", String.valueOf((Object)GenerationType.SEMI_PARALLEL) + ": Multiple chunk generation tasks are created, but the generation is still serial (speed up the chunk generation)."), GENERATION_TYPE_KEY, (ModConfigSpec.Builder builder, String path) -> builder.defineEnum(path, (Enum)GenerationType.SERIAL));
        this.registerConfigValue("How many chunk generation tasks shall be start in parallel? If the value is \"0\", the number of processor cores is used.", GENERATION_SEMI_PARALLEL_TASK_COUNT_KEY, (ModConfigSpec.Builder builder, String path) -> builder.defineInRange(path, 0, 0, this.getProcessorCount() << 1));
        this.pop();
        this.push("Delays of the print and save tasks", DELAYS_KEY);
        this.registerConfigValue("Time between 2 status prints", PRINT_DELAY_KEY, (ModConfigSpec.Builder builder, String path) -> builder.defineInRange(path, 1, 1, Integer.MAX_VALUE));
        this.registerConfigValue("Time between 2 saving events", SAVE_DELAY_KEY, (ModConfigSpec.Builder builder, String path) -> builder.defineInRange(path, 180, 1, Integer.MAX_VALUE));
        this.pop();
    }

    public boolean isSendFeedbackEnabled() {
        return this.getValue(Boolean.class, SEND_FEEDBACK_KEY);
    }

    public void setSendFeedback(boolean sendFeedback) {
        this.setValue(Boolean.class, SEND_FEEDBACK_KEY, sendFeedback);
    }

    public int getPrintDelay() {
        return this.getValue(Integer.class, PRINT_DELAY_KEY);
    }

    public int getSaveDelay() {
        return this.getValue(Integer.class, SAVE_DELAY_KEY);
    }

    @NotNull
    public GenerationType getGenerationType() {
        return this.getValue(GenerationType.class, GENERATION_TYPE_KEY);
    }

    public int getGenerationSemiParallelTaskCount() {
        int threadCount = this.getValue(Integer.class, GENERATION_SEMI_PARALLEL_TASK_COUNT_KEY);
        return threadCount == 0 ? this.getProcessorCount() : threadCount;
    }

    private int getProcessorCount() {
        return Runtime.getRuntime().availableProcessors();
    }
}

