/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.elements.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.geheimagentnr1.world_pre_generator.api.commands.CommandInterface;
import de.geheimagentnr1.world_pre_generator.config.ServerConfig;
import de.geheimagentnr1.world_pre_generator.elements.commands.models.TaskRow;
import de.geheimagentnr1.world_pre_generator.elements.commands.models.TasksMessage;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.PregenTask;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.TaskType;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.data.WorldPos;
import de.geheimagentnr1.world_pre_generator.elements.workers.PregenWorker;
import de.geheimagentnr1.world_pre_generator.helpers.DimensionHelper;
import java.util.ArrayList;
import lombok.Generated;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.core.SectionPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PregenCommand
implements CommandInterface {
    @NotNull
    private final ServerConfig serverConfig;
    @NotNull
    private final PregenWorker pregenWorker;

    @Override
    @NotNull
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        LiteralArgumentBuilder pregenCommand = (LiteralArgumentBuilder)Commands.literal((String)"pregen").requires(source -> source.hasPermission(2));
        pregenCommand.then(Commands.literal((String)"clear").executes(this::clear));
        LiteralArgumentBuilder startCommand = Commands.literal((String)"start");
        for (TaskType taskType : TaskType.values()) {
            startCommand.then(Commands.literal((String)taskType.getSerializedName()).then(Commands.argument((String)"center", (ArgumentType)ColumnPosArgument.columnPos()).then(((RequiredArgumentBuilder)Commands.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> this.start((CommandContext<CommandSourceStack>)context, taskType, false))).then(Commands.argument((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(context -> this.start((CommandContext<CommandSourceStack>)context, taskType, true))))));
        }
        pregenCommand.then(Commands.literal((String)"gen").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).then(Commands.literal((String)"cancel").executes(this::cancel))).then(Commands.literal((String)"pause").executes(this::pause))).then(Commands.literal((String)"resume").executes(this::resume))).then((ArgumentBuilder)startCommand)));
        pregenCommand.then(Commands.literal((String)"list").executes(this::printList));
        pregenCommand.then(((LiteralArgumentBuilder)Commands.literal((String)"sendFeedback").executes(this::showSendFeedback)).then(Commands.argument((String)"isFeedbackEnabled", (ArgumentType)BoolArgumentType.bool()).executes(this::setSendFeedback)));
        return pregenCommand;
    }

    private int printList(@NotNull CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (this.pregenWorker.getQueue().noTasks()) {
            source.sendSuccess(() -> Component.literal((String)"Pregeneration Tasklist is empty."), false);
        } else {
            source.sendSuccess(() -> Component.literal((String)"Pregeneration Tasklist:"), false);
            ArrayList<PregenTask> activeTasks = this.pregenWorker.getQueue().getActiveTasks();
            ArrayList<PregenTask> pausedTasks = this.pregenWorker.getQueue().getPausedTasks();
            if (!activeTasks.isEmpty()) {
                source.sendSuccess(() -> Component.literal((String)"Queued Tasks:"), false);
                this.printTasks(source, activeTasks);
            }
            if (!pausedTasks.isEmpty()) {
                source.sendSuccess(() -> Component.literal((String)"Paused Tasks:"), false);
                this.printTasks(source, pausedTasks);
            }
        }
        return 1;
    }

    private void printTasks(@NotNull CommandSourceStack source, @NotNull ArrayList<PregenTask> tasks) {
        TasksMessage tasksMessage = new TasksMessage();
        tasksMessage.add(new TaskRow("Dimension", "Type", "Center", null, null, "Radius", "Forced"));
        tasksMessage.addAll(tasks);
        for (String message : tasksMessage.buildMessages()) {
            source.sendSuccess(() -> Component.literal((String)message), false);
        }
    }

    private int start(@NotNull CommandContext<CommandSourceStack> context, @NotNull TaskType taskType, boolean checkForced) throws CommandSyntaxException {
        int chunkZ;
        int chunkX;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ColumnPos center = ColumnPosArgument.getColumnPos(context, (String)"center");
        int radius = IntegerArgumentType.getInteger(context, (String)"radius");
        int chunkRadius = switch (taskType) {
            case TaskType.BLOCK -> {
                ChunkPos chunkCenter = center.toChunkPos();
                chunkX = chunkCenter.x;
                chunkZ = chunkCenter.z;
                yield SectionPos.blockToSectionCoord((int)radius);
            }
            case TaskType.CHUNK -> {
                chunkX = center.x();
                chunkZ = center.z();
                yield radius;
            }
            default -> throw new IllegalArgumentException("Invalid task type");
        };
        ResourceKey dimension = DimensionArgument.getDimension(context, (String)"dimension").dimension();
        boolean force = checkForced && BoolArgumentType.getBool(context, (String)"force");
        this.pregenWorker.getQueue().startTask(new PregenTask(taskType, new WorldPos(chunkX, chunkZ), chunkRadius, (ResourceKey<Level>)dimension, force));
        source.sendSuccess(() -> Component.literal((String)String.format("Task for %s got queued.", DimensionHelper.getNameOfDim((ResourceKey<Level>)dimension))), true);
        return 1;
    }

    private int resume(@NotNull CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ResourceKey dimension = DimensionArgument.getDimension(context, (String)"dimension").dimension();
        this.pregenWorker.getQueue().resumeTask((ResourceKey<Level>)dimension);
        source.sendSuccess(() -> Component.literal((String)String.format("Task for %s was resumed.", DimensionHelper.getNameOfDim((ResourceKey<Level>)dimension))), true);
        return 1;
    }

    private int pause(@NotNull CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ResourceKey dimension = DimensionArgument.getDimension(context, (String)"dimension").dimension();
        this.pregenWorker.getQueue().pauseTask((ResourceKey<Level>)dimension);
        source.sendSuccess(() -> Component.literal((String)String.format("Task for %s was paused.", DimensionHelper.getNameOfDim((ResourceKey<Level>)dimension))), true);
        return 1;
    }

    private int cancel(@NotNull CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ResourceKey dimension = DimensionArgument.getDimension(context, (String)"dimension").dimension();
        this.pregenWorker.getQueue().cancelTask((ResourceKey<Level>)dimension);
        source.sendSuccess(() -> Component.literal((String)String.format("Task for %s was canceled.", DimensionHelper.getNameOfDim((ResourceKey<Level>)dimension))), true);
        return 1;
    }

    private int clear(@NotNull CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        this.pregenWorker.getQueue().clear();
        source.sendSuccess(() -> Component.literal((String)"All Task were canceled."), true);
        return 1;
    }

    private int showSendFeedback(@NotNull CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (this.serverConfig.isSendFeedbackEnabled()) {
            source.sendSuccess(() -> Component.literal((String)"Feedback is enabled."), false);
        } else {
            source.sendSuccess(() -> Component.literal((String)"Feedback is disabled."), false);
        }
        return 1;
    }

    private int setSendFeedback(@NotNull CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        this.serverConfig.setSendFeedback(BoolArgumentType.getBool(context, (String)"isFeedbackEnabled"));
        if (this.serverConfig.isSendFeedbackEnabled()) {
            source.sendSuccess(() -> Component.literal((String)"Feedback is now enabled."), false);
        } else {
            source.sendSuccess(() -> Component.literal((String)"Feedback is now disabled."), false);
        }
        return 1;
    }

    @Generated
    public PregenCommand(@NotNull ServerConfig serverConfig, @NotNull PregenWorker pregenWorker) {
        if (serverConfig == null) {
            throw new NullPointerException("serverConfig is marked non-null but is null");
        }
        if (pregenWorker == null) {
            throw new NullPointerException("pregenWorker is marked non-null but is null");
        }
        this.serverConfig = serverConfig;
        this.pregenWorker = pregenWorker;
    }
}

