/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.elements.queues.lists;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.PregenTask;
import de.geheimagentnr1.world_pre_generator.save.Savable;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiConsumer;
import lombok.Generated;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PregenTaskList
implements Savable<JsonArray> {
    @Generated
    private static final Logger log = LogManager.getLogger(PregenTaskList.class);
    @NotNull
    private final ArrayList<PregenTask> task_list = new ArrayList();

    @NotNull
    public Optional<PregenTask> runFor(@NotNull ResourceKey<Level> dimension, @NotNull BiConsumer<ArrayList<PregenTask>, Integer> runner) {
        for (int i = 0; i < this.task_list.size(); ++i) {
            PregenTask task = this.task_list.get(i);
            if (task.getDimension() != dimension) continue;
            runner.accept(this.task_list, i);
            return Optional.of(task);
        }
        return Optional.empty();
    }

    public void addOrReplace(@Nullable PregenTask new_task) {
        if (new_task == null) {
            return;
        }
        if (this.runFor(new_task.getDimension(), (list, index) -> list.set((int)index, new_task)).isEmpty()) {
            this.task_list.add(new_task);
        }
    }

    @NotNull
    public ArrayList<PregenTask> getTaskList() {
        return this.task_list;
    }

    @NotNull
    public Optional<PregenTask> getFirst() {
        return this.task_list.isEmpty() ? Optional.empty() : Optional.of(this.task_list.get(0));
    }

    public boolean isEmpty() {
        return this.task_list.isEmpty();
    }

    @NotNull
    public Optional<PregenTask> getAndRemoveBy(@NotNull ResourceKey<Level> dimension) {
        return this.runFor(dimension, (list, index) -> this.task_list.remove((int)index).shutdown());
    }

    public void removeFirst() {
        this.task_list.remove(0).shutdown();
    }

    public void removeBy(@NotNull ResourceKey<Level> dimension) {
        this.runFor(dimension, (list, index) -> this.task_list.remove((int)index).shutdown());
    }

    public void clear() {
        this.task_list.forEach(PregenTask::shutdown);
        this.task_list.clear();
    }

    @Override
    @NotNull
    public JsonArray write() {
        JsonArray json = new JsonArray();
        this.task_list.forEach(task -> {
            task.shutdown();
            json.add((JsonElement)task.write());
        });
        return json;
    }

    @Override
    public void read(@NotNull JsonArray jsonArray) {
        this.clear();
        for (JsonElement element : jsonArray) {
            if (!element.isJsonObject()) continue;
            JsonObject json = element.getAsJsonObject();
            PregenTask task = new PregenTask();
            try {
                task.read(json);
                this.addOrReplace(task);
            }
            catch (IllegalArgumentException exception) {
                log.error("Invalid task: Task is not added to queue.", (Throwable)exception);
            }
        }
    }

    public void checkTasks(@NotNull MinecraftServer server) {
        for (int i = 0; i < this.task_list.size(); ++i) {
            PregenTask task = this.task_list.get(i);
            if (!task.isDimensionInvalid(server)) continue;
            this.task_list.remove(i);
            --i;
            log.error("Invalid task: Task is removed from queue.");
        }
    }
}

