/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.elements.queues.tasks;

import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public abstract class TimedSubTask {
    @NotNull
    private final Stopwatch timer = Stopwatch.createStarted();

    public void start() {
        this.timer.reset().start();
    }

    void resume() {
        this.timer.reset().start();
    }

    void pause() {
        this.timer.reset();
    }

    public void stop() {
        this.timer.reset();
    }

    public void run() {
        if (this.timer.elapsed(TimeUnit.SECONDS) >= (long)this.getDelay()) {
            this.execute();
            this.timer.reset().start();
        }
    }

    abstract int getDelay();

    protected abstract void execute();
}

