/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.data;

import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.data.RegionPregenData;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.data.WorldPos;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class WorldPregenData {
    @NotNull
    private final WorldPos start_chunk_pos;
    @NotNull
    private final WorldPos end_chunk_pos;
    private final int x_region_count;
    @NotNull
    private final WorldPos start_region_pos;
    private int region_index = 0;
    private long chunk_index = 0L;
    private final long chunk_count;
    @NotNull
    private RegionPregenData current_region;

    public WorldPregenData(int center_x, int center_z, int radius) {
        this.start_chunk_pos = new WorldPos(center_x - radius, center_z - radius);
        this.end_chunk_pos = new WorldPos(center_x + radius - 1, center_z + radius - 1);
        long diameter = (long)radius << 1;
        this.start_region_pos = new WorldPos((int)Math.floor((double)(this.start_chunk_pos.getX() + (this.start_chunk_pos.getX() < 0 ? 0 : 1)) / 32.0), (int)Math.floor((double)(this.start_chunk_pos.getZ() + (this.start_chunk_pos.getZ() < 0 ? 0 : 1)) / 32.0));
        WorldPos end_region_pos = new WorldPos((int)Math.ceil((double)(this.end_chunk_pos.getX() + (this.end_chunk_pos.getX() < 0 ? 0 : 1)) / 32.0), (int)Math.ceil((double)(this.end_chunk_pos.getZ() + (this.end_chunk_pos.getZ() < 0 ? 0 : 1)) / 32.0));
        this.x_region_count = end_region_pos.getX() - this.start_region_pos.getX();
        this.chunk_count = diameter * diameter;
        this.current_region = new RegionPregenData(this.start_region_pos, this.start_chunk_pos, this.end_chunk_pos);
    }

    @NotNull
    public synchronized Optional<WorldPos> nextChunk() {
        if (this.current_region.isFullyGenerated()) {
            ++this.region_index;
            this.current_region = new RegionPregenData(new WorldPos(this.start_region_pos.getX() + this.region_index % this.x_region_count, this.start_region_pos.getZ() + this.region_index / this.x_region_count), this.start_chunk_pos, this.end_chunk_pos);
        }
        Optional<WorldPos> pos = this.current_region.nextChunk();
        ++this.chunk_index;
        return pos;
    }

    public synchronized long getChunkIndex() {
        return this.chunk_index;
    }

    public synchronized void setChunkIndex(int _chunk_index) {
        this.chunk_index = _chunk_index;
    }

    public long getChunkCount() {
        return this.chunk_count;
    }
}

